/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.truetype.CreateSubset;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.cwt.font.truetype.TrueTypeException;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PDFontTrueTypeTools {
    private static final Attribute ATTR_CWTFONT = new Attribute("cwtfont");

    protected static TTFont basicSubset(PDFont pDFont, TTFont tTFont, Set<Integer> set) throws IOException {
        TTFont tTFont2;
        CreateSubset createSubset = new CreateSubset(tTFont, set);
        try {
            tTFont2 = createSubset.compute();
        }
        catch (TrueTypeException trueTypeException) {
            tTFont2 = tTFont;
        }
        RandomAccessByteArray randomAccessByteArray = new RandomAccessByteArray(null);
        TTFontSerializer tTFontSerializer = new TTFontSerializer();
        tTFontSerializer.write((IRandomAccess)randomAccessByteArray, tTFont2);
        pDFont.getFontDescriptor().setFontFile2(randomAccessByteArray.toByteArray());
        return tTFont2;
    }

    protected static void embedFontFile(PDFont pDFont, ILocator iLocator) throws IOException {
        InputStream inputStream = iLocator.getInputStream();
        try {
            byte[] byArray = StreamTools.toByteArray((InputStream)inputStream);
            ((PDFontDescriptorEmbedded)pDFont.getFontDescriptor()).setFontFile2(byArray);
        }
        finally {
            StreamTools.close((InputStream)inputStream);
        }
        PDFontTrueTypeTools.subset(pDFont);
    }

    public static TTFont getTTFont(PDFont pDFont) {
        TTFont tTFont = (TTFont)pDFont.getAttribute((Object)ATTR_CWTFONT);
        if (tTFont != null) {
            return tTFont;
        }
        ILocator iLocator = PlatformFontTools.getFontFile(pDFont);
        if (iLocator == null) {
            return null;
        }
        try {
            tTFont = TTFont.createFromLocator((ILocator)iLocator);
            PDFontTrueTypeTools.setTTFont(pDFont, tTFont);
            return tTFont;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected static Map getTTFontCMap(PDFont pDFont) throws TrueTypeException {
        TTFont tTFont = PDFontTrueTypeTools.getTTFont(pDFont);
        Map map = null;
        PDFontDescriptor pDFontDescriptor = null;
        try {
            pDFontDescriptor = pDFont.getFontDescriptor();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        map = pDFontDescriptor == null ? tTFont.getCMapsAt(3, 1) : (pDFontDescriptor.isSymbolic() ? tTFont.getCMapsAt(3, 0) : tTFont.getCMapsAt(3, 1));
        if (map == null) {
            throw new TrueTypeException("No suitable CMap found");
        }
        return map;
    }

    public static void setTTFont(PDFont pDFont, TTFont tTFont) {
        pDFont.setAttribute((Object)ATTR_CWTFONT, (Object)tTFont);
    }

    public static void subset(PDFont pDFont) throws IOException {
        if (!(pDFont instanceof PDFontTrueType)) {
            throw new IllegalArgumentException("subsetting " + pDFont.getClass().getName() + " not supported");
        }
        TTFont tTFont = PDFontTrueTypeTools.getTTFont(pDFont);
        Map map = null;
        try {
            map = PDFontTrueTypeTools.getTTFontCMap(pDFont);
        }
        catch (TrueTypeException trueTypeException) {
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = pDFont.getFirstChar();
        int n2 = pDFont.getLastChar();
        int n3 = n;
        while (n3 <= n2) {
            int n4 = pDFont.getEncoding().getDecoded(n3);
            Integer n5 = (Integer)map.get(new Integer(n4));
            if (n5 != null) {
                hashSet.add(n5);
            }
            ++n3;
        }
        TTFont tTFont2 = PDFontTrueTypeTools.basicSubset(pDFont, tTFont, hashSet);
        PDFontTrueTypeTools.setTTFont(pDFont, tTFont2);
    }

    public static void subset(PDFont pDFont, Set<PDGlyphs> set) throws IOException, TrueTypeException {
        if (!(pDFont instanceof PDFontTrueType)) {
            throw new IllegalArgumentException("subsetting " + pDFont.getClass().getName() + " not supported");
        }
        TTFont tTFont = PDFontTrueTypeTools.getTTFont(pDFont);
        Map map = null;
        try {
            map = PDFontTrueTypeTools.getTTFontCMap(pDFont);
        }
        catch (TrueTypeException trueTypeException) {
            return;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (PDGlyphs pDGlyphs : set) {
            int n = pDGlyphs.getDecoded();
            Integer n2 = (Integer)map.get(new Integer(n));
            if (n2 == null) continue;
            hashSet.add(n2);
        }
        TTFont tTFont2 = PDFontTrueTypeTools.basicSubset(pDFont, tTFont, hashSet);
        PDFontTrueTypeTools.setTTFont(pDFont, tTFont2);
    }
}

