/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDXObject;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class ImageConverterAwt2Pdf {
    public static final String IMAGEWRITER_JPEG = "JPEG";
    private final BufferedImage bufferedImage;
    private PDImage pdImage;
    private boolean preferJpeg = false;
    private float compressionQuality = 0.75f;

    public ImageConverterAwt2Pdf(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    protected PDImage createPDImage() {
        this.pdImage = (PDImage)PDImage.META.createNew();
        this.renderImage();
        if (this.getPDImage().cosGetStream().getFirstFilter() == null) {
            try {
                this.getPDImage().cosGetStream().addFilter(Filter.CN_Filter_FlateDecode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.pdImage;
    }

    public float getCompressionQuality() {
        return this.compressionQuality;
    }

    public PDImage getPDImage() {
        if (this.pdImage == null) {
            this.pdImage = this.createPDImage();
        }
        return this.pdImage;
    }

    public boolean isPreferJpeg() {
        return this.preferJpeg;
    }

    protected void renderGray() {
        byte[] byArray;
        byte[] byArray2;
        this.getPDImage().cosSetColorSpace(PDColorSpace.CN_CS_DeviceGray);
        int n = this.bufferedImage.getColorModel().getPixelSize();
        this.getPDImage().setBitsPerComponent(n / this.bufferedImage.getColorModel().getNumComponents());
        if (n / this.bufferedImage.getColorModel().getNumComponents() != 8) {
            throw new UnsupportedOperationException();
        }
        Raster raster = this.bufferedImage.getData();
        this.getPDImage().setWidth(raster.getWidth());
        this.getPDImage().setHeight(raster.getHeight());
        if (!this.bufferedImage.getColorModel().hasAlpha() && this.preferJpeg && this.renderJpegEncoded()) {
            return;
        }
        try {
            byArray2 = (byte[])raster.getDataElements(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), null);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
        if (this.bufferedImage.getColorModel().hasAlpha()) {
            byArray = new byte[byArray2.length / 2];
            byte[] byArray3 = new byte[byArray2.length / 2];
            PDImage pDImage = (PDImage)PDImage.META.createNew();
            pDImage.cosSetColorSpace(PDColorSpace.CN_CS_DeviceGray);
            pDImage.setBitsPerComponent(8);
            pDImage.setWidth(raster.getWidth());
            pDImage.setHeight(raster.getHeight());
            int n2 = 0;
            while (n2 < byArray.length) {
                byArray[n2] = byArray2[n2 * 2];
                byArray3[n2] = byArray2[n2 * 2 + 1];
                ++n2;
            }
            pDImage.setBytes(byArray3);
            this.getPDImage().setSMask((PDXObject)pDImage);
        } else {
            byArray = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        this.getPDImage().setBytes(byArray);
    }

    protected void renderImage() {
        ColorModel colorModel = this.bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.renderIndexed();
            return;
        }
        if (colorModel instanceof ComponentColorModel && colorModel.getColorSpace().equals(ColorSpace.getInstance(1003))) {
            this.renderGray();
            return;
        }
        if (colorModel instanceof ComponentColorModel && colorModel.getColorSpace().isCS_sRGB()) {
            this.renderRGB();
            return;
        }
        colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.clearRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        graphics2D.drawImage((Image)this.bufferedImage, 0, 0, null);
        graphics2D.dispose();
        this.renderRGB();
    }

    protected void renderIndexed() {
        byte[] byArray;
        IndexColorModel indexColorModel = (IndexColorModel)this.bufferedImage.getColorModel();
        int[] nArray = new int[indexColorModel.getMapSize()];
        indexColorModel.getRGBs(nArray);
        byte[] byArray2 = new byte[nArray.length * 3];
        int n = 0;
        while (n < nArray.length) {
            byArray2[n * 3] = (byte)(nArray[n] >> 16);
            byArray2[n * 3 + 1] = (byte)(nArray[n] >> 8);
            byArray2[n * 3 + 2] = (byte)nArray[n];
            ++n;
        }
        COSArray cOSArray = COSArray.create((int)4);
        cOSArray.add((COSObject)PDColorSpace.CN_CS_Indexed);
        cOSArray.add((COSObject)PDColorSpace.CN_CS_DeviceRGB);
        cOSArray.add((COSObject)COSInteger.create((int)(indexColorModel.getMapSize() - 1)));
        cOSArray.add((COSObject)COSString.create((byte[])byArray2));
        this.getPDImage().cosSetColorSpace(cOSArray);
        int n2 = this.bufferedImage.getColorModel().getPixelSize();
        this.getPDImage().setBitsPerComponent(n2);
        Raster raster = this.bufferedImage.getData();
        this.getPDImage().setWidth(raster.getWidth());
        this.getPDImage().setHeight(raster.getHeight());
        int n3 = (raster.getWidth() * n2 + 7) / 8;
        byte[] byArray3 = new byte[n3 * raster.getHeight()];
        int n4 = ((IndexColorModel)this.bufferedImage.getColorModel()).getTransparentPixel();
        if (n4 != -1) {
            byArray = new byte[raster.getWidth() * raster.getHeight()];
            n = 0;
            while (n < byArray.length) {
                byArray[n] = -1;
                ++n;
            }
        } else {
            byArray = null;
        }
        n = raster.getMinY();
        while (n < raster.getHeight() - raster.getMinY()) {
            byte[] byArray4;
            try {
                byArray4 = (byte[])raster.getDataElements(raster.getMinX(), n, raster.getWidth(), 1, null);
            }
            catch (ClassCastException classCastException) {
                throw new UnsupportedOperationException();
            }
            int n5 = 0;
            while (n5 < byArray4.length) {
                int n6 = n5 * n2 / 8 + n * n3;
                byArray3[n6] = (byte)(byArray3[n6] | byArray4[n5] << 8 - n2 - n5 * n2 % 8);
                if ((byArray4[n5] & 0xFF) == n4) {
                    byArray[n * raster.getWidth() + n5] = 0;
                }
                ++n5;
            }
            ++n;
        }
        if (byArray != null) {
            PDImage pDImage = (PDImage)PDImage.META.createNew();
            pDImage.cosSetColorSpace(PDColorSpace.CN_CS_DeviceGray);
            pDImage.setBitsPerComponent(8);
            pDImage.setWidth(raster.getWidth());
            pDImage.setHeight(raster.getHeight());
            pDImage.setBytes(byArray);
            pDImage.cosGetStream().addFilter(Filter.CN_Filter_FlateDecode);
            this.getPDImage().setSMask((PDXObject)pDImage);
        }
        this.getPDImage().setBytes(byArray3);
    }

    protected boolean renderJpegEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        ImageWriter imageWriter;
        ImageOutputStream imageOutputStream = null;
        try {
            imageWriter = ImageIO.getImageWritersByFormatName(IMAGEWRITER_JPEG).next();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        try {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
                imageWriter.setOutput(imageOutputStream);
                JPEGImageWriteParam jPEGImageWriteParam = new JPEGImageWriteParam(Locale.getDefault());
                jPEGImageWriteParam.setCompressionMode(2);
                jPEGImageWriteParam.setCompressionQuality(this.getCompressionQuality());
                jPEGImageWriteParam.setProgressiveMode(3);
                imageWriter.write(null, new IIOImage(this.bufferedImage, null, null), jPEGImageWriteParam);
            }
            catch (IOException iOException) {
                if (imageWriter != null) {
                    imageWriter.reset();
                    imageWriter.dispose();
                }
                if (imageOutputStream != null) {
                    try {
                        imageOutputStream.flush();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    try {
                        imageOutputStream.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (imageWriter != null) {
                imageWriter.reset();
                imageWriter.dispose();
            }
            if (imageOutputStream != null) {
                try {
                    imageOutputStream.flush();
                }
                catch (IOException iOException) {}
                try {
                    imageOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.getPDImage().cosGetStream().addFilter(Filter.CN_Filter_DCTDecode);
        this.getPDImage().cosGetStream().setEncodedBytes(byteArrayOutputStream.toByteArray());
        return true;
    }

    protected void renderRGB() {
        byte[] byArray;
        byte[] byArray2;
        this.getPDImage().cosSetColorSpace(PDColorSpace.CN_CS_DeviceRGB);
        int n = this.bufferedImage.getColorModel().getPixelSize();
        if (n / this.bufferedImage.getColorModel().getNumComponents() != 8) {
            throw new UnsupportedOperationException();
        }
        this.getPDImage().setBitsPerComponent(8);
        Raster raster = this.bufferedImage.getData();
        this.getPDImage().setWidth(raster.getWidth());
        this.getPDImage().setHeight(raster.getHeight());
        if (!this.bufferedImage.getColorModel().hasAlpha() && this.preferJpeg && this.renderJpegEncoded()) {
            return;
        }
        try {
            byArray2 = (byte[])raster.getDataElements(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), null);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
        if (this.bufferedImage.getColorModel().hasAlpha()) {
            byArray = new byte[byArray2.length / 4 * 3];
            byte[] byArray3 = new byte[byArray2.length / 4];
            PDImage pDImage = (PDImage)PDImage.META.createNew();
            pDImage.cosSetColorSpace(PDColorSpace.CN_CS_DeviceGray);
            pDImage.setBitsPerComponent(8);
            pDImage.setWidth(raster.getWidth());
            pDImage.setHeight(raster.getHeight());
            int n2 = 0;
            while (n2 < byArray2.length / 4) {
                byArray[n2 * 3] = byArray2[n2 * 4];
                byArray[n2 * 3 + 1] = byArray2[n2 * 4 + 1];
                byArray[n2 * 3 + 2] = byArray2[n2 * 4 + 2];
                byArray3[n2] = byArray2[n2 * 4 + 3];
                ++n2;
            }
            pDImage.setBytes(byArray3);
            pDImage.cosGetStream().addFilter(Filter.CN_Filter_FlateDecode);
            this.getPDImage().setSMask((PDXObject)pDImage);
        } else {
            byArray = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        this.getPDImage().setBytes(byArray);
    }

    public void setCompressionQuality(float f) {
        this.compressionQuality = f;
    }

    public void setPreferJpeg(boolean bl) {
        this.preferJpeg = bl;
    }
}

