/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSInterpreterFrame;
import de.intarsys.pdf.content.CSNotSupported;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSWarning;
import de.intarsys.pdf.content.ICSExceptionHandler;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.tools.string.StringTools;
import java.util.Map;

public abstract class CSInterpreter
implements ICSInterpreter {
    protected static final int PageLevel = 0;
    protected static final int TextObject = 1;
    protected static final int ShadingObject = 2;
    protected static final int ExternalObject = 3;
    protected static final int InLineImageObject = 4;
    protected static final int ClippingObject = 5;
    protected static final int PathObject = 6;
    private Map options;
    private ICSExceptionHandler exceptionHandler;
    protected CSInterpreterFrame frame;
    private boolean interruptible;

    public CSInterpreter(Map map) {
        this.options = map;
    }

    private boolean checkInterrupt() {
        return this.isInterruptible() && Thread.currentThread().isInterrupted();
    }

    protected CSInterpreterFrame createFrame() {
        return new CSInterpreterFrame();
    }

    protected void decCompatibilitySectionDepth() {
        --this.frame.compatibilitySectionDepth;
    }

    protected PDDocument getDoc() {
        if (this.frame.doc == null && this.getResources() != null) {
            this.frame.doc = this.getResources().getDoc();
        }
        return this.frame.doc;
    }

    @Override
    public ICSExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public Map getOptions() {
        return this.options;
    }

    protected PDResources getResources() {
        return this.frame.resources;
    }

    protected void handleError(CSError cSError) throws CSException {
        if (this.exceptionHandler == null) {
            throw cSError;
        }
        this.exceptionHandler.error(cSError);
    }

    protected void handleWarning(CSWarning cSWarning) throws CSException {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.warning(cSWarning);
        }
    }

    protected void incCompatibilitySectionDepth() {
        ++this.frame.compatibilitySectionDepth;
    }

    protected boolean isCompatibilitySection() {
        return this.frame.compatibilitySectionDepth > 0;
    }

    public boolean isInterruptible() {
        return this.interruptible;
    }

    protected void notSupported(CSOperation cSOperation) throws CSException {
        if (this.isCompatibilitySection()) {
            return;
        }
        this.handleWarning(new CSNotSupported("operation " + StringTools.safeString((Object)cSOperation) + " not supported"));
    }

    @Override
    public void process(CSContent cSContent, PDResources pDResources) throws CSException {
        if (cSContent == null) {
            return;
        }
        CSInterpreterFrame cSInterpreterFrame = this.frame;
        try {
            this.frame = this.createFrame();
            this.frame.resources = pDResources;
            if (this.frame.resources == null && cSInterpreterFrame != null) {
                this.frame.resources = cSInterpreterFrame.resources;
            }
            if (this.frame.resources != null) {
                try {
                    this.frame.defaultCMYK = this.frame.resources.getColorSpaceResource(PDColorSpace.CN_CS_DefaultCMYK);
                }
                catch (Exception exception) {
                    this.getExceptionHandler().warning(new CSWarning(exception));
                }
                try {
                    this.frame.defaultRGB = this.frame.resources.getColorSpaceResource(PDColorSpace.CN_CS_DefaultRGB);
                }
                catch (Exception exception) {
                    this.getExceptionHandler().warning(new CSWarning(exception));
                }
                try {
                    this.frame.defaultGray = this.frame.resources.getColorSpaceResource(PDColorSpace.CN_CS_DefaultGray);
                }
                catch (Exception exception) {
                    this.getExceptionHandler().warning(new CSWarning(exception));
                }
            } else {
                this.frame.defaultCMYK = null;
                this.frame.defaultRGB = null;
                this.frame.defaultGray = null;
            }
            int n = cSContent.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.checkInterrupt()) {
                    break;
                }
                CSOperation cSOperation = cSContent.getOperation(n2);
                try {
                    this.process(cSOperation);
                }
                catch (CSError cSError) {
                    this.handleError(cSError);
                }
                catch (CSWarning cSWarning) {
                    this.handleWarning(cSWarning);
                }
                catch (RuntimeException runtimeException) {
                    this.handleError(new CSError("unexpected exception", runtimeException));
                }
                ++n2;
            }
        }
        finally {
            this.frame = cSInterpreterFrame;
        }
    }

    protected void process(CSOperation cSOperation) throws CSException {
        byte[] byArray = cSOperation.getOperatorToken();
        switch (byArray[0]) {
            case 113: {
                this.render_q(cSOperation);
                break;
            }
            case 81: {
                this.render_Q(cSOperation);
                break;
            }
            case 84: {
                switch (byArray[1]) {
                    case 106: {
                        this.render_Tj(cSOperation);
                        break;
                    }
                    case 74: {
                        this.render_TJ(cSOperation);
                        break;
                    }
                    case 102: {
                        this.render_Tf(cSOperation);
                        break;
                    }
                    case 100: {
                        this.render_Td(cSOperation);
                        break;
                    }
                    case 76: {
                        this.render_TL(cSOperation);
                        break;
                    }
                    case 68: {
                        this.render_TD(cSOperation);
                        break;
                    }
                    case 99: {
                        this.render_Tc(cSOperation);
                        break;
                    }
                    case 109: {
                        this.render_Tm(cSOperation);
                        break;
                    }
                    case 114: {
                        this.render_Tr(cSOperation);
                        break;
                    }
                    case 115: {
                        this.render_Ts(cSOperation);
                        break;
                    }
                    case 119: {
                        this.render_Tw(cSOperation);
                        break;
                    }
                    case 122: {
                        this.render_Tz(cSOperation);
                        break;
                    }
                    case 42: {
                        this.render_Tstar(cSOperation);
                    }
                }
                break;
            }
            case 110: {
                this.render_n(cSOperation);
                break;
            }
            case 115: {
                if (byArray.length == 1) {
                    this.render_s(cSOperation);
                    break;
                }
                switch (byArray[1]) {
                    case 99: {
                        if (byArray.length == 2) {
                            this.render_sc(cSOperation);
                            break;
                        }
                        this.render_scn(cSOperation);
                        break;
                    }
                    case 104: {
                        this.render_sh(cSOperation);
                    }
                }
                break;
            }
            case 103: {
                if (byArray.length == 1) {
                    this.render_g(cSOperation);
                    break;
                }
                this.render_gs(cSOperation);
                break;
            }
            case 114: {
                switch (byArray[1]) {
                    case 101: {
                        this.render_re(cSOperation);
                        break;
                    }
                    case 103: {
                        this.render_rg(cSOperation);
                        break;
                    }
                    case 105: {
                        this.render_ri(cSOperation);
                    }
                }
                break;
            }
            case 82: {
                this.render_RG(cSOperation);
                break;
            }
            case 109: {
                this.render_m(cSOperation);
                break;
            }
            case 108: {
                this.render_l(cSOperation);
                break;
            }
            case 102: {
                if (byArray.length == 1) {
                    this.render_f(cSOperation);
                    break;
                }
                this.render_fstar(cSOperation);
                break;
            }
            case 66: {
                if (byArray.length == 1) {
                    this.render_B(cSOperation);
                    break;
                }
                switch (byArray[1]) {
                    case 42: {
                        this.render_Bstar(cSOperation);
                        break;
                    }
                    case 84: {
                        this.render_BT(cSOperation);
                        break;
                    }
                    case 77: {
                        this.render_BMC(cSOperation);
                        break;
                    }
                    case 68: {
                        this.render_BDC(cSOperation);
                        break;
                    }
                    case 88: {
                        this.render_BX(cSOperation);
                    }
                }
                break;
            }
            case 98: {
                if (byArray.length == 1) {
                    this.render_b(cSOperation);
                    break;
                }
                this.render_bstar(cSOperation);
                break;
            }
            case 83: {
                if (byArray.length == 1) {
                    this.render_S(cSOperation);
                    break;
                }
                if (byArray.length == 2) {
                    this.render_SC(cSOperation);
                    break;
                }
                this.render_SCN(cSOperation);
                break;
            }
            case 104: {
                this.render_h(cSOperation);
                break;
            }
            case 87: {
                if (byArray.length == 1) {
                    this.render_W(cSOperation);
                    break;
                }
                this.render_Wstar(cSOperation);
                break;
            }
            case 99: {
                if (byArray.length == 1) {
                    this.render_c(cSOperation);
                    break;
                }
                switch (byArray[1]) {
                    case 109: {
                        this.render_cm(cSOperation);
                        break;
                    }
                    case 115: {
                        this.render_cs(cSOperation);
                    }
                }
                break;
            }
            case 69: {
                switch (byArray[1]) {
                    case 84: {
                        this.render_ET(cSOperation);
                        break;
                    }
                    case 77: {
                        this.render_EMC(cSOperation);
                        break;
                    }
                    case 73: {
                        this.render_EI(cSOperation);
                        break;
                    }
                    case 88: {
                        this.render_EX(cSOperation);
                    }
                }
                break;
            }
            case 120: {
                switch (byArray[1]) {
                    case 106: {
                        this.render_Tj(cSOperation);
                        break;
                    }
                    case 74: {
                        this.render_TJ(cSOperation);
                    }
                }
                break;
            }
            case 71: {
                this.render_G(cSOperation);
                break;
            }
            case 39: {
                this.render_Quote(cSOperation);
                break;
            }
            case 34: {
                this.render_DoubleQuote(cSOperation);
                break;
            }
            case 67: {
                this.render_CS(cSOperation);
                break;
            }
            case 100: {
                if (byArray.length == 1) {
                    this.render_d(cSOperation);
                    break;
                }
                switch (byArray[1]) {
                    case 48: {
                        this.render_d0(cSOperation);
                        break;
                    }
                    case 49: {
                        this.render_d1(cSOperation);
                    }
                }
                break;
            }
            case 68: {
                switch (byArray[1]) {
                    case 111: {
                        this.render_Do(cSOperation);
                        break;
                    }
                    case 80: {
                        this.render_DP(cSOperation);
                    }
                }
                break;
            }
            case 70: {
                this.render_F(cSOperation);
                break;
            }
            case 105: {
                this.render_i(cSOperation);
                break;
            }
            case 106: {
                this.render_j(cSOperation);
                break;
            }
            case 74: {
                this.render_J(cSOperation);
                break;
            }
            case 75: {
                this.render_K(cSOperation);
                break;
            }
            case 107: {
                this.render_k(cSOperation);
                break;
            }
            case 77: {
                if (byArray.length == 1) {
                    this.render_M(cSOperation);
                    break;
                }
                this.render_MP(cSOperation);
                break;
            }
            case 118: {
                this.render_v(cSOperation);
                break;
            }
            case 119: {
                this.render_w(cSOperation);
                break;
            }
            case 121: {
                this.render_y(cSOperation);
                break;
            }
            default: {
                this.notSupported(cSOperation);
            }
        }
    }

    protected void render_b(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_B(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_BDC(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_BMC(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_bstar(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Bstar(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_BT(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_BX(CSOperation cSOperation) throws CSException {
        this.incCompatibilitySectionDepth();
    }

    protected void render_c(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_cm(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_cs(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_CS(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_d(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_d0(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_d1(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Do(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_DoubleQuote(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_DP(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_EI(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_EMC(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_ET(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_EX(CSOperation cSOperation) throws CSException {
        this.decCompatibilitySectionDepth();
    }

    protected void render_f(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_F(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_fstar(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_g(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_G(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_gs(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_h(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_i(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_j(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_J(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_k(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_K(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_l(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_m(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_M(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_MP(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_n(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_q(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Q(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Quote(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_re(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_rg(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_RG(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_ri(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_s(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_S(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_sc(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_SC(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_scn(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_SCN(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_sh(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Tc(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Td(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_TD(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Tf(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Tj(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_TJ(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_TL(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Tm(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Tr(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Ts(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Tstar(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Tw(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Tz(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_v(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_w(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_W(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_Wstar(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    protected void render_y(CSOperation cSOperation) throws CSException {
        this.notSupported(cSOperation);
    }

    @Override
    public void setExceptionHandler(ICSExceptionHandler iCSExceptionHandler) {
        this.exceptionHandler = iCSExceptionHandler;
    }

    public void setInterruptible(boolean bl) {
        this.interruptible = bl;
    }
}

