/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.provider;

import de.intarsys.tools.provider.ProviderConfigurationException;
import de.intarsys.tools.stream.StreamTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Providers {
    public static final char COMMENT = '#';
    public static final String SEPARATOR = ";";
    private static final Map<ClassLoader, Providers> providers = new HashMap<ClassLoader, Providers>();
    private static final String PROVIDERLIST = "META-INF/provider/provider.list";
    private ClassLoader loader;
    private List<ProviderEntry> entries = new ArrayList<ProviderEntry>();
    private static final Logger Log = Logger.getLogger("de.intarsys.tools.provider");

    public static Providers get() {
        return Providers.get(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Providers get(ClassLoader classLoader) {
        Map<ClassLoader, Providers> map = providers;
        synchronized (map) {
            Providers providers = Providers.providers.get(classLoader);
            if (providers == null) {
                try {
                    providers = new Providers(classLoader);
                }
                catch (IOException iOException) {
                    throw new ProviderConfigurationException("error creating providers", iOException);
                }
                Providers.providers.put(classLoader, providers);
            }
            return providers;
        }
    }

    protected Providers(ClassLoader classLoader) throws IOException {
        this.loader = classLoader;
        this.init();
    }

    protected void addProvider(ProviderEntry providerEntry) {
        for (ProviderEntry providerEntry2 : this.entries) {
            if (!providerEntry2.serviceName.equals(providerEntry.serviceName) || !providerEntry2.providerName.equals(providerEntry.providerName)) continue;
            return;
        }
        this.entries.add(providerEntry);
    }

    private void init() throws IOException {
        Enumeration<URL> enumeration = this.loader == null ? ClassLoader.getSystemResources(PROVIDERLIST) : this.loader.getResources(PROVIDERLIST);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                this.register(inputStream);
            }
            finally {
                StreamTools.close(inputStream);
            }
        }
    }

    public <S> Iterator<S> lookupProviders(Class<S> clazz) {
        return new Iterator<S>(clazz){
            private ProviderEntry current;
            private String serviceName;
            private Iterator<ProviderEntry> it;
            {
                this.serviceName = clazz.getName();
                this.it = Providers.this.entries.iterator();
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.current == null) ** GOTO lbl7
                return true;
lbl-1000:
                // 1 sources

                {
                    var1_1 = this.it.next();
                    if (!this.serviceName.equals(var1_1.serviceName)) continue;
                    this.current = var1_1;
                    return true;
lbl7:
                    // 2 sources

                    ** while (this.it.hasNext())
                }
lbl8:
                // 1 sources

                return false;
            }

            @Override
            public S next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ProviderEntry providerEntry = this.current;
                this.current = null;
                if (providerEntry.provider == null) {
                    try {
                        providerEntry.provider = Class.forName(providerEntry.providerName, true, Providers.this.loader).newInstance();
                    }
                    catch (Throwable throwable) {
                        Log.log(Level.FINEST, "loading provider failed", throwable);
                        throw new ProviderConfigurationException("error loading " + providerEntry.providerName, throwable);
                    }
                }
                return providerEntry.provider;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void register(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            while (this.registerLine(bufferedReader)) {
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(bufferedReader);
            throw throwable;
        }
        StreamTools.close(bufferedReader);
    }

    protected boolean registerLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            return false;
        }
        int n = string.indexOf(35);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if ((string = string.trim()).length() == 0) {
            return true;
        }
        String[] stringArray = string.split(SEPARATOR);
        if (stringArray.length < 2) {
            return true;
        }
        ProviderEntry providerEntry = new ProviderEntry();
        providerEntry.serviceName = stringArray[0].trim();
        providerEntry.providerName = stringArray[1].trim();
        this.addProvider(providerEntry);
        return true;
    }

    static class ProviderEntry {
        public String serviceName;
        public String providerName;
        public Object provider;

        ProviderEntry() {
        }
    }
}

