/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import java.io.IOException;

public class RandomAccessByteArray
extends AbstractRandomAccess {
    private static final int RESIZE_BYTES = 32;
    protected byte[] data;
    private int offset = 0;
    protected int length;

    public RandomAccessByteArray(byte[] byArray) {
        if (byArray == null) {
            this.data = new byte[32];
            this.length = 0;
        } else {
            this.data = byArray;
            this.length = byArray.length;
        }
    }

    public RandomAccessByteArray(byte[] byArray, int n) {
        if (byArray == null) {
            this.data = new byte[32];
            this.length = 0;
        } else {
            this.data = byArray;
            this.length = n;
        }
    }

    protected final void basicSetLengthResize(int n) {
        if (n > this.data.length) {
            byte[] byArray = n - this.data.length < 32 ? new byte[this.data.length + 32] : new byte[n];
            System.arraycopy(this.data, 0, byArray, 0, this.length);
            this.data = byArray;
        }
        this.length = n;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void flush() throws IOException {
    }

    protected byte[] getData() {
        return this.data;
    }

    @Override
    public long getLength() throws IOException {
        return this.length;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public int read() {
        if (this.offset < this.length) {
            return this.data[this.offset++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.length - this.offset;
        if (n2 > n3 && (n2 = n3) == 0) {
            return -1;
        }
        System.arraycopy(this.data, this.offset, byArray, n, n2);
        this.offset += n2;
        return n2;
    }

    @Override
    public void seek(long l) throws IOException {
        this.offset = (int)l;
        if (this.offset < 0) {
            this.offset = 0;
            throw new IOException("offset less than 0");
        }
    }

    @Override
    public void seekBy(long l) throws IOException {
        this.offset = (int)((long)this.offset + l);
        if (this.offset < 0) {
            this.offset = 0;
            throw new IOException("offset less than 0");
        }
    }

    @Override
    public void setLength(long l) {
        int n = (int)l;
        if (n > this.length) {
            this.basicSetLengthResize(n);
        } else {
            if (this.offset > n) {
                this.offset = n;
            }
            this.length = n;
        }
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        return byArray;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        int n3 = this.offset + n2;
        if (n3 > this.length) {
            this.basicSetLengthResize(n3);
        }
        System.arraycopy(byArray, n, this.data, this.offset, n2);
        this.offset += n2;
    }

    @Override
    public void write(int n) {
        int n2 = this.offset + 1;
        if (n2 > this.length) {
            this.basicSetLengthResize(n2);
        }
        this.data[this.offset++] = (byte)n;
    }
}

