/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassTools {
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");

    public static List collectClasses(String string) throws IOException {
        List list = ClassTools.collectClassNames(string);
        ClassLoader classLoader = ClassTools.createClassLoader(string);
        ArrayList arrayList = new ArrayList();
        for (String string2 : list) {
            try {
                arrayList.add(classLoader.loadClass(string2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static List collectClassNames(String string) throws IOException {
        ArrayList arrayList = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_SEPARATOR);
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            if (file.isFile()) {
                ClassTools.extractClassNamesFromJar(arrayList, file);
            } else {
                ClassTools.extractClassNamesFromDir(arrayList, file, "");
            }
            ++n2;
        }
        return arrayList;
    }

    public static <T> Class<T> createClass(String string, Class<T> clazz, ClassLoader classLoader) throws ObjectCreationException {
        if (StringTools.isEmpty(string)) {
            throw new ObjectCreationException("class name missing");
        }
        string = string.trim();
        try {
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if (classLoader == null) {
                classLoader = clazz.getClassLoader();
            }
            Class<?> clazz2 = Class.forName(string, false, classLoader);
            if (clazz != null && !clazz.isAssignableFrom(clazz2)) {
                throw new ObjectCreationException("class '" + clazz2.getName() + "' not compatible with expected type '" + clazz + "'");
            }
            return clazz2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ObjectCreationException("class '" + string + "' not found", classNotFoundException);
        }
        catch (Throwable throwable) {
            throw new ObjectCreationException("class '" + string + "' not found", throwable);
        }
    }

    public static ClassLoader createClassLoader(String string) {
        URL[] uRLArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, PATH_SEPARATOR);
        int n = stringTokenizer.countTokens();
        uRLArray = new URL[n + 1];
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringTokenizer.nextToken();
            try {
                URL uRL;
                uRLArray[n2] = uRL = new URL("file", "", string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            ++n2;
        }
        URLClassLoader uRLClassLoader = URLClassLoader.newInstance(uRLArray);
        return uRLClassLoader;
    }

    protected static void extractClassNamesFromDir(List list, File file, String string) throws IOException {
        if (file.isFile()) {
            String string2 = file.getName();
            if (string2.endsWith(".class")) {
                String string3 = string2.substring(0, string2.length() - 6);
                list.add(String.valueOf(string) + string3);
            }
        } else {
            String[] stringArray = file.list();
            if (stringArray == null) {
                throw new IOException("error creating directory listing for " + file.getAbsolutePath());
            }
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                ClassTools.extractClassNamesFromDir(list, file2, String.valueOf(string) + stringArray[n] + ".");
                ++n;
            }
        }
    }

    protected static void extractClassNamesFromJar(List list, File file) throws IOException {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                String string = jarEntry.getName();
                if (!string.endsWith(".class")) continue;
                String string2 = string.substring(0, string.length() - 6);
                string2 = string2.replace('/', '.');
                list.add(string2);
            }
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    public static String getPackageName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getUnqualifiedName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private ClassTools() {
    }
}

