/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.system;

public class SystemTools {
    private static final String Bindir;
    private static final String Basedir;
    private static final String Libdir;
    private static final String osName;
    private static final String osArch;
    private static boolean citrix;
    private static boolean windows;
    private static boolean windowsxp;
    private static boolean linux;
    private static boolean mac;

    static {
        citrix = false;
        windows = false;
        windowsxp = false;
        linux = false;
        mac = false;
        String string = System.getProperty("de.intarsys.platform.os.name");
        String string2 = System.getProperty("de.intarsys.platform.os.arch", "x86");
        if (string == null) {
            string = System.getProperty("os.name");
            string2 = System.getProperty("os.arch");
        }
        osName = string;
        osArch = string2;
        String string3 = osName.toLowerCase();
        if (string3.startsWith("win")) {
            windows = true;
            if (string3.equals("windows xp")) {
                windowsxp = true;
            }
            Libdir = "bin";
            Bindir = "bin";
            Basedir = "";
        } else if (string3.startsWith("linux")) {
            linux = true;
            if ("amd64".equals(osArch)) {
                Bindir = "bin";
                Libdir = "lib/amd64";
            } else {
                Bindir = "bin";
                Libdir = "lib/i386";
            }
            Basedir = "";
        } else if (string3.startsWith("mac")) {
            mac = true;
            Libdir = "MacOS";
            Bindir = "MacOS";
            Basedir = "Resources";
        } else {
            Basedir = "";
            Libdir = "";
            Bindir = "";
        }
        citrix = Boolean.getBoolean("de.intarsys.platform.citrix");
    }

    public static String getBasedir() {
        return Basedir;
    }

    public static String getBindir() {
        return Bindir;
    }

    public static String getLibdir() {
        return Libdir;
    }

    public static String getOSArch() {
        return osArch;
    }

    public static String getOSName() {
        return osName;
    }

    public static boolean isCitrix() {
        return citrix;
    }

    public static boolean isLinux() {
        return linux;
    }

    public static boolean isMac() {
        return mac;
    }

    public static boolean isWindows() {
        return windows;
    }

    public static boolean isWindowsXP() {
        return windowsxp;
    }

    public static String mapLibraryName(String string) {
        String string2 = System.mapLibraryName(string);
        if (string2.length() > 6 && string2.substring(string2.length() - 7).equals(".jnilib")) {
            string2 = string2.substring(0, string2.length() - 7);
            string2 = String.valueOf(string2) + ".dylib";
        }
        return string2;
    }

    private SystemTools() {
    }
}

