/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeReferenceType;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.NativeVoid;

public class NativeReference<T extends INativeObject>
extends NativeObject {
    public static final NativeReferenceType META = new NativeReferenceType(NativeVoid.META);
    private INativeHandle dereferenceHandle;
    private T dereferenced;
    private NativeReferenceType type;

    static {
        NativeType.register(NativeReference.class, META);
    }

    public static <U extends INativeObject> NativeReference<U> create(INativeType iNativeType) {
        NativeReferenceType nativeReferenceType = new NativeReferenceType(iNativeType);
        return new NativeReference(nativeReferenceType);
    }

    protected NativeReference(NativeReferenceType nativeReferenceType) {
        this.type = nativeReferenceType;
        this.allocate();
    }

    protected NativeReference(NativeReferenceType nativeReferenceType, INativeHandle iNativeHandle) {
        super(iNativeHandle);
        this.type = nativeReferenceType;
        iNativeHandle.setSize(this.getByteCount());
    }

    public INativeType getBaseType() {
        return this.type.getBaseType();
    }

    @Override
    public int getByteCount() {
        return NativeInterface.get().pointerSize();
    }

    @Override
    public INativeType getNativeType() {
        return this.type;
    }

    public long getReferencedAddress() {
        return this.getNativeHandle(0).getAddress();
    }

    public synchronized T getValue() {
        this.dereferenceHandle = this.handle.getNativeHandle(0);
        if (this.dereferenced == null || !this.dereferenced.getNativeHandle().equals(this.dereferenceHandle)) {
            this.dereferenced = this.type.getBaseType().createNative(this.dereferenceHandle);
        }
        return this.dereferenced;
    }

    public void setBaseType(INativeType iNativeType) {
        this.type = NativeReferenceType.create(iNativeType);
        this.dereferenceHandle = null;
        this.dereferenced = null;
    }

    @Override
    public synchronized void setValue(Object object) {
        if (object instanceof INativeObject) {
            INativeObject iNativeObject = (INativeObject)object;
            INativeHandle iNativeHandle = iNativeObject.getNativeHandle();
            this.handle.setNativeHandle(0, iNativeHandle);
            this.dereferenceHandle = iNativeHandle;
            this.dereferenced = iNativeObject;
        } else if (object instanceof INativeHandle) {
            INativeHandle iNativeHandle = (INativeHandle)object;
            this.handle.setNativeHandle(0, iNativeHandle);
            this.dereferenceHandle = iNativeHandle;
            this.dereferenced = null;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String toString() {
        if (this.handle == null) {
            return "Ref to null";
        }
        return "Ref to " + this.getReferencedAddress();
    }
}

