/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot;

import com.baselet.control.Matrix;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.NewGridElement;
import com.baselet.element.elementnew.plot.drawer.PlotGridDrawConfig;
import com.baselet.element.elementnew.plot.elements.AbstractPlot;
import com.baselet.element.elementnew.plot.elements.BarPlot;
import com.baselet.element.elementnew.plot.elements.LinePlot;
import com.baselet.element.elementnew.plot.elements.PiePlot;
import com.baselet.element.elementnew.plot.elements.ScatterPlot;
import com.baselet.element.elementnew.plot.parser.Parser;
import com.baselet.element.elementnew.plot.parser.ParserException;
import com.baselet.element.elementnew.plot.parser.ParserResult;
import com.baselet.element.elementnew.plot.parser.PlotConstants;
import com.baselet.element.elementnew.plot.parser.PlotState;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.settings.SettingsManualresizeCenter;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PlotGrid
extends NewGridElement {
    private static final Logger log = Logger.getLogger(PlotGrid.class);
    private Matrix<List<AbstractPlot>> matrix;
    private Integer gridWidth;
    private Double minValue;
    private Double maxValue;
    public static final Facet PSEUDO_PLOT_FACET = new Facet(){

        @Override
        public void handleLine(String string, PropertiesParserState propertiesParserState) {
        }

        @Override
        public List<AutocompletionText> getAutocompletionStrings() {
            return PlotConstants.AUTOCOMPLETION_LIST;
        }

        @Override
        public boolean checkStart(String string, PropertiesParserState propertiesParserState) {
            return true;
        }
    };

    private void fillWithPlots(ParserResult parserResult) {
        ArrayList<PlotState> arrayList = parserResult.getPlotStateList();
        DrawHandler drawHandler = parserResult.getDrawer();
        this.setOverallMinMaxValue(arrayList);
        for (PlotState plotState : arrayList) {
            List<List<AbstractPlot>> list;
            Integer n = plotState.getValueAsInt("pos.x", null);
            Integer n2 = plotState.getValueAsInt("pos.y", null);
            if (n != null) {
                n = n - 1;
            }
            if (n2 != null) {
                n2 = n2 - 1;
            }
            if (n != null && n2 != null) {
                this.setMatrixHeightMinimum(n2);
                list = this.matrix.row(n2);
                this.setMinimumListSize(n, list);
                list.set(n, this.createPlots(drawHandler, plotState, n, n2, "x and y are specified"));
                continue;
            }
            if (n != null) {
                this.putPlotInFirstFreeVerticalSpaceOrAddPlot(drawHandler, n, plotState, "only x is specified -> space replaced");
                continue;
            }
            if (n2 != null) {
                this.setMatrixHeightMinimum(n2);
                list = this.matrix.row(n2);
                this.putPlotInFirstFreeHorizontalSpaceOrAddPlot(drawHandler, list, n2, plotState, "only y specified -> ");
                continue;
            }
            this.putPlotInFirstFreeMatrixSpace(drawHandler, plotState);
        }
        this.gridWidth = this.matrix.cols();
        log.debug((Object)("\n" + this.toString() + "\n"));
    }

    private void setOverallMinMaxValue(List<PlotState> list) {
        this.minValue = Double.MAX_VALUE;
        this.maxValue = Double.MIN_VALUE;
        for (PlotState plotState : list) {
            Double[][] doubleArray;
            Double[][] doubleArray2 = doubleArray = plotState.getDataSet().data();
            int n = doubleArray2.length;
            for (int i = 0; i < n; ++i) {
                Double[] doubleArray3;
                for (Double d : doubleArray3 = doubleArray2[i]) {
                    if (d > this.maxValue) {
                        this.maxValue = d;
                    }
                    if (!(d < this.minValue)) continue;
                    this.minValue = d;
                }
            }
        }
    }

    private void setMatrixHeightMinimum(Integer n) {
        while (n > this.matrix.rows() - 1) {
            this.matrix.addLine(new ArrayList());
        }
    }

    private void setMinimumListSize(Integer n, List<List<AbstractPlot>> list) {
        while (n > list.size() - 1) {
            list.add(null);
        }
    }

    private void putPlotInFirstFreeVerticalSpaceOrAddPlot(DrawHandler drawHandler, Integer n, PlotState plotState, String string) {
        boolean bl = false;
        for (int i = 0; i < this.matrix.rows(); ++i) {
            List<List<AbstractPlot>> list = this.matrix.row(i);
            if (n >= list.size()) {
                this.setMinimumListSize(n, list);
            }
            if (list.get(n) != null) continue;
            list.set(n, this.createPlots(drawHandler, plotState, n, i, string));
            bl = true;
            break;
        }
        if (!bl) {
            ArrayList<List<AbstractPlot>> arrayList = new ArrayList<List<AbstractPlot>>();
            this.setMinimumListSize(n, arrayList);
            arrayList.set(n, this.createPlots(drawHandler, plotState, n, this.matrix.rows(), "only x is specified -> expanded y-list"));
            this.matrix.addLine(arrayList);
        }
    }

    private void putPlotInFirstFreeHorizontalSpaceOrAddPlot(DrawHandler drawHandler, List<List<AbstractPlot>> list, Integer n, PlotState plotState, String string) {
        int n2 = 0;
        while (true) {
            if (n2 == list.size()) {
                list.add(this.createPlots(drawHandler, plotState, n2, n, string + "added new x-entry"));
                return;
            }
            if (list.get(n2) == null) {
                list.set(n2, this.createPlots(drawHandler, plotState, n2, n, string + "replaced x-entry"));
                return;
            }
            ++n2;
        }
    }

    private void putPlotInFirstFreeMatrixSpace(DrawHandler drawHandler, PlotState plotState) {
        for (int i = 0; i < this.matrix.rows(); ++i) {
            List<List<AbstractPlot>> list = this.matrix.row(i);
            for (int j = 0; j < list.size(); ++j) {
                List<AbstractPlot> list2 = list.get(j);
                if (list2 != null) continue;
                list.set(j, this.createPlots(drawHandler, plotState, j, i, "no coordinate specified -> free space found"));
                return;
            }
            if (list.size() >= this.gridWidth) continue;
            list.add(this.createPlots(drawHandler, plotState, list.size(), i, "no coordinate specified -> expanded x-list"));
            return;
        }
        ArrayList<List<AbstractPlot>> arrayList = new ArrayList<List<AbstractPlot>>();
        arrayList.add(this.createPlots(drawHandler, plotState, 0, this.matrix.rows(), "no coordinate specified -> every matrix space occupied, expanded y-list"));
        this.matrix.addLine(arrayList);
    }

    private List<AbstractPlot> createPlots(DrawHandler drawHandler, PlotState plotState, Integer n, Integer n2, String string) {
        ArrayList<AbstractPlot> arrayList = new ArrayList<AbstractPlot>();
        arrayList.add(this.createPlot(drawHandler, plotState, n, n2, string));
        for (PlotState plotState2 : plotState.getSubplots()) {
            arrayList.add(this.createPlot(drawHandler, plotState2, n, n2, string));
        }
        return arrayList;
    }

    private AbstractPlot createPlot(DrawHandler drawHandler, PlotState plotState, int n, int n2, String string) {
        String string2 = plotState.getValueValidated(PlotConstants.PlotType.getKey(), PlotConstants.PlotType.Bar.getValue(), PlotConstants.toStringList(PlotConstants.PlotType.values()));
        log.debug((Object)("PlotGrid insert : " + string2 + " (" + n + ";" + n2 + ") " + string));
        PlotGridDrawConfig plotGridDrawConfig = new PlotGridDrawConfig(this.getRealSize(), new Dimension(this.getRectangle().width, this.getRectangle().height), this.minValue, this.maxValue);
        if (PlotConstants.PlotType.Pie.getValue().equals(string2)) {
            return new PiePlot(drawHandler, plotGridDrawConfig, plotState, n, n2);
        }
        if (PlotConstants.PlotType.Line.getValue().equals(string2)) {
            return new LinePlot(drawHandler, plotGridDrawConfig, plotState, n, n2);
        }
        if (PlotConstants.PlotType.Scatter.getValue().equals(string2)) {
            return new ScatterPlot(drawHandler, plotGridDrawConfig, plotState, n, n2);
        }
        return new BarPlot(drawHandler, plotGridDrawConfig, plotState, n, n2);
    }

    public void drawPlots() {
        for (int i = 0; i < this.matrix.rows(); ++i) {
            for (int j = 0; j < this.matrix.row(i).size(); ++j) {
                List<AbstractPlot> list = this.matrix.cell(i, j);
                for (AbstractPlot abstractPlot : list) {
                    if (abstractPlot == null) continue;
                    if (j != abstractPlot.getXPosition()) {
                        log.error((Object)("Plot contains wrong coordinates: " + j + " != " + abstractPlot.getXPosition()));
                    }
                    if (i != abstractPlot.getYPosition()) {
                        log.error((Object)("Plot contains wrong coordinates: " + i + " != " + abstractPlot.getYPosition()));
                    }
                    abstractPlot.plot(this.matrix.cols(), this.matrix.rows());
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("------------------------------\n");
        for (int i = 0; i < this.matrix.rows(); ++i) {
            List<List<AbstractPlot>> list = this.matrix.row(i);
            for (List<AbstractPlot> list2 : list) {
                for (AbstractPlot abstractPlot : list2) {
                    if (abstractPlot == null) {
                        stringBuilder.append("null\t");
                        continue;
                    }
                    stringBuilder.append(abstractPlot.getPlotLineNr()).append("\t");
                }
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.append("------------------------------").toString();
    }

    @Override
    protected void drawCommonContent(PropertiesParserState propertiesParserState) {
        DrawHandler drawHandler = propertiesParserState.getDrawer();
        try {
            this.matrix = new Matrix();
            ParserResult parserResult = new Parser().parse(this.getPanelAttributes());
            parserResult.setDrawer(drawHandler);
            log.debug((Object)parserResult.toString());
            this.gridWidth = Integer.parseInt(parserResult.getPlotGridValue("grid.width", "3"));
            this.fillWithPlots(parserResult);
            this.drawPlots();
        }
        catch (ParserException parserException) {
            drawHandler.setForegroundColor(ColorOwn.RED);
            drawHandler.setBackgroundColor(ColorOwn.WHITE);
            drawHandler.drawRectangle(0.0, 0.0, this.getRectangle().width - 1, this.getRectangle().height - 1);
            float f = (float)this.getRectangle().getWidth() / 2.0f;
            drawHandler.print(parserException.getMessage(), f, (double)this.getRealSize().height / 2.0, AlignHorizontal.CENTER);
        }
    }

    @Override
    protected Settings createSettings() {
        return new SettingsManualresizeCenter(){

            @Override
            protected List<Facet> createFacets() {
                return 2.listOf(PSEUDO_PLOT_FACET);
            }
        };
    }

    @Override
    public ElementId getId() {
        return ElementId.PlotGrid;
    }
}

