/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.draw.DrawHelper;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HierarchyFacet
extends Facet {
    private static final double ARROW_LENGTH = 12.0;
    private static final double CIRCLE_DIAMETER = 10.0;
    private static final String KEY = "type";
    public static final HierarchyFacet INSTANCE = new HierarchyFacet();

    @Override
    public boolean checkStart(String string, PropertiesParserState propertiesParserState) {
        return true;
    }

    @Override
    public void handleLine(String string, PropertiesParserState propertiesParserState) {
        double d;
        int n;
        int n2;
        if (string.isEmpty()) {
            return;
        }
        Cache cache = propertiesParserState.getOrInitFacetResponse(HierarchyFacet.class, new Cache());
        for (HierarchyType hierarchyType : HierarchyType.values()) {
            if (!string.equals("type=" + (Object)((Object)hierarchyType))) continue;
            cache.type = hierarchyType;
            return;
        }
        DrawHandler drawHandler = propertiesParserState.getDrawer();
        drawHandler.setLayer(DrawHandler.Layer.Foreground);
        ColorOwn colorOwn = drawHandler.getBackgroundColor();
        drawHandler.setBackgroundColor(ColorOwn.TRANSPARENT);
        String string2 = string.replace("\t", "");
        int n3 = string.length() - string2.length();
        int n4 = 10;
        PointDouble pointDouble = null;
        PointDouble pointDouble2 = null;
        PointDouble pointDouble3 = null;
        if (cache.type == HierarchyType.Actor) {
            n2 = 10;
            n = n4 + n2 + n2 * 5 * n3;
            int n5 = n4 + cache.lineNr * n2 * 6;
            DrawHelper.drawActor(drawHandler, n, n5, n2);
            pointDouble = new PointDouble(n, (double)n5 + (double)n2 * 5.5 + 12.0);
            pointDouble2 = new PointDouble(n - n2 * 2, (double)n5 + (double)n2 * 2.5);
            HierarchyFacet.drawLinesAndUpperLeftSymbol(pointDouble2, drawHandler, cache, string2, n3, true);
            pointDouble3 = new PointDouble(n + n2 * 2, n5 + n2 * 3);
            drawHandler.print(string2, pointDouble3, AlignHorizontal.LEFT);
            this.updateElementSize(propertiesParserState, string2, pointDouble2, pointDouble3, drawHandler.textWidth(string2), DrawHelper.headToLegLength(n2));
        } else if (cache.type == HierarchyType.Package) {
            n2 = 20;
            n = 30;
            double d2 = (double)n4 + (double)(n3 * n) * 1.4;
            d = (double)n4 + (double)(cache.lineNr * n2) * 1.6;
            DrawHelper.drawPackage(drawHandler, d2, d, 5.0, 10.0, n2, n);
            pointDouble = new PointDouble(d2 + (double)n * 0.3, d + (double)n2 + 10.0);
            pointDouble2 = new PointDouble(d2, d + (double)n2 * 0.5);
            HierarchyFacet.drawLinesAndUpperLeftSymbol(pointDouble2, drawHandler, cache, string2, n3, false);
            pointDouble3 = new PointDouble(d2 + (double)n * 1.15, d + (double)n2 * 0.8);
            drawHandler.print(string2, pointDouble3, AlignHorizontal.LEFT);
            this.updateElementSize(propertiesParserState, string2, pointDouble2, pointDouble3, drawHandler.textWidth(string2), n2 + 10);
        } else if (cache.type == HierarchyType.WorkProcess) {
            n2 = 40;
            n = 140;
            double d3 = n4 + n3 * n;
            d = (double)n4 + (double)(cache.lineNr * n2) * 1.2;
            drawHandler.drawEllipse(d3, d, n, n2);
            pointDouble = new PointDouble(d3 + (double)n * 0.5, d + (double)n2 + 12.0);
            pointDouble2 = new PointDouble(d3, d + (double)n2 * 0.5);
            HierarchyFacet.drawLinesAndUpperLeftSymbol(pointDouble2, drawHandler, cache, string2, n3, true);
            pointDouble3 = new PointDouble(d3 + (double)n / 2.0, d + (double)n2 / 2.0 + drawHandler.textHeight(string2) / 2.0);
            drawHandler.print(string2, pointDouble3, AlignHorizontal.CENTER);
            this.updateElementSize(propertiesParserState, string2, pointDouble2, pointDouble3, n / 2, n2);
        }
        if (n3 == 0) {
            cache.points.clear();
        }
        while (cache.points.size() > n3) {
            cache.points.remove(cache.points.size() - 1);
        }
        cache.points.add(new ReferencePoint(pointDouble));
        cache.lineNr++;
        drawHandler.setLayer(DrawHandler.Layer.Background);
        drawHandler.setBackgroundColor(colorOwn);
    }

    private void updateElementSize(PropertiesParserState propertiesParserState, String string, PointDouble pointDouble, PointDouble pointDouble2, double d, double d2) {
        propertiesParserState.updateMinimumSize(pointDouble2.x + d, pointDouble.y + d2);
    }

    private static void drawLinesAndUpperLeftSymbol(PointDouble pointDouble, DrawHandler drawHandler, Cache cache, String string, int n, boolean bl) {
        if (n != 0) {
            try {
                ReferencePoint referencePoint = (ReferencePoint)cache.points.get(n - 1);
                PointDouble pointDouble2 = new PointDouble(pointDouble.x, pointDouble.y);
                PointDouble pointDouble3 = new PointDouble(referencePoint.p.x, pointDouble.y);
                PointDouble pointDouble4 = new PointDouble(referencePoint.p.x, referencePoint.p.y);
                drawHandler.drawLines(pointDouble2, pointDouble3, pointDouble4);
                if (!referencePoint.hasSymbol) {
                    referencePoint.hasSymbol = true;
                    if (bl) {
                        PointDouble pointDouble5 = new PointDouble(referencePoint.p.x, referencePoint.p.y - 12.0);
                        PointDouble pointDouble6 = new PointDouble(referencePoint.p.x - 6.0, referencePoint.p.y);
                        PointDouble pointDouble7 = new PointDouble(referencePoint.p.x + 6.0, referencePoint.p.y);
                        drawHandler.drawLines(pointDouble5, pointDouble6, pointDouble7, pointDouble5);
                    } else {
                        int n2 = 2;
                        double d = 5.0;
                        drawHandler.drawCircle(referencePoint.p.x, referencePoint.p.y - d, d);
                        drawHandler.drawLine(referencePoint.p.x, referencePoint.p.y - 10.0 + (double)n2, referencePoint.p.x, referencePoint.p.y - (double)n2);
                        drawHandler.drawLine(referencePoint.p.x - d + (double)n2, referencePoint.p.y - d, referencePoint.p.x + d - (double)n2, referencePoint.p.y - d);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new RuntimeException("Too many tabs in line nr." + (cache.lineNr + 1) + ": " + string);
            }
        }
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        return Arrays.asList(new AutocompletionText("type=" + (Object)((Object)HierarchyType.Actor), "draws hierarchy of actors"), new AutocompletionText("type=" + (Object)((Object)HierarchyType.Package), "draws hierarchy of packages"), new AutocompletionText("type=" + (Object)((Object)HierarchyType.WorkProcess), "draws hierarchy of work processes"));
    }

    public static enum HierarchyType {
        Actor,
        Package,
        WorkProcess;

    }

    private static final class Cache {
        HierarchyType type = HierarchyType.Actor;
        private int lineNr;
        private final List<ReferencePoint> points = new ArrayList<ReferencePoint>();

        private Cache() {
        }
    }

    private static final class ReferencePoint {
        PointDouble p;
        boolean hasSymbol = false;

        public ReferencePoint(PointDouble pointDouble) {
            this.p = pointDouble;
        }
    }
}

