/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation.helper;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.relation.helper.RelationPoint;
import com.baselet.element.relation.helper.RelationPointHandlerUtils;
import com.baselet.element.relation.helper.RelationPointHolder;
import com.baselet.element.relation.helper.RelationPointList;
import com.baselet.element.relation.helper.RelationSelection;
import com.baselet.element.relation.helper.ResizableObject;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.PointDoubleIndexed;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RelationPointHandler
implements ResizableObject {
    private RelationPointList points = new RelationPointList();
    private final RelationPointHolder relation;
    private PointDoubleIndexed relationPointOfCurrentDrag = null;

    public RelationPointHandler(RelationPointHolder relationPointHolder, RelationPointList relationPointList) {
        this.relation = relationPointHolder;
        this.points = relationPointList;
    }

    public RelationSelection getSelection(Point point) {
        if (this.isPointOverDragBox(point)) {
            return RelationSelection.DRAG_BOX;
        }
        if (RelationPointHandlerUtils.getRelationPointContaining(point, this.points) != null) {
            return RelationSelection.RELATION_POINT;
        }
        if (this.getLineContaining(point) != null) {
            return RelationSelection.LINE;
        }
        return RelationSelection.NOTHING;
    }

    public RelationSelection getSelectionAndMovePointsIfNecessary(Point point, Integer n, Integer n2, boolean bl) {
        if (!bl && this.relationPointOfCurrentDrag != null) {
            this.relationPointOfCurrentDrag = this.movePointAndResizeRectangle(this.relationPointOfCurrentDrag, n, n2);
            return RelationSelection.RELATION_POINT;
        }
        this.relationPointOfCurrentDrag = null;
        if (this.isPointOverDragBox(point)) {
            return RelationSelection.DRAG_BOX;
        }
        PointDoubleIndexed pointDoubleIndexed = RelationPointHandlerUtils.getRelationPointContaining(point, this.points);
        if (pointDoubleIndexed != null) {
            this.relationPointOfCurrentDrag = this.movePointAndResizeRectangle(pointDoubleIndexed, n, n2);
            return RelationSelection.RELATION_POINT;
        }
        Line line = this.getLineContaining(point);
        if (line != null) {
            this.relationPointOfCurrentDrag = this.points.addPointOnLine(line, SharedUtils.realignToGridRoundToNearest(false, point.x), SharedUtils.realignToGridRoundToNearest(false, point.y));
            this.relationPointOfCurrentDrag = this.movePointAndResizeRectangle(this.relationPointOfCurrentDrag, n, n2);
            return RelationSelection.LINE;
        }
        return RelationSelection.NOTHING;
    }

    private boolean isPointOverDragBox(Point point) {
        return this.getDragBox().contains(point);
    }

    private Line getLineContaining(Point point) {
        for (Line line : this.points.getRelationPointLines()) {
            double d = line.getDistanceToPoint(point.toPointDouble());
            if (!(d < 7.0)) continue;
            return line;
        }
        return null;
    }

    public List<PointDoubleIndexed> movePointAndResizeRectangle(List<PointChange> list) {
        this.points.applyChangesToPoints(list);
        this.resizeRectAndReposPoints();
        ArrayList<PointDoubleIndexed> arrayList = new ArrayList<PointDoubleIndexed>();
        for (PointChange pointChange : list) {
            arrayList.add(this.points.get(pointChange.getIndex()));
        }
        return arrayList;
    }

    private PointDoubleIndexed movePointAndResizeRectangle(PointDoubleIndexed pointDoubleIndexed, Integer n, Integer n2) {
        return this.movePointAndResizeRectangle(Arrays.asList(new PointChange(pointDoubleIndexed.getIndex(), n, n2))).get(0);
    }

    public void resizeRectAndReposPoints() {
        Rectangle rectangle = RelationPointHandlerUtils.calculateRelationRectangleBasedOnPoints(this.relation.getRectangle().getUpperLeftCorner(), this.relation.getGridSize(), this.points);
        this.relation.setRectangle(rectangle);
        this.points.moveRelationPointsAndTextSpacesByToUpperLeftCorner();
    }

    public boolean removeRelationPointIfOnLineBetweenNeighbourPoints() {
        return this.points.removeRelationPointIfOnLineBetweenNeighbourPoints();
    }

    public Line getFirstLine() {
        return this.points.getFirstLine();
    }

    public Line getMiddleLine() {
        return this.points.getMiddleLine();
    }

    public Line getLastLine() {
        return this.points.getLastLine();
    }

    public Collection<PointDoubleIndexed> getStickablePoints() {
        return this.points.getStickablePoints();
    }

    public Rectangle getDragBox() {
        return this.points.getDragBox();
    }

    public void drawLinesBetweenPoints(DrawHandler drawHandler) {
        for (Line line : this.points.getRelationPointLines()) {
            drawHandler.drawLine(line);
        }
    }

    public void drawCirclesAndDragBox(DrawHandler drawHandler) {
        for (RelationPoint relationPoint : this.points.getPointHolders()) {
            drawHandler.drawCircle(relationPoint.getPoint().getX(), relationPoint.getPoint().getY(), 10.0);
        }
        drawHandler.drawRectangle(this.getDragBox());
    }

    public String toAdditionalAttributesString() {
        return this.points.toAdditionalAttributesString();
    }

    public void drawSelectionSpace(DrawHandler drawHandler) {
        for (RelationPoint relationPoint : this.points.getPointHolders()) {
            drawHandler.drawRectangle(relationPoint.getSizeAbsolute());
        }
    }

    public void setTextBox(int n, Rectangle rectangle) {
        rectangle = SharedUtils.realignToGrid(rectangle, true);
        this.points.setTextBox(n, rectangle);
    }

    public void resetTextBoxIndexesExcept(Set<Integer> set) {
        HashSet<Integer> hashSet = new HashSet<Integer>(this.points.getTextBoxIndexes());
        hashSet.removeAll(set);
        for (Integer n : hashSet) {
            this.points.setTextBox(n, null);
        }
    }

    @Override
    public void setPointMinSize(int n, Rectangle rectangle) {
        rectangle = SharedUtils.realignToGrid(rectangle, true);
        this.points.setSize(n, rectangle);
    }

    @Override
    public void resetPointMinSize(int n) {
        this.points.setSize(n, RelationPoint.DEFAULT_SIZE);
    }

    public String toString() {
        return this.points.toString();
    }
}

