/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sticking;

import com.baselet.control.basics.geom.Line;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class StickingPolygon {
    private final Vector<StickLine> stick = new Vector();
    private PointDouble lastpoint = null;
    private PointDouble firstpoint = null;
    private final int elementX;
    private final int elementY;
    private final List<PointDouble> allPoints = new ArrayList<PointDouble>();

    public StickingPolygon(int n, int n2) {
        this.elementX = n;
        this.elementY = n2;
    }

    public void addPoint(List<PointDouble> list) {
        for (PointDouble pointDouble : list) {
            this.addPoint(pointDouble.getX(), pointDouble.getY());
        }
    }

    public void addPoint(double d, double d2) {
        PointDouble pointDouble = new PointDouble((double)this.elementX + d, (double)this.elementY + d2);
        this.allPoints.add(pointDouble);
        if (this.firstpoint == null) {
            this.firstpoint = pointDouble;
        } else {
            this.stick.add(new StickLine(this.lastpoint, pointDouble));
        }
        this.lastpoint = pointDouble;
    }

    public void addPoint(int n, int n2, boolean bl) {
        this.addPoint(n, n2);
        if (bl) {
            this.allPoints.add(this.firstpoint);
            this.stick.add(new StickLine(this.lastpoint, this.firstpoint));
        }
    }

    public void addRectangle(int n, int n2, int n3, int n4) {
        this.addPoint(n, n2);
        this.addPoint(n + n3, n2);
        this.addPoint(n + n3, n2 + n4);
        this.addPoint(n, n2 + n4, true);
    }

    public void addRectangle(Rectangle rectangle) {
        this.addRectangle(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public StickLine getLine(int n) {
        return this.stick.get(n);
    }

    public Vector<StickLine> getStickLines() {
        return this.stick;
    }

    public int isConnected(PointDouble pointDouble, int n) {
        int n2 = -1;
        for (int i = 0; i < this.stick.size(); ++i) {
            if (!this.stick.get(i).isConnected(pointDouble, n)) continue;
            return i;
        }
        return n2;
    }

    public String toString() {
        return "StickingPolygon [stick=" + Arrays.toString(this.stick.toArray(new StickLine[this.stick.size()])) + "]";
    }

    public static class StickLine
    extends Line {
        StickLine(PointDouble pointDouble, PointDouble pointDouble2) {
            super(pointDouble, pointDouble2);
        }

        public PointDouble diffToLine(StickLine stickLine, int n, int n2) {
            double d = 0.0;
            double d2 = 0.0;
            if (this.getEnd().x.equals(this.getStart().x)) {
                d = stickLine.getStart().x - (stickLine.getEnd().x - stickLine.getStart().x) - (double)n;
                if (stickLine.getEnd().x.equals(stickLine.getStart().x)) {
                    d2 = 0.0;
                    if (stickLine.getStart().y > stickLine.getEnd().y) {
                        if (stickLine.getStart().y < (double)n2) {
                            d2 = stickLine.getStart().y - (double)n2;
                        } else if (stickLine.getEnd().y > (double)n2) {
                            d2 = stickLine.getEnd().y - (double)n2;
                        }
                    } else if (stickLine.getEnd().y < (double)n2) {
                        d2 = stickLine.getEnd().y - (double)n2;
                    } else if (stickLine.getStart().y > (double)n2) {
                        d2 = stickLine.getStart().y - (double)n2;
                    }
                    return new PointDouble(d, d2);
                }
            } else {
                d = ((double)n - this.getStart().x) * (stickLine.getEnd().x - stickLine.getStart().x) / (this.getEnd().x - this.getStart().x) + stickLine.getStart().x - (double)n;
            }
            if (this.getEnd().y.equals(this.getStart().y)) {
                d2 = stickLine.getStart().y - (stickLine.getEnd().y - stickLine.getStart().y) - (double)n2;
                if (stickLine.getEnd().y.equals(stickLine.getStart().y)) {
                    d = 0.0;
                    if (stickLine.getStart().x > stickLine.getEnd().x) {
                        if (stickLine.getStart().x < (double)n) {
                            d = stickLine.getStart().x - (double)n;
                        } else if (stickLine.getEnd().x > (double)n) {
                            d = stickLine.getEnd().x - (double)n;
                        }
                    } else if (stickLine.getEnd().x < (double)n) {
                        d = stickLine.getEnd().x - (double)n;
                    } else if (stickLine.getStart().x > (double)n) {
                        d = stickLine.getStart().x - (double)n;
                    }
                }
            } else {
                d2 = ((double)n2 - this.getStart().y) * (stickLine.getEnd().y - stickLine.getStart().y) / (this.getEnd().y - this.getStart().y) + stickLine.getStart().y - (double)n2;
            }
            return new PointDouble(d, d2);
        }

        public boolean isConnected(PointDouble pointDouble, int n) {
            double d = this.getDistanceToPoint(pointDouble);
            return d < (double)n;
        }
    }
}

