/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.generator.sorting;

import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.element.ElementFactorySwing;
import com.baselet.element.NewGridElement;
import com.baselet.element.interfaces.GridElement;
import com.baselet.generator.sorting.HeightLayout;
import com.baselet.generator.sorting.Layout;
import com.baselet.generator.sorting.SortableElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PackageLayout
extends Layout {
    private final int ADJUST_TO_PACKAGE_HEAD;

    public PackageLayout() {
        this.ADJUST_TO_PACKAGE_HEAD = this.GRIDSIZE * 2;
    }

    @Override
    public void layout(List<SortableElement> elements) {
        Map<String, List<SortableElement>> packages = this.extractPackages(elements);
        TreeMap<SortableElement, List<SortableElement>> packList = new TreeMap<SortableElement, List<SortableElement>>();
        for (Map.Entry<String, List<SortableElement>> entry : packages.entrySet()) {
            SortableElement pack = this.createPackageElement(entry.getKey());
            List<SortableElement> packElements = entry.getValue();
            HeightLayout l = new HeightLayout();
            ((Layout)l).layout(packElements);
            Dimension size = l.bounds;
            pack.getElement().setSize(size.width, size.height);
            packList.put(pack, packElements);
        }
        Rectangle x = new Rectangle();
        for (SortableElement sortableElement : packList.keySet()) {
            sortableElement.getElement().setLocation(10, 10 + x.y + x.height);
            x = sortableElement.getElement().getRectangle();
        }
        for (Map.Entry entry : packList.entrySet()) {
            this.adjustLocations((SortableElement)entry.getKey(), (List)entry.getValue());
            elements.add((SortableElement)entry.getKey());
        }
    }

    private void adjustLocations(SortableElement pack, List<SortableElement> packElements) {
        for (SortableElement s : packElements) {
            Rectangle loc = s.getElement().getRectangle();
            Rectangle packLoc = pack.getElement().getRectangle();
            s.getElement().setLocation(loc.x + packLoc.x, loc.y + packLoc.y + this.ADJUST_TO_PACKAGE_HEAD);
        }
    }

    private Map<String, List<SortableElement>> extractPackages(List<SortableElement> elements) {
        HashMap<String, List<SortableElement>> packages = new HashMap<String, List<SortableElement>>();
        for (SortableElement element : elements) {
            String packageName = element.getParsedClass().getPackage();
            if (!packages.containsKey(packageName)) {
                packages.put(packageName, new ArrayList());
            }
            ((List)packages.get(packageName)).add(element);
        }
        return packages;
    }

    private SortableElement createPackageElement(String packageName) {
        NewGridElement pack = ElementFactorySwing.create(ElementId.UMLPackage, new Rectangle(10, 10, 10, 10), String.valueOf(packageName) + "\nbg=orange", "", CurrentDiagram.getInstance().getDiagramHandler());
        return new SortableElement((GridElement)pack, packageName);
    }
}

