/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.command;

import com.baselet.control.Main;
import com.baselet.diagram.CustomPreviewHandler;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.SelectorOld;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.command.Command;
import com.baselet.gui.pane.OwnSyntaxPane;

public class CustomCodePropertyChanged
extends Command {
    private String _newState;
    private String _oldState;
    private int _oldCaret;
    private int _newCaret;

    public String getNewState() {
        return this._newState;
    }

    public String getOldState() {
        return this._oldState;
    }

    public int getOldCaret() {
        return this._oldCaret;
    }

    public int getNewCaret() {
        return this._newCaret;
    }

    public CustomCodePropertyChanged(String oldState, String newState, int oldCaret, int newCaret) {
        this._newState = newState;
        this._oldState = oldState;
        this._newCaret = newCaret;
        this._oldCaret = oldCaret;
    }

    @Override
    public void execute(DiagramHandler handler) {
        super.execute(handler);
        GridElement gridElement = Main.getInstance().getEditedGridElement();
        if (gridElement == null) {
            SelectorOld selector = CurrentGui.getInstance().getGui().getCurrentCustomHandler().getPreviewHandler().getDrawPanel().getSelector();
            selector.selectAll();
            if (selector.getSelectedElements().size() >= 1) {
                gridElement = selector.getSelectedElements().get(0);
            }
        }
        if (gridElement != null && Main.getHandlerForElement(gridElement) instanceof CustomPreviewHandler) {
            gridElement.setPanelAttributes(this._newState);
            OwnSyntaxPane pane = CurrentGui.getInstance().getGui().getPropertyPane();
            pane.switchToElement(gridElement);
            if (pane.getText().length() >= this._newCaret) {
                pane.getTextComponent().setCaretPosition(this._newCaret);
            }
            gridElement.repaint();
        }
    }

    @Override
    public void undo(DiagramHandler handler) {
        GridElement gridElement = Main.getInstance().getEditedGridElement();
        if (gridElement == null) {
            SelectorOld selector = CurrentGui.getInstance().getGui().getCurrentCustomHandler().getPreviewHandler().getDrawPanel().getSelector();
            selector.selectAll();
            if (selector.getSelectedElements().size() >= 1) {
                gridElement = selector.getSelectedElements().get(0);
            }
        }
        if (gridElement != null && Main.getHandlerForElement(gridElement) instanceof CustomPreviewHandler) {
            gridElement.setPanelAttributes(this._oldState);
            OwnSyntaxPane pane = CurrentGui.getInstance().getGui().getPropertyPane();
            pane.switchToElement(gridElement);
            if (pane.getText().length() >= this._oldCaret) {
                pane.getTextComponent().setCaretPosition(this._oldCaret);
            }
            gridElement.repaint();
        }
    }

    public String toString() {
        return "Changestate from " + this.getOldState() + " to " + this.getNewState();
    }
}

