/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.menu;

import com.baselet.control.Main;
import com.baselet.control.constants.Constants;
import com.baselet.control.constants.MenuConstants;
import com.baselet.control.constants.SystemInfo;
import com.baselet.control.enums.Os;
import com.baselet.control.util.RecentlyUsedFilesList;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.gui.helper.PlainColorIcon;
import com.baselet.gui.menu.MenuFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MenuFactorySwing
extends MenuFactory {
    private static MenuFactorySwing instance = null;

    public static MenuFactorySwing getInstance() {
        if (instance == null) {
            instance = new MenuFactorySwing();
        }
        return instance;
    }

    public JMenuItem createNew() {
        return this.createJMenuItem(false, "New", 78, true, null);
    }

    public JMenuItem createOpen() {
        return this.createJMenuItem(false, "Open...", 79, true, null);
    }

    public JMenu createRecentFiles() {
        final JMenu recentFiles = new JMenu();
        recentFiles.setText("Recent files");
        recentFiles.addMenuListener(new MenuListener(){

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                recentFiles.removeAll();
                for (String file : RecentlyUsedFilesList.getInstance()) {
                    recentFiles.add(MenuFactorySwing.this.createJMenuItem(false, file, "Recent files", file));
                }
            }
        });
        return recentFiles;
    }

    public JMenuItem createGenerate() {
        return this.createJMenuItem(false, "Generate Class Elements from Files or Directory...", null);
    }

    public JMenuItem createGenerateOptions() {
        return this.createJMenuItem(false, "Generate Class Element Options...", null);
    }

    public JMenuItem createSave() {
        return this.createJMenuItem(true, "Save", 83, true, null);
    }

    public JMenuItem createSaveAs() {
        return this.createJMenuItem(true, "Save as...", null);
    }

    public JMenu createExportAs() {
        JMenu export = new JMenu();
        export.setText("Export as...");
        this.diagramDependendComponents.add(export);
        for (String format : Constants.exportFormatList) {
            export.add(this.createJMenuItem(true, String.valueOf(format.toUpperCase()) + "...", "Export as...", format));
        }
        return export;
    }

    public JMenuItem createMailTo() {
        return this.createJMenuItem(true, "Mail to...", 77, true, null);
    }

    public JMenuItem createEditCurrentPalette() {
        return this.createJMenuItem(false, "Edit Current Palette", null);
    }

    public JMenuItem createOptions() {
        return this.createJMenuItem(false, "Options...", null);
    }

    public JMenuItem createPrint() {
        return this.createJMenuItem(true, "Print...", 80, true, null);
    }

    public JMenuItem createExit() {
        return this.createJMenuItem(false, "Exit", null);
    }

    public JMenuItem createUndo() {
        return this.createJMenuItem(false, "Undo", 90, true, null);
    }

    public JMenuItem createRedo() {
        return this.createJMenuItem(false, "Redo", 89, true, null);
    }

    public JMenuItem createDelete() {
        int[] keys = new int[]{8, 127};
        if (SystemInfo.OS == Os.MAC) {
            return this.createJMenuItem(false, "Delete", keys, 8);
        }
        return this.createJMenuItem(false, "Delete", keys, 127);
    }

    public JMenuItem createSelectAll() {
        return this.createJMenuItem(false, "Select All", 65, true, null);
    }

    public JMenuItem createGroup() {
        return this.createJMenuItem(false, "Group", 71, true, null);
    }

    public JMenuItem createUngroup() {
        return this.createJMenuItem(false, "Ungroup", 85, true, null);
    }

    public JMenuItem createCut() {
        return this.createJMenuItem(false, "Cut", 88, true, null);
    }

    public JMenuItem createCopy() {
        return this.createJMenuItem(false, "Copy", 67, true, null);
    }

    public JMenuItem createPaste() {
        return this.createJMenuItem(false, "Paste", 86, true, null);
    }

    public JMenuItem createNewCustomElement() {
        return this.createJMenuItem(false, "New...", null);
    }

    public JMenu createNewCustomElementFromTemplate() {
        JMenu menu = new JMenu("New from Template");
        for (String template : Main.getInstance().getTemplateNames()) {
            menu.add(this.createJMenuItem(false, template, "New from Template", template));
        }
        return menu;
    }

    public JMenuItem createEditSelected() {
        return this.createJMenuItem(false, "Edit Selected...", null);
    }

    public JMenuItem createCustomElementTutorial() {
        return this.createJMenuItem(false, "Custom Elements Tutorial...", null);
    }

    public JMenuItem createOnlineHelp() {
        return this.createJMenuItem(false, "Online Help...", null);
    }

    public JMenuItem createOnlineSampleDiagrams() {
        return this.createJMenuItem(false, "Online Sample Diagrams...", null);
    }

    public JMenuItem createVideoTutorials() {
        return this.createJMenuItem(false, "Video Tutorial: Basic Use and Custom Elements...", null);
    }

    public JMenuItem createProgramHomepage() {
        return this.createJMenuItem(false, MenuConstants.PROGRAM_HOMEPAGE, null);
    }

    public JMenuItem createRateProgram() {
        return this.createJMenuItem(false, MenuConstants.RATE_PROGRAM, null);
    }

    public JMenu createSetColor(boolean fg) {
        String name = fg ? "Set foreground color" : "Set background color";
        JMenu menu = new JMenu(name);
        menu.add(this.createJMenuItem(false, "default", name, null));
        for (String color : ColorOwn.COLOR_MAP.keySet()) {
            JMenuItem item = this.createJMenuItem(false, color, name, color);
            menu.add(item);
            item.setIcon(new PlainColorIcon(color));
        }
        return menu;
    }

    public JMenuItem createAboutProgram() {
        return this.createJMenuItem(false, MenuConstants.ABOUT_PROGRAM, null);
    }

    public JMenu createAlign() {
        JMenu alignMenu = new JMenu("Align");
        String[] stringArray = new String[]{"Left", "Right", "Top", "Bottom"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String direction = stringArray[n2];
            alignMenu.add(this.createJMenuItem(false, direction, "Align", direction));
            ++n2;
        }
        return alignMenu;
    }

    public JMenu createLayerUp() {
        JMenu alignMenu = new JMenu("Layer");
        String[] stringArray = new String[]{"to back (layer -1)", "to front (layer +1)"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String direction = stringArray[n2];
            alignMenu.add(this.createJMenuItem(false, direction, "Layer", direction));
            ++n2;
        }
        return alignMenu;
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String name, Object param) {
        return this.createJMenuItem(grayWithoutDiagram, name, name, null, null, param);
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String name, Integer mnemonic, Boolean meta, Object param) {
        return this.createJMenuItem(grayWithoutDiagram, name, name, mnemonic, meta, param);
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String menuName, String actionName, Object param) {
        return this.createJMenuItem(grayWithoutDiagram, menuName, actionName, null, null, param);
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String menuName, final String actionName, Integer mnemonic, Boolean meta, final Object param) {
        JMenuItem menuItem = new JMenuItem(menuName);
        if (mnemonic != null) {
            menuItem.setMnemonic(mnemonic);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(mnemonic, meta == false ? 0 : SystemInfo.META_KEY.getMask()));
        }
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuFactorySwing.this.doAction(actionName, param);
            }
        });
        if (grayWithoutDiagram) {
            this.diagramDependendComponents.add(menuItem);
        }
        return menuItem;
    }

    private JMenuItem createJMenuItem(boolean grayWithoutDiagram, String name, int[] keyEvents, int preferredMnemonic) {
        JMenuItem menuItem = new JMenuItem(name);
        MultipleKeyBindingsAction action = new MultipleKeyBindingsAction(name, preferredMnemonic);
        int[] nArray = keyEvents;
        int n = keyEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int keyEvent = nArray[n2];
            this.addKeyBinding(menuItem, keyEvent, name);
            ++n2;
        }
        menuItem.getActionMap().put(name, action);
        menuItem.setAction(action);
        if (grayWithoutDiagram) {
            this.diagramDependendComponents.add(menuItem);
        }
        return menuItem;
    }

    private void addKeyBinding(JMenuItem menuItem, int keyEvent, String actionName) {
        menuItem.getInputMap(2).put(KeyStroke.getKeyStroke(keyEvent, 0), actionName);
    }

    private class MultipleKeyBindingsAction
    extends AbstractAction {
        public MultipleKeyBindingsAction(String menuName, int preferredMnemonic) {
            super(menuName);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(preferredMnemonic, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuFactorySwing.this.doAction(this.getValue("Name").toString(), null);
        }
    }
}

