/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.plugin.gui;

import com.baselet.control.Main;
import com.baselet.control.constants.Constants;
import com.baselet.control.constants.MenuConstants;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.menu.MenuFactory;
import com.baselet.plugin.gui.Contributor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MenuFactoryEclipse
extends MenuFactory {
    private static final Logger log = Logger.getLogger(MenuFactoryEclipse.class);
    private static MenuFactoryEclipse instance = null;
    private final List<Action> aList = new ArrayList<Action>();

    public static MenuFactoryEclipse getInstance() {
        if (instance == null) {
            instance = new MenuFactoryEclipse();
        }
        return instance;
    }

    @Override
    public void doAction(String menuItem, final Object param) {
        log.info((Object)("doAction " + menuItem));
        DiagramHandler actualHandler = CurrentDiagram.getInstance().getDiagramHandler();
        if (menuItem.equals("Edit Current Palette")) {
            String paletteName = Main.getInstance().getPalette().getFileHandler().getFullPathName();
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(new File(paletteName).toURI());
            if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                }
                catch (PartInitException e) {
                    log.error((Object)"Cannot open palette file", (Throwable)e);
                }
            }
        } else if (menuItem.equals("Search")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CurrentGui.getInstance().getGui().enableSearch(true);
                }
            });
        } else if (menuItem.equals("Zoom to") && actualHandler != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CurrentDiagram.getInstance().getDiagramHandler().setGridAndZoom((Integer)param);
                }
            });
        } else {
            log.debug((Object)"super.doAction");
            super.doAction(menuItem, param);
            log.debug((Object)"super.doAction complete");
        }
        log.debug((Object)"doAction complete");
    }

    public Action createOptions() {
        return this.createAction("Options...", null);
    }

    public Action createOnlineHelp() {
        return this.createAction("Online Help...", null);
    }

    public Action createOnlineSampleDiagrams() {
        return this.createAction("Online Sample Diagrams...", null);
    }

    public Action createVideoTutorial() {
        return this.createAction("Video Tutorial: Basic Use and Custom Elements...", null);
    }

    public Action createProgramHomepage() {
        return this.createAction(MenuConstants.PROGRAM_HOMEPAGE, null);
    }

    public Action createMailTo() {
        return this.createAction("Mail to...", null);
    }

    public Action createRateProgram() {
        return this.createAction(MenuConstants.RATE_PROGRAM, null);
    }

    public Action createAboutProgram() {
        return this.createAction(MenuConstants.ABOUT_PROGRAM, null);
    }

    public Action createNewCustomElement() {
        return this.createAction("New...", null);
    }

    public Action createCustomElementsTutorial() {
        return this.createAction("Custom Elements Tutorial...", null);
    }

    public Action createUndo() {
        return this.createAction("Undo", null);
    }

    public Action createRedo() {
        return this.createAction("Redo", null);
    }

    public Action createPrint() {
        return this.createAction("Print...", null);
    }

    public Action createCopy() {
        return this.createAction("Copy", null);
    }

    public Action createCut() {
        return this.createAction("Cut", null);
    }

    public Action createPaste() {
        return this.createAction("Paste", null);
    }

    public Action createDelete() {
        return this.createAction("Delete", null);
    }

    public Action createSelectAll() {
        return this.createAction("Select All", null);
    }

    public Action createSearch() {
        return this.createAction("Search", null);
    }

    public Action createEditSelected() {
        return this.createAction("Edit Selected...", null);
    }

    public Action createEditCurrentPalette() {
        return this.createAction("Edit Current Palette", null);
    }

    public List<IAction> createExportAsActions() {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        for (String format : Constants.exportFormatList) {
            actions.add((IAction)this.createAction(String.valueOf(format.toUpperCase()) + "...", "Export as...", format));
        }
        return actions;
    }

    public IAction createGenerate() {
        return this.createAction("Generate Class Elements from Files or Directory...", null);
    }

    public IAction createGenerateOptions() {
        return this.createAction("Generate Class Element Options...", null);
    }

    public IMenuManager createZoom() {
        MenuManager zoom = new MenuManager("Zoom to");
        for (String z : Constants.zoomValueList) {
            zoom.add((IAction)this.createAction(z, "Zoom to", Integer.parseInt(z.substring(0, z.length() - 2)), 8));
        }
        return zoom;
    }

    public IMenuManager createNewCustomElementFromTemplate(final Contributor con) {
        MenuManager menu = new MenuManager("New from Template");
        for (String template : Main.getInstance().getTemplateNames()) {
            Action a = this.createAction(template, "New from Template", template);
            menu.add((IAction)a);
            this.aList.add(a);
        }
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (Action a : MenuFactoryEclipse.this.aList) {
                    a.setEnabled(!con.isCustomPanelEnabled());
                }
            }
        });
        return menu;
    }

    private Action createAction(String name, String param) {
        return this.createAction(name, name, param);
    }

    private Action createAction(String menuName, String actionName, Object param) {
        return this.createAction(menuName, actionName, param, 0);
    }

    private Action createAction(String menuName, final String actionName, final Object param, int style) {
        return new Action(menuName, style){

            public void run() {
                MenuFactoryEclipse.this.doAction(actionName, param);
            }
        };
    }
}

