/* linux/arch/arm/mach-exynos/include/mach/map.h
 *
 * Copyright (c) 2010-2011 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com/
 *
 * EXYNOS4 - Memory map definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_MAP_H
#define __ASM_ARCH_MAP_H __FILE__

#include <plat/map-base.h>

#ifdef CONFIG_SOC_EXYNOS5430
/*
 * The virtual and physical address of UART is aligned to 1MiB boundary usally.
 * However, the Exynos5430's UART physical address is alignd to 64KB boundary.
 * So, the virtual address needs to re-set to 64KB align boundary.
 */
#undef S3C_VA_UART
#define S3C_VA_UART			S3C_ADDR(0x01010000)
#endif

/*
 * EXYNOS4 UART offset is 0x10000 but the older S5P SoCs are 0x400.
 * So need to define it, and here is to avoid redefinition warning.
 */
#define S3C_UART_OFFSET			(0x10000)

#include <plat/map-s5p.h>

#define EXYNOS4_PA_SYSRAM0		0x02025000
#define EXYNOS4_PA_SYSRAM1		0x02020000
#define EXYNOS5_PA_SYSRAM		0x02020000
#define EXYNOS4210_PA_SYSRAM_NS		0x0203F000
#define EXYNOS4x12_PA_SYSRAM_NS		0x0204F000
#define EXYNOS5250_PA_SYSRAM_NS		0x0204F000
#define EXYNOS5422_PA_SYSRAM_NS		0x02073000
#define EXYNOS5430_PA_SYSRAM_NS		0x0207F000

#define EXYNOS4_PA_FIMC0		0x11800000
#define EXYNOS4_PA_FIMC1		0x11810000
#define EXYNOS4_PA_FIMC2		0x11820000
#define EXYNOS4_PA_FIMC3		0x11830000

#define EXYNOS4_PA_JPEG			0x11840000

/* x = 0...1 */
#define EXYNOS4_PA_FIMC_LITE(x)		(0x12390000 + ((x) * 0x10000))

#define EXYNOS4_PA_G2D			0x12800000

#define EXYNOS_PA_AUDSS_INTMEM		0x03000000
#define EXYNOS_PA_AUDSS_COMMBOX		0x03820000
#define EXYNOS_PA_AUDSS			0x03810000
#define EXYNOS4_PA_I2S0			0x03830000
#define EXYNOS4_PA_I2S1			0xE3100000
#define EXYNOS4_PA_I2S2			0xE2A00000

#define EXYNOS4_PA_PCM0			0x03840000
#define EXYNOS4_PA_PCM1			0x13980000
#define EXYNOS4_PA_PCM2			0x13990000

#define EXYNOS4_PA_SROM_BANK(x)		(0x04000000 + ((x) * 0x01000000))

#define EXYNOS4_PA_ONENAND		0x0C000000
#define EXYNOS4_PA_ONENAND_DMA		0x0C600000

#define EXYNOS_PA_CHIPID		0x10000000
#define EXYNOS_PA_CHIPID2		0x10004000

#define EXYNOS4_PA_SYSCON		0x10010000
#define EXYNOS5_PA_SYSCON		0x10050100

#define EXYNOS4_PA_PMU			0x10020000
#define EXYNOS5_PA_PMU			0x10040000
#define EXYNOS5430_PA_PMU		0x105C0000
#define EXYNOS5430_PA_PMU_LPI_CAM0	0x120E0000
#define EXYNOS5430_PA_PMU_LPI_CAM1	0x145E0000
#define EXYNOS5430_PA_PMU_LPI_ISP	0x146E0000

#define EXYNOS4_PA_CMU			0x10030000
#define EXYNOS5_PA_CMU			0x10010000

#define EXYNOS4_PA_SYSTIMER		0x10050000

#define EXYNOS4_PA_WATCHDOG		0x10060000
#define EXYNOS5_PA_WATCHDOG		0x101D0000

#define EXYNOS4_PA_RTC			0x10070000

#define EXYNOS4_PA_KEYPAD		0x100A0000

#define EXYNOS4_PA_DMC0			0x10400000
#define EXYNOS4_PA_DMC1			0x10410000

#define EXYNOS4_PA_COMBINER		0x10440000
#define EXYNOS5_PA_COMBINER		0x10440000

#define EXYNOS4_PA_GIC_CPU		0x10480000
#define EXYNOS4_PA_GIC_DIST		0x10490000
#define EXYNOS5_PA_GIC_CPU		0x10482000
#define EXYNOS5_PA_GIC_DIST		0x10481000

#define EXYNOS4_PA_COREPERI		0x10500000
#define EXYNOS4_PA_TWD			0x10500600
#define EXYNOS4_PA_L2CC			0x10502000

#define EXYNOS4_PA_TMU			0x100C0000

#define EXYNOS4_PA_MDMA0		0x10810000
#define EXYNOS4_PA_MDMA1		0x12850000
#define EXYNOS4_PA_S_MDMA1		0x12840000
#define EXYNOS4_PA_PDMA0		0x12680000
#define EXYNOS4_PA_PDMA1		0x12690000
#define EXYNOS5_PA_MDMA0		0x10800000
#define EXYNOS5_PA_MDMA1		0x11C10000
#define EXYNOS5_PA_PDMA0		0x121A0000
#define EXYNOS5_PA_PDMA1		0x121B0000

#define EXYNOS4_PA_SYSMMU_MDMA		0x10A40000
#define EXYNOS4_PA_SYSMMU_2D_ACP	0x10A40000
#define EXYNOS4_PA_SYSMMU_SSS		0x10A50000
#define EXYNOS4_PA_SYSMMU_FIMC0		0x11A20000
#define EXYNOS4_PA_SYSMMU_FIMC1		0x11A30000
#define EXYNOS4_PA_SYSMMU_FIMC2		0x11A40000
#define EXYNOS4_PA_SYSMMU_FIMC3		0x11A50000
#define EXYNOS4_PA_SYSMMU_JPEG		0x11A60000
#define EXYNOS4_PA_SYSMMU_FIMD0		0x11E20000
#define EXYNOS4_PA_SYSMMU_FIMD1		0x12220000
#define EXYNOS4_PA_SYSMMU_FIMC_ISP	0x12260000
#define EXYNOS4_PA_SYSMMU_FIMC_DRC	0x12270000
#define EXYNOS4_PA_SYSMMU_FIMC_FD	0x122A0000
#define EXYNOS4_PA_SYSMMU_ISPCPU	0x122B0000
#define EXYNOS4_PA_SYSMMU_FIMC_LITE0	0x123B0000
#define EXYNOS4_PA_SYSMMU_FIMC_LITE1	0x123C0000
#define EXYNOS4_PA_SYSMMU_PCIe		0x12620000
#define EXYNOS4_PA_SYSMMU_G2D		0x12A20000
#define EXYNOS4_PA_SYSMMU_ROTATOR	0x12A30000
#define EXYNOS4_PA_SYSMMU_MDMA2		0x12A40000
#define EXYNOS4_PA_SYSMMU_TV		0x12E20000
#define EXYNOS4_PA_SYSMMU_MFC_L		0x13620000
#define EXYNOS4_PA_SYSMMU_MFC_R		0x13630000

#define EXYNOS5_PA_GSC0			0x13E00000
#define EXYNOS5_PA_GSC1			0x13E10000
#define EXYNOS5_PA_GSC2			0x13E20000
#define EXYNOS5_PA_GSC3			0x13E30000

#define EXYNOS5_PA_SYSMMU_MDMA1		0x10A40000
#define EXYNOS5_PA_SYSMMU_SSS		0x10A50000
#define EXYNOS5_PA_SYSMMU_2D		0x10A60000
#define EXYNOS5_PA_SYSMMU_MFC_L		0x11200000
#define EXYNOS5_PA_SYSMMU_MFC_R		0x11210000
#define EXYNOS5_PA_SYSMMU_ROTATOR	0x11D40000
#define EXYNOS5_PA_SYSMMU_MDMA2		0x11D50000
#define EXYNOS5_PA_SYSMMU_JPEG		0x11F20000
#define EXYNOS5_PA_SYSMMU_IOP		0x12360000
#define EXYNOS5_PA_SYSMMU_RTIC		0x12370000
#define EXYNOS5_PA_SYSMMU_ISP		0x13260000
#define EXYNOS5_PA_SYSMMU_DRC		0x12370000
#define EXYNOS5_PA_SYSMMU_SCALERC	0x13280000
#define EXYNOS5_PA_SYSMMU_SCALERP	0x13290000
#define EXYNOS5_PA_SYSMMU_FD		0x132A0000
#define EXYNOS5_PA_SYSMMU_ISPCPU	0x132B0000
#define EXYNOS5_PA_SYSMMU_ODC		0x132C0000
#define EXYNOS5_PA_SYSMMU_DIS0		0x132D0000
#define EXYNOS5_PA_SYSMMU_DIS1		0x132E0000
#define EXYNOS5_PA_SYSMMU_3DNR		0x132F0000
#define EXYNOS5_PA_SYSMMU_LITE0		0x13C40000
#define EXYNOS5_PA_SYSMMU_LITE1		0x13C50000
#define EXYNOS5_PA_SYSMMU_GSC0		0x13E80000
#define EXYNOS5_PA_SYSMMU_GSC1		0x13E90000
#define EXYNOS5_PA_SYSMMU_GSC2		0x13EA0000
#define EXYNOS5_PA_SYSMMU_GSC3		0x13EB0000
#define EXYNOS5_PA_SYSMMU_FIMD1		0x14640000
#define EXYNOS5_PA_SYSMMU_TV		0x14650000

#define EXYNOS4_PA_SPI0			0x13920000
#define EXYNOS4_PA_SPI1			0x13930000
#define EXYNOS4_PA_SPI2			0x13940000
#define EXYNOS5_PA_SPI0			0x12D20000
#define EXYNOS5_PA_SPI1			0x12D30000
#define EXYNOS5_PA_SPI2			0x12D40000

#define EXYNOS4_PA_GPIO1		0x11400000
#define EXYNOS4_PA_GPIO2		0x11000000
#define EXYNOS4_PA_GPIO3		0x03860000
#define EXYNOS5_PA_GPIO1		0x11400000
#define EXYNOS5_PA_GPIO2		0x13400000
#define EXYNOS5_PA_GPIO3		0x10D10000
#define EXYNOS5_PA_GPIO4		0x03860000

#define EXYNOS4_PA_MIPI_CSIS0		0x11880000
#define EXYNOS4_PA_MIPI_CSIS1		0x11890000

#define EXYNOS4_PA_FIMD0		0x11C00000

#define EXYNOS4_PA_HSMMC(x)		(0x12510000 + ((x) * 0x10000))
#define EXYNOS4_PA_DWMCI		0x12550000
#define EXYNOS5_PA_DWMCI0		0x12200000
#define EXYNOS5_PA_DWMCI1		0x12210000
#define EXYNOS5_PA_DWMCI2		0x12220000
#define EXYNOS5_PA_DWMCI3		0x12230000

#define EXYNOS4_PA_HSOTG		0x12480000
#define EXYNOS4_PA_USB_HSPHY		0x125B0000

#define EXYNOS4_PA_SATA			0x12560000
#define EXYNOS4_PA_SATAPHY		0x125D0000
#define EXYNOS4_PA_SATAPHY_CTRL		0x126B0000

#define EXYNOS4_PA_SROMC		0x12570000
#define EXYNOS5_PA_SROMC		0x12250000

#define EXYNOS4_PA_EHCI			0x12580000
#define EXYNOS4_PA_OHCI			0x12590000
#define EXYNOS4_PA_HSPHY		0x125B0000
#define EXYNOS4_PA_MFC			0x13400000

#define EXYNOS4_PA_UART			0x13800000
#define EXYNOS5_PA_UART			0x12C00000
#define EXYNOS5430_PA_UART		0x14C10000

#define EXYNOS4_PA_VP			0x12C00000
#define EXYNOS4_PA_MIXER		0x12C10000
#define EXYNOS4_PA_SDO			0x12C20000
#define EXYNOS4_PA_HDMI			0x12D00000
#define EXYNOS4_PA_IIC_HDMIPHY		0x138E0000

#define EXYNOS4_PA_IIC(x)		(0x13860000 + ((x) * 0x10000))
#define EXYNOS5_PA_IIC(x)		(0x12C60000 + ((x) * 0x10000))

#define EXYNOS4_PA_ADC			0x13910000
#define EXYNOS4_PA_ADC1			0x13911000

#define EXYNOS4_PA_AC97			0x139A0000

#define EXYNOS4_PA_SPDIF		0x139B0000

#define EXYNOS4_PA_TIMER		0x139D0000
#define EXYNOS5_PA_TIMER		0x12DD0000

#define EXYNOS5_PA_G3D			0x14AC0000

#define EXYNOS4_PA_SDRAM		0x40000000
#define EXYNOS5_PA_SDRAM		0x40000000

#define EXYNOS5430_PA_CMU_TOP		0x10030000
#define EXYNOS5430_PA_CMU_EGL		0x11800000
#define EXYNOS5430_PA_CMU_KFC		0x11900000
#define EXYNOS5430_PA_CMU_AUD		0x114C0000
#define EXYNOS5430_PA_CMU_BUS1		0x14800000
#define EXYNOS5430_PA_CMU_BUS2		0x13400000
#define EXYNOS5430_PA_CMU_CAM0		0x120D0000
#define EXYNOS5430_PA_CMU_CAM0_LOCAL	0x121C0000
#define EXYNOS5430_PA_CMU_CAM1		0x145D0000
#define EXYNOS5430_PA_CMU_CAM1_LOCAL	0x142F0000
#define EXYNOS5430_PA_CMU_CPIF		0x10FC0000
#define EXYNOS5430_PA_CMU_DISP		0x13B90000
#define EXYNOS5430_PA_CMU_FSYS		0x156E0000
#define EXYNOS5430_PA_CMU_G2D		0x12460000
#define EXYNOS5430_PA_CMU_G3D		0x14AA0000
#define EXYNOS5430_PA_CMU_GSCL		0x13CF0000
#define EXYNOS5430_PA_CMU_HEVC		0x14F80000
#define EXYNOS5430_PA_CMU_IMEM		0x11060000
#define EXYNOS5430_PA_CMU_ISP		0x146D0000
#define EXYNOS5430_PA_CMU_ISP_LOCAL	0x14360000
#define EXYNOS5430_PA_CMU_MFC0		0x15280000
#define EXYNOS5430_PA_CMU_MFC1		0x15380000
#define EXYNOS5430_PA_CMU_MIF		0x105B0000
#define EXYNOS5430_PA_CMU_MSCL		0x150D0000
#define EXYNOS5430_PA_CMU_PERIC		0x14C80000
#define EXYNOS5430_PA_CMU_PERIS		0x10040000

#if defined(CONFIG_SOC_EXYNOS5422)
#define EXYNOS5_PA_FIMC_LITE0		0x13C00000
#define EXYNOS5_PA_FIMC_LITE1		0x13C10000
#define EXYNOS5_PA_FIMC_LITE2		0x13D40000
#define EXYNOS5_PA_FIMC_LITE3		0x13D40000

#define EXYNOS5_PA_MIPI_CSIS0		0x13C20000
#define EXYNOS5_PA_MIPI_CSIS1		0x13C30000
#define EXYNOS5_PA_MIPI_CSIS2		0x13C30000
#else
#define EXYNOS5_PA_FIMC_LITE0		0x12100000
#define EXYNOS5_PA_FIMC_LITE1		0x12110000
#define EXYNOS5_PA_FIMC_LITE2		0x141C0000
#define EXYNOS5_PA_FIMC_LITE3		0x121F0000

#define EXYNOS5_PA_MIPI_CSIS0		0x12120000
#define EXYNOS5_PA_MIPI_CSIS1		0x12130000
#define EXYNOS5_PA_MIPI_CSIS2		0x141D0000
#endif

#define EXYNOS5_PA_SYSREG_DISP		0x13B81000
#define EXYNOS5_PA_SYSREG_CAM0		0x120F1000
#define EXYNOS5_PA_SYSREG_CAM1		0x145F1000
#define EXYNOS5_PA_SYSREG_HEVC		0x14FA0000
#define EXYNOS5_PA_SYSREG_MFC0		0x152A0000
#define EXYNOS5_PA_SYSREG_MFC1		0x153A0000

#define EXYNOS5430_PA_BTS_DECONM0	0x13A80000
#define EXYNOS5430_PA_BTS_DECONM1	0x13A90000
#define EXYNOS5430_PA_BTS_DECONM2	0x13AA0000
#define EXYNOS5430_PA_BTS_DECONM3	0x13AB0000
#define EXYNOS5430_PA_BTS_DECONM4	0x13AC0000
#define EXYNOS5430_PA_BTS_DECONTV_M0	0x13B00000
#define EXYNOS5430_PA_BTS_DECONTV_M1	0x13B10000
#define EXYNOS5430_PA_BTS_DECONTV_M2	0x13B20000
#define EXYNOS5430_PA_BTS_DECONTV_M3	0x13B30000
#define EXYNOS5430_PA_BTS_FIMC_LITE0	0x12000000
#define EXYNOS5430_PA_BTS_FIMC_LITE1	0x12010000
#define EXYNOS5430_PA_BTS_FIMC_LITE2	0x14500000
#define EXYNOS5430_PA_BTS_FIMC_LITE3	0x12020000
#define EXYNOS5430_PA_BTS_3AA0		0x12030000
#define EXYNOS5430_PA_BTS_3AA1		0x12040000
#define EXYNOS5430_PA_BTS_GSCL0		0x13CC0000
#define EXYNOS5430_PA_BTS_GSCL1		0x13CD0000
#define EXYNOS5430_PA_BTS_GSCL2		0x13CE0000

#define EXYNOS5_PA_BTS_MFC0		0x11220000
#define EXYNOS5_PA_BTS_MFC1		0x11230000
#define EXYNOS5_PA_BTS_ROTATOR		0x11D60000
#define EXYNOS5_PA_BTS_MDMA		0x10A80000
#define EXYNOS5_PA_BTS_MDMA1		0x11D70000
#define EXYNOS5_PA_BTS_JPEG		0x11F30000
#define EXYNOS5_PA_BTS_JPEG2		0x11F40000
#define EXYNOS5_PA_BTS_GSCL0		0x13EC0000
#define EXYNOS5_PA_BTS_GSCL1		0x13ED0000
#define EXYNOS5_PA_BTS_DISP10		0x14660000
#define EXYNOS5_PA_BTS_DISP11		0x14670000
#define EXYNOS5_PA_BTS_MIXER0		0x14690000
#define EXYNOS5_PA_BTS_MIXER1		0x146A0000
#define EXYNOS5_PA_BTS_EAGLE		0x10C80000
#define EXYNOS5_PA_BTS_KFC		0x10C90000
#define EXYNOS5_PA_BTS_G3D0		0x11A00000
#define EXYNOS5_PA_BTS_G3D1		0x11A20000
#define EXYNOS5_PA_BTS_G2D		0x10AA0000
#define EXYNOS5_PA_BTS_FIMCLITE0	0x13C60000
#define EXYNOS5_PA_BTS_FIMCLITE1	0x13C70000
#define EXYNOS5_PA_BTS_3AA_2		0x13CD0000
#define EXYNOS5_PA_BTS_3AA		0x13CE0000
#define EXYNOS5_PA_BTS_SSSSLIM		0x10920000
#define EXYNOS5_PA_BTS_SSS		0x10A90000
#define EXYNOS5_PA_BTS_USBDRD300	0x123B0000
#define EXYNOS5_PA_BTS_USBDRD301	0x123C0000
#define EXYNOS5_PA_BTS_UFS		0x12620000
#define EXYNOS5_PA_BTS_MMC0		0x12670000
#define EXYNOS5_PA_BTS_MMC1		0x126B0000
#define EXYNOS5_PA_BTS_MMC2		0x126F0000
#define EXYNOS5_PA_BTS_MSCL0		0x12840000
#define EXYNOS5_PA_BTS_MSCL1		0x12850000
#define EXYNOS5_PA_BTS_MSCL2		0x12860000

#define EXYNOS5422_NOCP_MEM0_0_BASE 0x10CA1000
#define EXYNOS5422_NOCP_MEM0_1_BASE 0x10CA1400
#define EXYNOS5422_NOCP_MEM1_0_BASE 0x10CA1800
#define EXYNOS5422_NOCP_MEM1_1_BASE 0x10CA1C00

#define EXYNOS5422_PA_PPMU_DREX0_0      0x10D00000
#define EXYNOS5422_PA_PPMU_DREX0_1      0x10D10000
#define EXYNOS5422_PA_PPMU_DREX1_0      0x10D60000
#define EXYNOS5422_PA_PPMU_DREX1_1      0x10D70000

#define NOCP_BASE(_name)        EXYNOS5422_NOCP_##_name##_BASE

/* DREX PA Defines */
#define EXYNOS5_PA_DREXI_1      0x10C30000
#define EXYNOS5_PA_DREXI_0      0x10C20000

/* Compatibiltiy Defines */

#define S3C_PA_HSMMC0			EXYNOS4_PA_HSMMC(0)
#define S3C_PA_HSMMC1			EXYNOS4_PA_HSMMC(1)
#define S3C_PA_HSMMC2			EXYNOS4_PA_HSMMC(2)
#define S3C_PA_HSMMC3			EXYNOS4_PA_HSMMC(3)
#define S3C_PA_IIC			EXYNOS4_PA_IIC(0)
#define S3C_PA_IIC1			EXYNOS4_PA_IIC(1)
#define S3C_PA_IIC2			EXYNOS4_PA_IIC(2)
#define S3C_PA_IIC3			EXYNOS4_PA_IIC(3)
#define S3C_PA_IIC4			EXYNOS4_PA_IIC(4)
#define S3C_PA_IIC5			EXYNOS4_PA_IIC(5)
#define S3C_PA_IIC6			EXYNOS4_PA_IIC(6)
#define S3C_PA_IIC7			EXYNOS4_PA_IIC(7)
#define S3C_PA_RTC			EXYNOS4_PA_RTC
#define S3C_PA_WDT			EXYNOS4_PA_WATCHDOG
#define S3C_PA_SPI0			EXYNOS4_PA_SPI0
#define S3C_PA_SPI1			EXYNOS4_PA_SPI1
#define S3C_PA_SPI2			EXYNOS4_PA_SPI2
#define S3C_PA_USB_HSOTG		EXYNOS4_PA_HSOTG

#define S5P_PA_EHCI			EXYNOS4_PA_EHCI
#define S5P_PA_FIMC0			EXYNOS4_PA_FIMC0
#define S5P_PA_FIMC1			EXYNOS4_PA_FIMC1
#define S5P_PA_FIMC2			EXYNOS4_PA_FIMC2
#define S5P_PA_FIMC3			EXYNOS4_PA_FIMC3
#define S5P_PA_JPEG			EXYNOS4_PA_JPEG
#define S5P_PA_G2D			EXYNOS4_PA_G2D
#define S5P_PA_FIMD0			EXYNOS4_PA_FIMD0
#define S5P_PA_HDMI			EXYNOS4_PA_HDMI
#define S5P_PA_IIC_HDMIPHY		EXYNOS4_PA_IIC_HDMIPHY
#define S5P_PA_MFC			EXYNOS4_PA_MFC
#define S5P_PA_MIPI_CSIS0		EXYNOS4_PA_MIPI_CSIS0
#define S5P_PA_MIPI_CSIS1		EXYNOS4_PA_MIPI_CSIS1
#define S5P_PA_MIXER			EXYNOS4_PA_MIXER
#define S5P_PA_ONENAND			EXYNOS4_PA_ONENAND
#define S5P_PA_ONENAND_DMA		EXYNOS4_PA_ONENAND_DMA
#define S5P_PA_SDO			EXYNOS4_PA_SDO
#define S5P_PA_SDRAM			EXYNOS4_PA_SDRAM
#define S5P_PA_VP			EXYNOS4_PA_VP

#define SAMSUNG_PA_ADC			EXYNOS4_PA_ADC
#define SAMSUNG_PA_ADC1			EXYNOS4_PA_ADC1
#define SAMSUNG_PA_KEYPAD		EXYNOS4_PA_KEYPAD

/* Compatibility UART */

#define EXYNOS4_PA_UART0		0x13800000
#define EXYNOS4_PA_UART1		0x13810000
#define EXYNOS4_PA_UART2		0x13820000
#define EXYNOS4_PA_UART3		0x13830000
#define EXYNOS4_SZ_UART			SZ_256

#define EXYNOS5_PA_UART0		0x12C00000
#define EXYNOS5_PA_UART1		0x12C10000
#define EXYNOS5_PA_UART2		0x12C20000
#define EXYNOS5_PA_UART3		0x12C30000

#define EXYNOS5440_PA_UART0		0x000B0000
#define EXYNOS5440_PA_UART1		0x000C0000
#define EXYNOS5440_SZ_UART		SZ_256

#define EXYNOS5430_PA_MSCLSYS		0x150E0000

#define S3C_VA_UARTx(x)			(S3C_VA_UART + ((x) * S3C_UART_OFFSET))

#define EXYNOS5430_VA_CMU_TOP		(S5P_VA_CMU + (SZ_4K * 0))
#define EXYNOS5430_VA_CMU_EGL		(S5P_VA_CMU + (SZ_4K * 1))
#define EXYNOS5430_VA_CMU_KFC		(S5P_VA_CMU + (SZ_4K * 3))
#define EXYNOS5430_VA_CMU_AUD		(S5P_VA_CMU + (SZ_4K * 5))
#define EXYNOS5430_VA_CMU_BUS1		(S5P_VA_CMU + (SZ_4K * 6))
#define EXYNOS5430_VA_CMU_BUS2		(S5P_VA_CMU + (SZ_4K * 7))
#define EXYNOS5430_VA_CMU_CAM0		(S5P_VA_CMU + (SZ_4K * 8))
#define EXYNOS5430_VA_CMU_CAM0_LOCAL	(S5P_VA_CMU + (SZ_4K * 9))
#define EXYNOS5430_VA_CMU_CAM1		(S5P_VA_CMU + (SZ_4K * 10))
#define EXYNOS5430_VA_CMU_CAM1_LOCAL	(S5P_VA_CMU + (SZ_4K * 11))
#define EXYNOS5430_VA_CMU_CPIF		(S5P_VA_CMU + (SZ_4K * 12))
#define EXYNOS5430_VA_CMU_DISP		(S5P_VA_CMU + (SZ_4K * 13))
#define EXYNOS5430_VA_CMU_FSYS		(S5P_VA_CMU + (SZ_4K * 14))
#define EXYNOS5430_VA_CMU_G2D		(S5P_VA_CMU + (SZ_4K * 15))
#define EXYNOS5430_VA_CMU_G3D		(S5P_VA_CMU + (SZ_4K * 16))
#define EXYNOS5430_VA_CMU_GSCL		(S5P_VA_CMU + (SZ_4K * 17))
#define EXYNOS5430_VA_CMU_HEVC		(S5P_VA_CMU + (SZ_4K * 18))
#define EXYNOS5430_VA_CMU_IMEM		(S5P_VA_CMU + (SZ_4K * 19))
#define EXYNOS5430_VA_CMU_ISP		(S5P_VA_CMU + (SZ_4K * 20))
#define EXYNOS5430_VA_CMU_ISP_LOCAL	(S5P_VA_CMU + (SZ_4K * 21))
#define EXYNOS5430_VA_CMU_MFC0		(S5P_VA_CMU + (SZ_4K * 22))
#define EXYNOS5430_VA_CMU_MFC1		(S5P_VA_CMU + (SZ_4K * 23))
#define EXYNOS5430_VA_CMU_MIF		(S5P_VA_CMU + (SZ_4K * 24))
#define EXYNOS5430_VA_CMU_MSCL		(S5P_VA_CMU + (SZ_4K * 25))
#define EXYNOS5430_VA_CMU_PERIC		(S5P_VA_CMU + (SZ_4K * 26))
#define EXYNOS5430_VA_CMU_PERIS		(S5P_VA_CMU + (SZ_4K * 27))

#define EXYNOS5430_VA_PMU_LPI_CAM0	(S5P_VA_PMU + SZ_64K + (SZ_4K * 0))
#define EXYNOS5430_VA_PMU_LPI_CAM1	(S5P_VA_PMU + SZ_64K + (SZ_4K * 1))
#define EXYNOS5430_VA_PMU_LPI_ISP	(S5P_VA_PMU + SZ_64K + (SZ_4K * 2))

#endif /* __ASM_ARCH_MAP_H */
