/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.applet.Applet;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.FramePeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Set;
import sun.awt.AWTAccessor;
import sun.awt.NullComponentPeer;
import sun.awt.SunToolkit;

public abstract class EmbeddedFrame
extends Frame
implements KeyEventDispatcher,
PropertyChangeListener {
    private boolean isCursorAllowed = true;
    private boolean supportsXEmbed = false;
    private KeyboardFocusManager appletKFM;
    private static final long serialVersionUID = 2967042741780317130L;
    protected static final boolean FORWARD = true;
    protected static final boolean BACKWARD = false;

    public boolean supportsXEmbed() {
        return this.supportsXEmbed && SunToolkit.needsXEmbed();
    }

    protected EmbeddedFrame(boolean bl) {
        this(0L, bl);
    }

    protected EmbeddedFrame() {
        this(0L);
    }

    @Deprecated
    protected EmbeddedFrame(int n) {
        this((long)n);
    }

    protected EmbeddedFrame(long l) {
        this(l, false);
    }

    protected EmbeddedFrame(long l, boolean bl) {
        this.supportsXEmbed = bl;
        this.registerListeners();
    }

    @Override
    public Container getParent() {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals("managingFocus")) {
            return;
        }
        if (propertyChangeEvent.getNewValue() == Boolean.TRUE) {
            return;
        }
        this.removeTraversingOutListeners((KeyboardFocusManager)propertyChangeEvent.getSource());
        this.appletKFM = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (this.isVisible()) {
            this.addTraversingOutListeners(this.appletKFM);
        }
    }

    private void addTraversingOutListeners(KeyboardFocusManager keyboardFocusManager) {
        keyboardFocusManager.addKeyEventDispatcher(this);
        keyboardFocusManager.addPropertyChangeListener("managingFocus", this);
    }

    private void removeTraversingOutListeners(KeyboardFocusManager keyboardFocusManager) {
        keyboardFocusManager.removeKeyEventDispatcher(this);
        keyboardFocusManager.removePropertyChangeListener("managingFocus", this);
    }

    public void registerListeners() {
        if (this.appletKFM != null) {
            this.removeTraversingOutListeners(this.appletKFM);
        }
        this.appletKFM = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (this.isVisible()) {
            this.addTraversingOutListeners(this.appletKFM);
        }
    }

    @Override
    public void show() {
        if (this.appletKFM != null) {
            this.addTraversingOutListeners(this.appletKFM);
        }
        super.show();
    }

    @Override
    public void hide() {
        if (this.appletKFM != null) {
            this.removeTraversingOutListeners(this.appletKFM);
        }
        super.hide();
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        Component component;
        Container container = AWTAccessor.getKeyboardFocusManagerAccessor().getCurrentFocusCycleRoot();
        if (this != container) {
            return false;
        }
        if (keyEvent.getID() == 400) {
            return false;
        }
        if (!this.getFocusTraversalKeysEnabled() || keyEvent.isConsumed()) {
            return false;
        }
        AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
        Component component2 = keyEvent.getComponent();
        Set<AWTKeyStroke> set = this.getFocusTraversalKeys(0);
        if (set.contains(aWTKeyStroke) && (component2 == (component = this.getFocusTraversalPolicy().getLastComponent(this)) || component == null) && this.traverseOut(true)) {
            keyEvent.consume();
            return true;
        }
        set = this.getFocusTraversalKeys(1);
        if (set.contains(aWTKeyStroke) && (component2 == (component = this.getFocusTraversalPolicy().getFirstComponent(this)) || component == null) && this.traverseOut(false)) {
            keyEvent.consume();
            return true;
        }
        return false;
    }

    public boolean traverseIn(boolean bl) {
        Component component = null;
        component = bl ? this.getFocusTraversalPolicy().getFirstComponent(this) : this.getFocusTraversalPolicy().getLastComponent(this);
        if (component != null) {
            AWTAccessor.getKeyboardFocusManagerAccessor().setMostRecentFocusOwner(this, component);
            this.synthesizeWindowActivation(true);
        }
        return null != component;
    }

    protected boolean traverseOut(boolean bl) {
        return false;
    }

    @Override
    public void setTitle(String string) {
    }

    @Override
    public void setIconImage(Image image) {
    }

    @Override
    public void setIconImages(List<? extends Image> list) {
    }

    @Override
    public void setMenuBar(MenuBar menuBar) {
    }

    @Override
    public void setResizable(boolean bl) {
    }

    @Override
    public void remove(MenuComponent menuComponent) {
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getPeer() == null) {
                this.setPeer(new NullEmbeddedFramePeer());
            }
            super.addNotify();
        }
    }

    public void setCursorAllowed(boolean bl) {
        this.isCursorAllowed = bl;
        this.getPeer().updateCursorImmediately();
    }

    public boolean isCursorAllowed() {
        return this.isCursorAllowed;
    }

    @Override
    public Cursor getCursor() {
        return this.isCursorAllowed ? super.getCursor() : Cursor.getPredefinedCursor(0);
    }

    protected void setPeer(ComponentPeer componentPeer) {
        AWTAccessor.getComponentAccessor().setPeer(this, componentPeer);
    }

    public void synthesizeWindowActivation(boolean bl) {
    }

    public boolean requestFocusToEmbedder() {
        return false;
    }

    protected void setLocationPrivate(int n, int n2) {
        Dimension dimension = this.getSize();
        this.setBoundsPrivate(n, n2, dimension.width, dimension.height);
    }

    protected Point getLocationPrivate() {
        Rectangle rectangle = this.getBoundsPrivate();
        return new Point(rectangle.x, rectangle.y);
    }

    protected void setBoundsPrivate(int n, int n2, int n3, int n4) {
        FramePeer framePeer = (FramePeer)this.getPeer();
        if (framePeer != null) {
            framePeer.setBoundsPrivate(n, n2, n3, n4);
        }
    }

    protected Rectangle getBoundsPrivate() {
        FramePeer framePeer = (FramePeer)this.getPeer();
        if (framePeer != null) {
            return framePeer.getBoundsPrivate();
        }
        return this.getBounds();
    }

    @Override
    public void toFront() {
    }

    @Override
    public void toBack() {
    }

    public abstract void registerAccelerator(AWTKeyStroke var1);

    public abstract void unregisterAccelerator(AWTKeyStroke var1);

    public static Applet getAppletIfAncestorOf(Component component) {
        Container container;
        Applet applet = null;
        for (container = component.getParent(); container != null && !(container instanceof EmbeddedFrame); container = container.getParent()) {
            if (!(container instanceof Applet)) continue;
            applet = (Applet)container;
        }
        return container == null ? null : applet;
    }

    public void notifyModalBlocked(Dialog dialog, boolean bl) {
    }

    private static class NullEmbeddedFramePeer
    extends NullComponentPeer
    implements FramePeer {
        private NullEmbeddedFramePeer() {
        }

        @Override
        public void setTitle(String string) {
        }

        public void setIconImage(Image image) {
        }

        @Override
        public void updateIconImages() {
        }

        @Override
        public void setMenuBar(MenuBar menuBar) {
        }

        @Override
        public void setResizable(boolean bl) {
        }

        @Override
        public void setState(int n) {
        }

        @Override
        public int getState() {
            return 0;
        }

        @Override
        public void setMaximizedBounds(Rectangle rectangle) {
        }

        @Override
        public void toFront() {
        }

        @Override
        public void toBack() {
        }

        @Override
        public void updateFocusableWindowState() {
        }

        public void updateAlwaysOnTop() {
        }

        @Override
        public void updateAlwaysOnTopState() {
        }

        public Component getGlobalHeavyweightFocusOwner() {
            return null;
        }

        @Override
        public void setBoundsPrivate(int n, int n2, int n3, int n4) {
            this.setBounds(n, n2, n3, n4, 3);
        }

        @Override
        public Rectangle getBoundsPrivate() {
            return this.getBounds();
        }

        @Override
        public void setModalBlocked(Dialog dialog, boolean bl) {
        }

        public void restack() {
            throw new UnsupportedOperationException();
        }

        public boolean isRestackSupported() {
            return false;
        }

        public boolean requestWindowFocus() {
            return false;
        }

        @Override
        public void updateMinimumSize() {
        }

        @Override
        public void setOpacity(float f) {
        }

        @Override
        public void setOpaque(boolean bl) {
        }

        @Override
        public void updateWindow() {
        }

        @Override
        public void repositionSecurityWarning() {
        }

        @Override
        public void emulateActivation(boolean bl) {
        }
    }
}

