/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import java.util.Collections;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.resolve.LibraryPublishArtifact;
import org.gradle.api.internal.resolve.LocalLibraryMetaDataAdapter;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.language.base.internal.model.DefaultLibraryLocalComponentMetaData;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.DependencySpec;

public class JvmLocalLibraryMetaDataAdapter
implements LocalLibraryMetaDataAdapter {
    public DefaultLibraryLocalComponentMetaData createLocalComponentMetaData(BinarySpec selectedBinary, TaskDependency buildDependencies, String projectPath) {
        JarBinarySpec jarBinarySpec = (JarBinarySpec)selectedBinary;
        DefaultLibraryLocalComponentMetaData metaData = DefaultLibraryLocalComponentMetaData.newMetaData((LibraryBinaryIdentifier)jarBinarySpec.getId(), (TaskDependency)buildDependencies);
        LibraryPublishArtifact jarBinary = new LibraryPublishArtifact("jar", jarBinarySpec.getApiJarFile());
        metaData.addArtifacts("API", Collections.singleton(jarBinary));
        this.addApiDependenciesTo(metaData, jarBinarySpec, projectPath);
        return metaData;
    }

    private void addApiDependenciesTo(DefaultLibraryLocalComponentMetaData metaData, JarBinarySpec binary, String projectPath) {
        for (DependencySpec dependency : binary.getApiDependencies()) {
            metaData.addDependency(dependency, projectPath);
        }
    }
}

