/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.userinterface.swing.common;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import org.gradle.gradleplugin.foundation.search.TextBlockSearchEditor;
import org.gradle.gradleplugin.userinterface.swing.common.SearchPanel;
import org.gradle.gradleplugin.userinterface.swing.generic.Utility;

public class TextPaneSearchInteraction
implements SearchPanel.SearchInteraction {
    private JTextPane textComponentToSearch;
    private AttributeSet defaultStyle;
    private AttributeSet highlightStyle;
    private AttributeSet emphasizedHighlightStyle;
    private List<TextBlockSearchEditor.SearchResult> currentHighlights = new ArrayList<TextBlockSearchEditor.SearchResult>();

    public TextPaneSearchInteraction(JTextPane textComponentToSearch, AttributeSet defaultStyle, AttributeSet highlightStyle, AttributeSet emphasizedHighlightStyle) {
        this.textComponentToSearch = textComponentToSearch;
        this.defaultStyle = defaultStyle;
        this.highlightStyle = highlightStyle;
        this.emphasizedHighlightStyle = emphasizedHighlightStyle;
    }

    public void searchComplete(TextBlockSearchEditor editor) {
        this.removeResultHighlights();
        if (editor.hasMatches()) {
            this.currentHighlights.addAll(editor.getMatchedResults());
            this.highlightResults(editor, true);
        }
    }

    private void highlightResults(TextBlockSearchEditor editor, boolean highlightFirst) {
        this.currentHighlights.clear();
        boolean isFirst = highlightFirst;
        for (TextBlockSearchEditor.SearchResult searchResult : editor.getMatchedResults()) {
            this.highlightText(searchResult.getBeginningIndexOfMatch(), searchResult.getEndingIndexOfMatch(), isFirst, isFirst);
            isFirst = false;
            this.currentHighlights.add(searchResult);
        }
    }

    public void removeResultHighlights() {
        this.removeExistingHighlights();
    }

    private void removeExistingHighlights() {
        for (TextBlockSearchEditor.SearchResult searchResult : this.currentHighlights) {
            this.removeTextHighlightText(searchResult.getBeginningIndexOfMatch(), searchResult.getEndingIndexOfMatch());
        }
    }

    public void removeTextHighlightText(int startingIndex, int endingIndex) {
        int length = endingIndex - startingIndex;
        ((DefaultStyledDocument)this.textComponentToSearch.getDocument()).setCharacterAttributes(startingIndex, length, this.defaultStyle, true);
    }

    public String getTextToSearch() {
        return this.textComponentToSearch.getText();
    }

    public int getCaretLocation() {
        return this.textComponentToSearch.getCaretPosition();
    }

    public void highlightAndScrollToResult(TextBlockSearchEditor editor, TextBlockSearchEditor.SearchResult searchResult) {
        this.highlightResults(editor, false);
        this.highlightText(searchResult.getBeginningIndexOfMatch(), searchResult.getEndingIndexOfMatch(), true, true);
    }

    public void highlightText(int startingIndex, int endingIndex, boolean ensureVisible, boolean isEmphasized) {
        int length = endingIndex - startingIndex;
        AttributeSet style = isEmphasized ? this.emphasizedHighlightStyle : this.highlightStyle;
        ((DefaultStyledDocument)this.textComponentToSearch.getDocument()).setCharacterAttributes(startingIndex, length, style, true);
        if (ensureVisible) {
            Utility.scrollToText(this.textComponentToSearch, startingIndex, endingIndex);
            this.textComponentToSearch.setCaretPosition(endingIndex);
        }
        this.textComponentToSearch.repaint();
    }
}

