/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.testing.junit.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.CompositeTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllTestResults
extends CompositeTestResults {
    private final Map<String, PackageTestResults> packages = new TreeMap<String, PackageTestResults>();

    public AllTestResults() {
        super(null);
    }

    @Override
    public String getTitle() {
        return "Test Summary";
    }

    @Override
    public String getBaseUrl() {
        return "index.html";
    }

    public Collection<PackageTestResults> getPackages() {
        return this.packages.values();
    }

    public TestResult addTest(long classId, String className, String testName, long duration) {
        PackageTestResults packageResults = this.addPackageForClass(className);
        return this.addTest(packageResults.addTest(classId, className, testName, duration));
    }

    public ClassTestResults addTestClass(long classId, String className) {
        return this.addPackageForClass(className).addClass(classId, className);
    }

    private PackageTestResults addPackageForClass(String className) {
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        if (packageName.equals(className)) {
            packageName = "";
        }
        return this.addPackage(packageName);
    }

    private PackageTestResults addPackage(String packageName) {
        PackageTestResults packageResults = this.packages.get(packageName);
        if (packageResults == null) {
            packageResults = new PackageTestResults(packageName, this);
            this.packages.put(packageName, packageResults);
        }
        return packageResults;
    }
}

