/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks.apigen.abi;

import java.util.Collection;
import org.gradle.language.base.internal.tasks.apigen.abi.JavaBaseModule;
import org.gradle.language.base.internal.tasks.apigen.abi.MemberOfApiChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMemberOfApiChecker
implements MemberOfApiChecker {
    private final Collection<String> allowedPackages;

    public DefaultMemberOfApiChecker(Collection<String> allowedPackages) {
        this.allowedPackages = allowedPackages;
    }

    private static String extractPackageName(String className) {
        return className.indexOf(".") > 0 ? className.substring(0, className.lastIndexOf(".")) : "";
    }

    @Override
    public boolean belongsToApi(String className) {
        String pkg = DefaultMemberOfApiChecker.extractPackageName(className);
        for (String javaBasePackage : JavaBaseModule.PACKAGES) {
            if (!pkg.equals(javaBasePackage)) continue;
            return true;
        }
        boolean allowed = false;
        for (String allowedPackage : this.allowedPackages) {
            if (!pkg.equals(allowedPackage)) continue;
            allowed = true;
            break;
        }
        return allowed;
    }
}

