/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javajs.img.ImageEncoder;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.T3;

public class GifEncoder
extends ImageEncoder {
    private Map<String, Object> params;
    private P3[] palette;
    private int backgroundColor;
    private boolean interlaced;
    private boolean addHeader = true;
    private boolean addImage = true;
    private boolean addTrailer = true;
    private boolean isTransparent;
    private boolean floydSteinberg = true;
    private boolean capturing;
    private boolean looping;
    private int delayTime100ths = -1;
    private int bitsPerPixel = 1;
    private int byteCount;
    private static M3 xyz2rgb;
    private static M3 rgb2xyz;
    private int initCodeSize;
    private int curpt;
    private static final int EOF = -1;
    private static final int[] INTERLACE_PARAMS;
    private static final int BITS = 12;
    private static final int HSIZE = 5003;
    private int nBits;
    private int maxbits = 12;
    private int maxcode;
    private int maxmaxcode = 4096;
    private int[] htab = new int[5003];
    private int[] codetab = new int[5003];
    private int hsize = 5003;
    private int freeEnt = 0;
    private boolean clearFlag = false;
    private int clearCode;
    private int EOFCode;
    private int countDown;
    private int pass = 0;
    private int curx;
    private int cury;
    private int curAccum = 0;
    private int curBits = 0;
    private int[] masks;
    private int bufPt;
    private final byte[] buf;

    static {
        rgb2xyz = M3.newA9(new float[]{0.4124f, 0.3576f, 0.1805f, 0.2126f, 0.7152f, 0.0722f, 0.0193f, 0.1192f, 0.9505f});
        xyz2rgb = M3.newA9(new float[]{3.2406f, -1.5372f, -0.4986f, -0.9689f, 1.8758f, 0.0415f, 0.0557f, -0.204f, 1.057f});
        int[] nArray = new int[8];
        nArray[0] = 8;
        nArray[1] = 8;
        nArray[2] = 4;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 2;
        nArray[6] = 1;
        INTERLACE_PARAMS = nArray;
    }

    public GifEncoder() {
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        this.masks = nArray;
        this.buf = new byte[256];
    }

    @Override
    protected void setParams(Map<String, Object> params) {
        this.params = params;
        Integer ic = (Integer)params.get("transparentColor");
        if (ic == null) {
            ic = (Integer)params.get("backgroundColor");
            if (ic != null) {
                this.backgroundColor = ic;
            }
        } else {
            this.backgroundColor = ic;
            this.isTransparent = true;
        }
        boolean bl = this.interlaced = Boolean.TRUE == params.get("interlaced");
        if (params.containsKey("captureRootExt") || !params.containsKey("captureMode")) {
            return;
        }
        this.interlaced = false;
        this.capturing = true;
        try {
            this.byteCount = (Integer)params.get("captureByteCount");
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch ("maec".indexOf(((String)params.get("captureMode")).substring(0, 1))) {
            case 0: {
                params.put("captureMode", "add");
                this.addImage = false;
                this.addTrailer = false;
                break;
            }
            case 1: {
                this.addHeader = false;
                this.addTrailer = false;
                int fps = Math.abs((Integer)params.get("captureFps"));
                this.delayTime100ths = fps == 0 ? 0 : 100 / fps;
                this.looping = Boolean.FALSE != params.get("captureLooping");
                break;
            }
            case 2: {
                this.addHeader = false;
                this.addImage = false;
                break;
            }
            case 3: {
                this.addHeader = false;
                this.addImage = false;
                this.out.cancel();
            }
        }
    }

    @Override
    protected void generate() throws IOException {
        if (this.addHeader) {
            this.writeHeader();
        }
        this.addHeader = false;
        if (this.addImage) {
            this.createPalette();
            this.writeGraphicControlExtension();
            if (this.delayTime100ths >= 0 && this.looping) {
                this.writeNetscapeLoopExtension();
            }
            this.writeImage();
        }
    }

    @Override
    protected void close() {
        if (this.addTrailer) {
            this.writeTrailer();
        } else {
            this.doClose = false;
        }
        if (this.capturing) {
            this.params.put("captureByteCount", this.byteCount);
        }
    }

    private void createPalette() {
        Lst<ColorItem> tempColors = new Lst<ColorItem>();
        Hashtable<Integer, ColorItem> ciHash = new Hashtable<Integer, ColorItem>();
        int i = 0;
        int n = this.pixels.length;
        while (i < n) {
            int rgb = this.pixels[i];
            Integer key = rgb;
            ColorItem item = (ColorItem)ciHash.get(key);
            if (item == null) {
                item = new ColorItem(rgb, rgb == this.backgroundColor);
                ciHash.put(key, item);
                tempColors.addLast(item);
            }
            ++i;
        }
        int nColors = tempColors.size();
        System.out.println("GIF total image colors: " + nColors);
        ciHash = null;
        Lst<ColorCell> cells = this.quantizeColors(tempColors);
        nColors = cells.size();
        System.out.println("GIF final color count: " + nColors);
        Hashtable<Integer, ColorCell> colorMap = new Hashtable<Integer, ColorCell>();
        this.bitsPerPixel = nColors <= 2 ? 1 : (nColors <= 4 ? 2 : (nColors <= 16 ? 4 : 8));
        this.palette = new P3[1 << this.bitsPerPixel];
        int i2 = 0;
        while (i2 < nColors) {
            ColorCell c = (ColorCell)cells.get(i2);
            this.palette[i2] = c.setColor();
            colorMap.put(CU.colorPtToFFRGB(this.palette[i2]), c);
            ++i2;
        }
        this.pixels = this.indexPixels(cells, colorMap);
    }

    private Lst<ColorCell> quantizeColors(Lst<ColorItem> tempColors) {
        int n = tempColors.size();
        Lst<ColorCell> cells = new Lst<ColorCell>();
        ColorCell cc = new ColorCell(0);
        cc.addLast(new ColorItem(this.backgroundColor, true));
        cells.addLast(cc);
        cc = new ColorCell(1);
        if (n > 256) {
            cells.addLast(cc);
        }
        int i = 0;
        while (i < n) {
            ColorItem c = (ColorItem)tempColors.get(i);
            if (!c.isBackground) {
                cc.addLast(c);
                if (n <= 256) {
                    cells.addLast(cc);
                    cc = new ColorCell(cells.size());
                }
            }
            ++i;
        }
        tempColors.clear();
        if (n > 256) {
            while ((n = cells.size()) < 256) {
                float maxVol = 0.0f;
                ColorCell maxCell = null;
                int i2 = n;
                while (--i2 >= 1) {
                    ColorCell c = (ColorCell)cells.get(i2);
                    float v = c.getVolume(false);
                    if (!(v > maxVol)) continue;
                    maxVol = v;
                    maxCell = c;
                }
                if (maxCell == null || !maxCell.splitCell(cells)) break;
            }
        }
        return cells;
    }

    private int[] indexPixels(Lst<ColorCell> cells, Map<Integer, ColorCell> colorMap) {
        int w2 = this.width + 2;
        P3[] errors = new P3[w2];
        int[] newPixels = new int[this.pixels.length];
        P3 err = new P3();
        Hashtable<Integer, ColorCell> nearestCell = new Hashtable<Integer, ColorCell>();
        int i = 0;
        int p = 0;
        while (i < this.height) {
            boolean notLastRow = i != this.height - 1;
            int j = 0;
            while (j < this.width) {
                if (this.pixels[p] != this.backgroundColor) {
                    int rgb;
                    P3 lab;
                    P3 pe = errors[p % w2];
                    if (pe == null || pe.x == Float.MAX_VALUE) {
                        lab = null;
                        rgb = this.pixels[p];
                    } else {
                        lab = this.toLABnorm(this.pixels[p]);
                        err = pe;
                        err.x = this.clamp(err.x, -75.0f, 75.0f);
                        err.y = this.clamp(err.y, -75.0f, 75.0f);
                        err.z = this.clamp(err.z, -75.0f, 75.0f);
                        lab.add(err);
                        rgb = CU.colorPtToFFRGB(this.toRGB(lab));
                    }
                    Integer key = rgb;
                    ColorCell cell = colorMap.get(key);
                    if (cell == null) {
                        lab = this.toLABnorm(rgb);
                        cell = (ColorCell)nearestCell.get(key);
                        if (cell == null) {
                            float maxerr = Float.MAX_VALUE;
                            int ib = cells.size();
                            while (--ib >= 1) {
                                ColorCell c = (ColorCell)cells.get(ib);
                                err.sub2(lab, c.center);
                                float d = err.lengthSquared();
                                if (!(d < maxerr)) continue;
                                maxerr = d;
                                cell = c;
                            }
                            nearestCell.put(key, cell);
                        }
                        if (this.floydSteinberg) {
                            boolean notLastCol;
                            err.sub2(lab, cell.center);
                            boolean bl = notLastCol = j < this.width - 1;
                            if (notLastCol) {
                                this.addError(err, 7, errors, p + 1, w2);
                            }
                            if (notLastRow) {
                                if (j > 0) {
                                    this.addError(err, 3, errors, p + this.width - 1, w2);
                                }
                                this.addError(err, 5, errors, p + this.width, w2);
                                if (notLastCol) {
                                    this.addError(err, 1, errors, p + this.width + 1, w2);
                                }
                            }
                        }
                        err.x = Float.MAX_VALUE;
                    }
                    newPixels[p] = cell.index;
                }
                ++j;
                ++p;
            }
            ++i;
        }
        return newPixels;
    }

    private void addError(P3 err, int f, P3[] errors, int p, int w2) {
        if (this.pixels[p] == this.backgroundColor) {
            return;
        }
        P3 errp = errors[p %= w2];
        if (errp == null) {
            errp = errors[p] = new P3();
        } else if (errp.x == Float.MAX_VALUE) {
            errp.set(0.0f, 0.0f, 0.0f);
        }
        errp.scaleAdd2((float)f / 16.0f, err, errp);
    }

    protected P3 toLABnorm(int rgb) {
        P3 lab = CU.colorPtFromInt(rgb, null);
        this.rgbToXyz(lab, lab);
        this.xyzToLab(lab, lab);
        lab.y = (lab.y + 86.185f) / 184.439f * 100.0f;
        lab.z = (lab.z + 107.863f) / 202.345f * 100.0f;
        return lab;
    }

    protected P3 toRGB(P3 lab) {
        P3 xyz = P3.newP(lab);
        xyz.y = xyz.y / 100.0f * 184.439f - 86.185f;
        xyz.z = xyz.z / 100.0f * 202.345f - 107.863f;
        this.labToXyz(xyz, xyz);
        return this.xyzToRgb(xyz, xyz);
    }

    public P3 rgbToXyz(P3 rgb, P3 xyz) {
        if (xyz == null) {
            xyz = new P3();
        }
        xyz.x = this.sxyz(rgb.x);
        xyz.y = this.sxyz(rgb.y);
        xyz.z = this.sxyz(rgb.z);
        rgb2xyz.rotate(xyz);
        return xyz;
    }

    private float sxyz(float x) {
        return (float)((double)(x /= 255.0f) <= 0.04045 ? (double)x / 12.92 : Math.pow(((double)x + 0.055) / 1.055, 2.4)) * 100.0f;
    }

    public P3 xyzToRgb(P3 xyz, P3 rgb) {
        if (rgb == null) {
            rgb = new P3();
        }
        rgb.setT(xyz);
        rgb.scale(0.01f);
        xyz2rgb.rotate(rgb);
        rgb.x = this.clamp(this.srgb(rgb.x), 0.0f, 255.0f);
        rgb.y = this.clamp(this.srgb(rgb.y), 0.0f, 255.0f);
        rgb.z = this.clamp(this.srgb(rgb.z), 0.0f, 255.0f);
        return rgb;
    }

    private float srgb(float x) {
        return (float)(x > 0.0031308f ? 1.055 * Math.pow(x, 0.4166666666666667) - 0.055 : (double)x * 12.92) * 255.0f;
    }

    public P3 xyzToLab(P3 xyz, P3 lab) {
        if (lab == null) {
            lab = new P3();
        }
        float x = this.flab(xyz.x / 95.0429f);
        float y = this.flab(xyz.y / 100.0f);
        float z = this.flab(xyz.z / 108.89f);
        lab.x = 116.0f * y - 16.0f;
        lab.y = 500.0f * (x - y);
        lab.z = 200.0f * (y - z);
        return lab;
    }

    private float flab(float t) {
        return (float)((double)t > 0.00885645168 ? Math.pow(t, 0.333333333) : 7.78703704 * (double)t + 0.137931034);
    }

    public P3 labToXyz(P3 lab, P3 xyz) {
        if (xyz == null) {
            xyz = new P3();
        }
        xyz.setT(lab);
        float y = (xyz.x + 16.0f) / 116.0f;
        float x = xyz.y / 500.0f + y;
        float z = y - xyz.z / 200.0f;
        xyz.x = this.fxyz(x) * 95.0429f;
        xyz.y = this.fxyz(y) * 100.0f;
        xyz.z = this.fxyz(z) * 108.89f;
        return xyz;
    }

    private float fxyz(float t) {
        return (float)((double)t > 0.206896552 ? (double)(t * t * t) : 0.128418549 * ((double)t - 0.137931034));
    }

    private float clamp(float c, float min, float max) {
        c = c < min ? min : (c > max ? max : c);
        return min == 0.0f ? (float)Math.round(c) : c;
    }

    private void writeHeader() throws IOException {
        this.putString("GIF89a");
        this.putWord(this.width);
        this.putWord(this.height);
        this.putByte(0);
        this.putByte(0);
        this.putByte(0);
    }

    private void writeGraphicControlExtension() {
        if (this.isTransparent || this.delayTime100ths >= 0) {
            this.putByte(33);
            this.putByte(249);
            this.putByte(4);
            this.putByte((this.isTransparent ? 9 : 0) | (this.delayTime100ths > 0 ? 2 : 0));
            this.putWord(this.delayTime100ths > 0 ? this.delayTime100ths : 0);
            this.putByte(0);
            this.putByte(0);
        }
    }

    private void writeNetscapeLoopExtension() {
        this.putByte(33);
        this.putByte(255);
        this.putByte(11);
        this.putString("NETSCAPE2.0");
        this.putByte(3);
        this.putByte(1);
        this.putWord(0);
        this.putByte(0);
    }

    private void writeImage() {
        this.putByte(44);
        this.putWord(0);
        this.putWord(0);
        this.putWord(this.width);
        this.putWord(this.height);
        int packedFields = 0x80 | (this.interlaced ? 64 : 0) | this.bitsPerPixel - 1;
        this.putByte(packedFields);
        int colorMapSize = 1 << this.bitsPerPixel;
        P3 p = new P3();
        int i = 0;
        while (i < colorMapSize) {
            if (this.palette[i] != null) {
                p = this.palette[i];
            }
            this.putByte((int)p.x);
            this.putByte((int)p.y);
            this.putByte((int)p.z);
            ++i;
        }
        this.initCodeSize = this.bitsPerPixel <= 1 ? 2 : this.bitsPerPixel;
        this.putByte(this.initCodeSize);
        this.compress();
        this.putByte(0);
    }

    private void writeTrailer() {
        this.putByte(59);
    }

    private int nextPixel() {
        if (this.countDown-- == 0) {
            return -1;
        }
        int colorIndex = this.pixels[this.curpt];
        ++this.curx;
        if (this.curx == this.width) {
            this.curx = 0;
            if (this.interlaced) {
                this.updateY(INTERLACE_PARAMS[this.pass], INTERLACE_PARAMS[this.pass + 4]);
            } else {
                ++this.cury;
            }
        }
        this.curpt = this.cury * this.width + this.curx;
        return colorIndex & 0xFF;
    }

    private void updateY(int yNext, int yNew) {
        this.cury += yNext;
        if (yNew >= 0 && this.cury >= this.height) {
            this.cury = yNew;
            ++this.pass;
        }
    }

    private void putWord(int w) {
        this.putByte(w);
        this.putByte(w >> 8);
    }

    private static final int MAXCODE(int nBits) {
        return (1 << nBits) - 1;
    }

    private void compress() {
        int c;
        this.countDown = this.width * this.height;
        this.pass = 0;
        this.curx = 0;
        this.cury = 0;
        this.clearFlag = false;
        this.nBits = this.initCodeSize + 1;
        this.maxcode = GifEncoder.MAXCODE(this.nBits);
        this.clearCode = 1 << this.initCodeSize;
        this.EOFCode = this.clearCode + 1;
        this.freeEnt = this.clearCode + 2;
        this.bufPt = 0;
        int ent = this.nextPixel();
        int hshift = 0;
        int fcode = this.hsize;
        while (fcode < 65536) {
            ++hshift;
            fcode *= 2;
        }
        hshift = 8 - hshift;
        int hsizeReg = this.hsize;
        this.clearHash(hsizeReg);
        this.output(this.clearCode);
        block1: while ((c = this.nextPixel()) != -1) {
            int i = c << hshift ^ ent;
            fcode = (c << this.maxbits) + ent;
            if (this.htab[i] == fcode) {
                ent = this.codetab[i];
                continue;
            }
            if (this.htab[i] >= 0) {
                int disp = hsizeReg - i;
                if (i == 0) {
                    disp = 1;
                }
                do {
                    if ((i -= disp) < 0) {
                        i += hsizeReg;
                    }
                    if (this.htab[i] != fcode) continue;
                    ent = this.codetab[i];
                    continue block1;
                } while (this.htab[i] >= 0);
            }
            this.output(ent);
            ent = c;
            if (this.freeEnt < this.maxmaxcode) {
                ++this.freeEnt;
                this.htab[i] = fcode;
                continue;
            }
            this.clearBlock();
        }
        this.output(ent);
        this.output(this.EOFCode);
    }

    private void output(int code) {
        this.curAccum &= this.masks[this.curBits];
        this.curAccum = this.curBits > 0 ? (this.curAccum |= code << this.curBits) : code;
        this.curBits += this.nBits;
        while (this.curBits >= 8) {
            this.byteOut((byte)(this.curAccum & 0xFF));
            this.curAccum >>= 8;
            this.curBits -= 8;
        }
        if (this.freeEnt > this.maxcode || this.clearFlag) {
            if (this.clearFlag) {
                this.nBits = this.initCodeSize + 1;
                this.maxcode = GifEncoder.MAXCODE(this.nBits);
                this.clearFlag = false;
            } else {
                ++this.nBits;
                this.maxcode = this.nBits == this.maxbits ? this.maxmaxcode : GifEncoder.MAXCODE(this.nBits);
            }
        }
        if (code == this.EOFCode) {
            while (this.curBits > 0) {
                this.byteOut((byte)(this.curAccum & 0xFF));
                this.curAccum >>= 8;
                this.curBits -= 8;
            }
            this.flushBytes();
        }
    }

    private void clearBlock() {
        this.clearHash(this.hsize);
        this.freeEnt = this.clearCode + 2;
        this.clearFlag = true;
        this.output(this.clearCode);
    }

    private void clearHash(int hsize) {
        int i = 0;
        while (i < hsize) {
            this.htab[i] = -1;
            ++i;
        }
    }

    private void byteOut(byte c) {
        this.buf[this.bufPt++] = c;
        if (this.bufPt >= 254) {
            this.flushBytes();
        }
    }

    protected void flushBytes() {
        if (this.bufPt > 0) {
            this.putByte(this.bufPt);
            this.out.write(this.buf, 0, this.bufPt);
            this.byteCount += this.bufPt;
            this.bufPt = 0;
        }
    }

    private class ColorCell
    extends Lst<P3> {
        protected int index;
        protected P3 center;
        private float volume;

        ColorCell(int index) {
            this.index = index;
        }

        public float getVolume(boolean doVisualize) {
            int n;
            if (this.volume != 0.0f) {
                return this.volume;
            }
            if (this.size() < 2) {
                return -1.0f;
            }
            float maxx = -2.1474836E9f;
            float minx = 2.1474836E9f;
            float maxy = -2.1474836E9f;
            float miny = 2.1474836E9f;
            float maxz = -2.1474836E9f;
            float minz = 2.1474836E9f;
            int i = n = this.size();
            while (--i >= 0) {
                P3 xyz = (P3)this.get(i);
                if (xyz.x < minx) {
                    minx = xyz.x;
                }
                if (xyz.y < miny) {
                    miny = xyz.y;
                }
                if (xyz.z < minz) {
                    minz = xyz.z;
                }
                if (xyz.x > maxx) {
                    maxx = xyz.x;
                }
                if (xyz.y > maxy) {
                    maxy = xyz.y;
                }
                if (!(xyz.z > maxz)) continue;
                maxz = xyz.z;
            }
            float dx = maxx - minx;
            float dy = maxy - miny;
            float dz = maxz - minz;
            this.volume = dx * dx + dy * dy + dz * dz;
            return this.volume;
        }

        protected P3 setColor() {
            int count = this.size();
            this.center = new P3();
            int i = count;
            while (--i >= 0) {
                this.center.add((T3)this.get(i));
            }
            this.center.scale(1.0f / (float)count);
            return GifEncoder.this.toRGB(this.center);
        }

        protected boolean splitCell(Lst<ColorCell> cells) {
            int i;
            int n = this.size();
            if (n < 2) {
                return false;
            }
            int newIndex = cells.size();
            ColorCell newCell = new ColorCell(newIndex);
            cells.addLast(newCell);
            float[][] ranges = new float[3][3];
            int ic = 0;
            while (ic < 3) {
                float low = Float.MAX_VALUE;
                float high = -3.4028235E38f;
                i = n;
                while (--i >= 0) {
                    float v;
                    P3 lab = (P3)this.get(i);
                    float f = ic == 0 ? lab.x : (v = ic == 1 ? lab.y : lab.z);
                    if (low > v) {
                        low = v;
                    }
                    if (!(high < v)) continue;
                    high = v;
                }
                ranges[0][ic] = low;
                ranges[1][ic] = high;
                ranges[2][ic] = high - low;
                ++ic;
            }
            float[] r = ranges[2];
            int mode = r[0] >= r[1] ? (r[0] >= r[2] ? 0 : 2) : (r[1] >= r[2] ? 1 : 2);
            float val = ranges[0][mode] + ranges[2][mode] / 2.0f;
            this.volume = 0.0f;
            switch (mode) {
                case 0: {
                    i = n;
                    while (--i >= 0) {
                        if (!(((P3)this.get((int)i)).x >= val)) continue;
                        newCell.addLast((P3)this.remove(i));
                    }
                    break;
                }
                case 1: {
                    i = n;
                    while (--i >= 0) {
                        if (!(((P3)this.get((int)i)).y >= val)) continue;
                        newCell.addLast((P3)this.remove(i));
                    }
                    break;
                }
                case 2: {
                    i = this.size();
                    while (--i >= 0) {
                        if (!(((P3)this.get((int)i)).z >= val)) continue;
                        newCell.addLast((P3)this.remove(i));
                    }
                    break;
                }
            }
            return true;
        }
    }

    private class ColorItem
    extends P3 {
        protected boolean isBackground;

        ColorItem(int rgb, boolean isBackground) {
            this.isBackground = isBackground;
            this.setT(GifEncoder.this.toLABnorm(rgb));
        }
    }
}

