/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.Serializable;
import javajs.api.JSONEncodable;

public abstract class T3
implements JSONEncodable,
Serializable {
    public float x;
    public float y;
    public float z;

    public final void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void setA(float[] t) {
        this.x = t[0];
        this.y = t[1];
        this.z = t[2];
    }

    public final void setT(T3 t1) {
        this.x = t1.x;
        this.y = t1.y;
        this.z = t1.z;
    }

    public final void add2(T3 t1, T3 t2) {
        this.x = t1.x + t2.x;
        this.y = t1.y + t2.y;
        this.z = t1.z + t2.z;
    }

    public final void add(T3 t1) {
        this.x += t1.x;
        this.y += t1.y;
        this.z += t1.z;
    }

    public final float distanceSquared(T3 p1) {
        double dx = this.x - p1.x;
        double dy = this.y - p1.y;
        double dz = this.z - p1.z;
        return (float)(dx * dx + dy * dy + dz * dz);
    }

    public final float distance(T3 p1) {
        return (float)Math.sqrt(this.distanceSquared(p1));
    }

    public final void sub2(T3 t1, T3 t2) {
        this.x = t1.x - t2.x;
        this.y = t1.y - t2.y;
        this.z = t1.z - t2.z;
    }

    public final void sub(T3 t1) {
        this.x -= t1.x;
        this.y -= t1.y;
        this.z -= t1.z;
    }

    public final void scale(float s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
    }

    public final void add3(float a, float b, float c) {
        this.x += a;
        this.y += b;
        this.z += c;
    }

    public final void scaleT(T3 p) {
        this.x *= p.x;
        this.y *= p.y;
        this.z *= p.z;
    }

    public final void scaleAdd2(float s, T3 t1, T3 t2) {
        this.x = s * t1.x + t2.x;
        this.y = s * t1.y + t2.y;
        this.z = s * t1.z + t2.z;
    }

    public void ave(T3 a, T3 b) {
        this.x = (a.x + b.x) / 2.0f;
        this.y = (a.y + b.y) / 2.0f;
        this.z = (a.z + b.z) / 2.0f;
    }

    public final float dot(T3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public final void normalize() {
        double d = this.length();
        this.x = (float)((double)this.x / d);
        this.y = (float)((double)this.y / d);
        this.z = (float)((double)this.z / d);
    }

    public final void cross(T3 v1, T3 v2) {
        this.set(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
    }

    public int hashCode() {
        long bits = 1L;
        bits = 31L * bits + (long)T3.floatToIntBits0(this.x);
        bits = 31L * bits + (long)T3.floatToIntBits0(this.y);
        bits = 31L * bits + (long)T3.floatToIntBits0(this.z);
        return (int)(bits ^ bits >> 32);
    }

    public static int floatToIntBits0(float f) {
        return f == 0.0f ? 0 : Float.floatToIntBits(f);
    }

    public boolean equals(Object t1) {
        if (!(t1 instanceof T3)) {
            return false;
        }
        T3 t2 = (T3)t1;
        return this.x == t2.x && this.y == t2.y && this.z == t2.z;
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.z + "}";
    }

    @Override
    public String toJSON() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }
}

