/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.api.GenericZipTools;
import javajs.util.BC;
import javajs.util.OC;
import javajs.util.SB;

public class BinaryDocument
extends BC
implements GenericBinaryDocument {
    protected DataInputStream stream;
    protected boolean isRandom = false;
    public boolean isBigEndian = true;
    protected GenericZipTools jzt;
    byte[] t8 = new byte[8];
    long nBytes;
    OC out;

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.out != null) {
            this.out.closeChannel();
        }
    }

    @Override
    public void setStream(GenericZipTools jzt, BufferedInputStream bis, boolean isBigEndian) {
        if (jzt != null) {
            this.jzt = jzt;
        }
        if (bis != null) {
            this.stream = new DataInputStream(bis);
        }
        this.isBigEndian = isBigEndian;
    }

    @Override
    public void setStreamData(DataInputStream stream, boolean isBigEndian) {
        if (stream != null) {
            this.stream = stream;
        }
        this.isBigEndian = isBigEndian;
    }

    public void setRandom(boolean TF) {
        this.isRandom = TF;
    }

    @Override
    public byte readByte() throws Exception {
        ++this.nBytes;
        return this.ioReadByte();
    }

    private byte ioReadByte() throws Exception {
        byte b = this.stream.readByte();
        if (this.out != null) {
            this.out.writeByteAsInt(b);
        }
        return b;
    }

    @Override
    public int readByteArray(byte[] b, int off, int len) throws Exception {
        int n = this.ioRead(b, off, len);
        this.nBytes += (long)n;
        return n;
    }

    private int ioRead(byte[] b, int off, int len) throws Exception {
        int m = 0;
        while (len > 0) {
            int n = this.stream.read(b, off, len);
            m += n;
            if (n > 0 && this.out != null) {
                this.writeBytes(b, off, n);
            }
            if (n >= len) break;
            off += n;
            len -= n;
        }
        return m;
    }

    public void writeBytes(byte[] b, int off, int n) throws Exception {
        this.out.write(b, off, n);
    }

    @Override
    public String readString(int nChar) throws Exception {
        byte[] temp = new byte[nChar];
        int n = this.readByteArray(temp, 0, nChar);
        return new String(temp, 0, n, "UTF-8");
    }

    @Override
    public short readShort() throws Exception {
        this.nBytes += 2L;
        short n = this.isBigEndian ? this.ioReadShort() : (short)(this.ioReadByte() & 0xFF | (this.ioReadByte() & 0xFF) << 8);
        return n;
    }

    private short ioReadShort() throws Exception {
        short b = this.stream.readShort();
        if (this.out != null) {
            this.writeShort(b);
        }
        return b;
    }

    public void writeShort(short i) throws Exception {
        this.out.writeByteAsInt(i >> 8);
        this.out.writeByteAsInt(i);
    }

    @Override
    public int readIntLE() throws Exception {
        this.nBytes += 4L;
        return this.readLEInt();
    }

    @Override
    public int readInt() throws Exception {
        this.nBytes += 4L;
        return this.isBigEndian ? this.ioReadInt() : this.readLEInt();
    }

    private int ioReadInt() throws Exception {
        int i = this.stream.readInt();
        if (this.out != null) {
            this.writeInt(i);
        }
        return i;
    }

    public void writeInt(int i) throws Exception {
        this.out.writeByteAsInt(i >> 24);
        this.out.writeByteAsInt(i >> 16);
        this.out.writeByteAsInt(i >> 8);
        this.out.writeByteAsInt(i);
    }

    @Override
    public int swapBytesI(int n) {
        return n >> 24 & 0xFF | (n >> 16 & 0xFF) << 8 | (n >> 8 & 0xFF) << 16 | (n & 0xFF) << 24;
    }

    @Override
    public short swapBytesS(short n) {
        return (short)(n >> 8 & 0xFF | (n & 0xFF) << 8);
    }

    @Override
    public int readUnsignedShort() throws Exception {
        this.nBytes += 2L;
        int a = this.ioReadByte() & 0xFF;
        int b = this.ioReadByte() & 0xFF;
        return this.isBigEndian ? (a << 8) + b : (b << 8) + a;
    }

    @Override
    public long readLong() throws Exception {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadLong() : (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 54;
    }

    private long ioReadLong() throws Exception {
        long b = this.stream.readLong();
        if (this.out != null) {
            this.writeLong(b);
        }
        return b;
    }

    public void writeLong(long b) throws Exception {
        this.writeInt((int)(b >> 32 & 0xFFFFFFFFL));
        this.writeInt((int)(b & 0xFFFFFFFFL));
    }

    private int readLEInt() throws Exception {
        this.ioRead(this.t8, 0, 4);
        return BinaryDocument.bytesToInt(this.t8, 0, false);
    }

    @Override
    public float readFloat() throws Exception {
        return BinaryDocument.intToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws Exception {
        this.nBytes += 8L;
        return this.isBigEndian ? this.ioReadDouble() : Double.longBitsToDouble(this.readLELong());
    }

    private double ioReadDouble() throws Exception {
        double d = this.stream.readDouble();
        if (this.out != null) {
            this.writeLong(Double.doubleToRawLongBits(d));
        }
        return d;
    }

    private long readLELong() throws Exception {
        return (long)this.ioReadByte() & 0xFFL | ((long)this.ioReadByte() & 0xFFL) << 8 | ((long)this.ioReadByte() & 0xFFL) << 16 | ((long)this.ioReadByte() & 0xFFL) << 24 | ((long)this.ioReadByte() & 0xFFL) << 32 | ((long)this.ioReadByte() & 0xFFL) << 40 | ((long)this.ioReadByte() & 0xFFL) << 48 | ((long)this.ioReadByte() & 0xFFL) << 56;
    }

    @Override
    public void seek(long offset) {
        try {
            if (offset == this.nBytes) {
                return;
            }
            if (offset < this.nBytes) {
                this.stream.reset();
                if (this.out != null && this.nBytes != 0L) {
                    this.out.reset();
                }
                this.nBytes = 0L;
            } else {
                offset -= this.nBytes;
            }
            if (this.out == null) {
                this.stream.skipBytes((int)offset);
            } else {
                this.readByteArray(new byte[(int)offset], 0, (int)offset);
            }
            this.nBytes += offset;
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    @Override
    public long getPosition() {
        return this.nBytes;
    }

    @Override
    public void setOutputChannel(OC out) {
        this.out = out;
    }

    @Override
    public SB getAllDataFiles(String binaryFileList, String firstFile) {
        return null;
    }

    @Override
    public void getAllDataMapped(String replace, String string, Map<String, String> fileData) {
    }
}

