/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialogRun;

abstract class NBODialogView
extends NBODialogRun {
    protected JComboBox<String> basis;
    protected String keyword = "PNBO";
    protected int keywordNumber = 6;
    protected static final String[] basSet = new String[]{"AO", "PNAO", "NAO", "PNHO", "NHO", "PNBO", "NBO", "PNLMO", "NLMO", "MO"};
    protected JLabel sLab;
    protected JLabel vLab;
    protected JLabel pLab;
    protected JButton btnSign;
    protected JButton btnVec;
    protected JButton btnPla;
    protected JButton btnCam;
    protected JButton btnStip;
    protected JButton goBtn;
    protected JButton goBtn2;
    protected JRadioButton btnProf;
    protected JRadioButton btnCont;
    protected JRadioButton btnShow;
    protected JRadioButton btnView3D;
    protected boolean oneD = true;
    protected boolean inLobes = true;
    protected JComboBox<String> list;
    protected JCheckBox selToggle;
    protected Hashtable<String, String[]> lists;
    protected int viewState;
    protected final JTextField[] vectorFields = new JTextField[8];
    protected final String[] vectorFieldIDs;
    protected final JTextField[] planeFields;
    protected final String[] planeFieldIDs;
    protected final JTextField[] camFields;
    String[] camFieldIDs;
    protected final JTextField[] contourFields;
    protected final String[] contourFieldIDs;
    protected DefaultListModel<String> model;
    protected JList<String> dList;
    protected int numStor;
    protected static final int VIEW_STATE_MAIN = 0;
    protected static final int VIEW_STATE_PLANE = 1;
    protected static final int VIEW_STATE_VECTOR = 2;
    protected static final int VIEW_STATE_CAMERA = 3;
    protected int iLast;
    protected int iLastD;
    private int viewVectorPt;
    private int viewPlanePt;

    private String getVectorParams() {
        String string = "";
        for (int i = 0; i < this.vectorFields.length; ++i) {
            string = string + "GLOBAL VECTOR_" + this.planeFieldIDs[i] + " " + this.vectorFields[i].getText() + sep;
        }
        return string;
    }

    private String getPlaneParams() {
        String string = "";
        for (int i = 0; i < this.planeFields.length; ++i) {
            string = string + "GLOBAL PLANE_" + this.planeFieldIDs[i] + " " + this.planeFields[i].getText() + sep;
        }
        return string;
    }

    private String getCameraParams() {
        String string = "";
        for (int i = 0; i < this.camFields.length; ++i) {
            string = string + "GLOBAL CAMERA_" + this.camFieldIDs[i] + " " + this.camFields[i].getText() + sep;
        }
        string = string + "GLOBAL CAMERA_6 " + (this.inLobes ? 0 : 1) + sep;
        return string;
    }

    protected NBODialogView(JFrame jFrame) {
        super(jFrame);
        int n;
        String[] stringArray = new String[]{"1", "2", "0.5", "-2.0", "2.0", "-1.0", "1.0", "100"};
        for (n = 0; n < this.vectorFields.length; ++n) {
            this.vectorFields[n] = new JTextField(stringArray[n]);
        }
        this.vectorFieldIDs = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        this.planeFields = new JTextField[12];
        stringArray = new String[]{"1", "2", "3", "0.5", "0.0", "0.0", "0.0", "-3.0", "3.0", "-3.0", "3.0", "25"};
        for (n = 0; n < this.planeFields.length; ++n) {
            this.planeFields[n] = new JTextField(stringArray[n]);
        }
        this.planeFieldIDs = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"};
        this.camFields = new JTextField[52];
        stringArray = new String[]{"6.43", "0.0", "0.0", "50.0", "2.0", "2.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.0", "0.60", "1.0", "1.0", "40.0", "0.5", "1.0", "1.0", "1.0", "0.8", "0.0", "0.0", "1.0", "0.8", "0.4", "0.0", "1.0", "1.0", "0.5", "0.5", "0.5", "0.0", "0.7", "1.0", "0.22", "0.40", "0.10", "0.05", "0.0316", "0.0001", "0.4000"};
        for (n = 0; n < this.camFields.length; ++n) {
            this.camFields[n] = new JTextField(stringArray[n]);
        }
        this.camFieldIDs = new String[]{"1a", "1b", "1c", "1d", "1e", "1f", "1g", "2a", "2b", "2c", "2d", "2e", "2f", "2g", "2h", "2i", "2j", "2k", "2l", "2m", "2n", "2o", "2p", "2q", "2r", "2s", "2t", "3a", "3b", "3c", "3d", "3e", "3f", "3g", "3h", "3i", "3j", "3k", "3l", "3m", "3n", "3o", "3p", "3q", "3r", "4a", "4b", "4c", "4d", "5a", "5b", "5c"};
        this.contourFields = new JTextField[7];
        stringArray = new String[]{"0.03", "0.05", "4", "0.05", "0.05", "0.10", "0.10"};
        for (n = 0; n < this.contourFields.length; ++n) {
            this.contourFields[n] = new JTextField(stringArray[n]);
        }
        this.contourFieldIDs = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        this.numStor = 0;
        this.iLast = -1;
        this.iLastD = -1;
        this.viewVectorPt = 0;
        this.viewPlanePt = 0;
    }

    protected void buildView(Container container) {
        this.viewState = 0;
        Properties properties = JmolPanel.historyFile.getProperties();
        this.workingPath = properties.getProperty("workingPath", System.getProperty("user.home"));
        container.removeAll();
        container.setLayout(new BorderLayout());
        if (this.topPanel == null) {
            this.topPanel = this.buildTopPanel();
        }
        container.add((Component)this.topPanel, "First");
        JPanel jPanel = new JPanel(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, this.select(), this.display());
        jSplitPane.setDividerLocation(430);
        jPanel.add((Component)jSplitPane, "Center");
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("JobFile")).setFont(new Font("Arial", 1, 25));
        box.add(this.folderBox());
        this.browse.setEnabled(true);
        jPanel.add((Component)box, "North");
        container.add((Component)jPanel, "Center");
        container.add((Component)this.statusPanel, "Last");
        if (this.isJmolNBO) {
            this.setInputFile(this.inputFile, "nbo", null);
        }
    }

    protected JPanel select() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Basis ")).setFont(new Font("Arial", 1, 25));
        box.setBorder(BorderFactory.createEmptyBorder(20, 0, 10, 5));
        this.basis = new JComboBox<String>(basSet);
        this.basis.setMaximumSize(new Dimension(100, 25));
        box.add(this.basis).setEnabled(this.isJmolNBO);
        box.add(Box.createRigidArea(new Dimension(300, 0)));
        this.basis.setSelectedIndex(5);
        this.basis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.basisSel();
            }
        });
        jPanel.add(box);
        box = Box.createHorizontalBox();
        box.add(new JLabel("Orbital ")).setFont(new Font("Arial", 1, 25));
        jPanel.add(new JSeparator());
        box.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 5));
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.list = new JComboBox(defaultComboBoxModel);
        this.list.setFont(this.nboFont);
        this.list.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = NBODialogView.this.list.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                NBODialogView.this.showOrbJmol(NBODialogView.this.basis.getSelectedItem().toString(), NBODialogView.this.list.getSelectedIndex() + 1);
            }
        });
        box.add(this.list).setMaximumSize(new Dimension(225, 25));
        box.add(Box.createRigidArea(new Dimension(110, 0)));
        jPanel.add(box);
        jPanel.add(new JSeparator());
        int n = this.iLast;
        this.iLast = -1;
        if (n > 0 && n < this.list.getComponentCount()) {
            n = 0;
        }
        final int n2 = n;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NBODialogView.this.list.setSelectedIndex(n2);
            }
        });
        box = Box.createHorizontalBox();
        box.add(new JLabel("Store ")).setFont(new Font("Arial", 1, 25));
        Box box2 = Box.createVerticalBox();
        this.btnProf = new JRadioButton("1D Profile");
        this.btnProf.setFont(this.nboFont);
        box2.add(this.btnProf).setEnabled(this.isJmolNBO);
        this.btnCont = new JRadioButton("2D Contour");
        this.btnCont.setFont(this.nboFont);
        this.btnProf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.oneD = true;
                NBODialogView.this.btnProf.setSelected(true);
                NBODialogView.this.btnCont.setSelected(false);
                NBODialogView.this.btnPla.setEnabled(false);
                NBODialogView.this.btnVec.setEnabled(true);
                NBODialogView.this.viewState = 2;
                NBODialogView.this.showSelected(NBODialogView.this.vLab.getText().split(", "));
            }
        });
        box2.add(this.btnCont).setEnabled(this.isJmolNBO);
        box.add(box2);
        this.btnCont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.oneD = false;
                NBODialogView.this.btnCont.setSelected(true);
                NBODialogView.this.btnProf.setSelected(false);
                NBODialogView.this.btnPla.setEnabled(true);
                NBODialogView.this.btnVec.setEnabled(false);
                NBODialogView.this.viewState = 1;
                NBODialogView.this.showSelected(NBODialogView.this.pLab.getText().split(", "));
            }
        });
        this.goBtn = new JButton("GO");
        this.goBtn.setEnabled(this.isJmolNBO);
        this.goBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.goViewClicked();
            }
        });
        box.add(Box.createRigidArea(new Dimension(165, 0)));
        box.add(this.goBtn).setFont(new Font("Arial", 1, 18));
        jPanel.add(box);
        this.selToggle = new JCheckBox("Show Atoms Defining Axis/Plane");
        this.selToggle.setAlignmentX(0.0f);
        this.selToggle.setSelected(true);
        this.selToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NBODialogView.this.selToggle.isSelected()) {
                    NBODialogView.this.nboService.runScriptQueued("select off");
                } else if (NBODialogView.this.btnProf.isSelected()) {
                    NBODialogView.this.showSelected(NBODialogView.this.vLab.getText().split(", "));
                } else {
                    NBODialogView.this.showSelected(NBODialogView.this.pLab.getText().split(", "));
                }
            }
        });
        jPanel.add(this.selToggle);
        jPanel.add(new JSeparator());
        box = Box.createHorizontalBox();
        box.add(new JLabel("Display ")).setFont(new Font("Arial", 1, 25));
        box2 = Box.createVerticalBox();
        this.btnShow = new JRadioButton("1D/2D");
        this.btnShow.setFont(this.nboFont);
        this.btnShow.setEnabled(this.numStor > 0);
        this.btnShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.btnView3D.setSelected(false);
                NBODialogView.this.btnShow.setSelected(true);
            }
        });
        box2.add(Box.createRigidArea(new Dimension(30, 0)));
        box2.add(this.btnShow);
        this.btnView3D = new JRadioButton("3D");
        this.btnView3D.setFont(this.nboFont);
        this.btnView3D.setEnabled(this.numStor > 0);
        this.btnView3D.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.btnView3D.setSelected(true);
                NBODialogView.this.btnShow.setSelected(false);
            }
        });
        box2.add(this.btnView3D);
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(176, 0)));
        this.goBtn2 = new JButton("GO");
        this.goBtn2.setEnabled(this.isJmolNBO);
        this.goBtn2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NBODialogView.this.btnView3D.isSelected()) {
                    NBODialogView.this.view3D();
                } else {
                    NBODialogView.this.showView1D2D();
                }
            }
        });
        box.add(this.goBtn2).setFont(new Font("Arial", 1, 18));
        jPanel.add(box);
        box2 = Box.createHorizontalBox();
        this.jCheckAtomNum = new JCheckBox("Show Atom #'s");
        box2.add(this.jCheckAtomNum);
        this.jCheckAtomNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NBODialogView.this.jCheckAtomNum.isSelected()) {
                    NBODialogView.this.nboService.runScriptQueued("select {*};label off");
                } else {
                    NBODialogView.this.nboService.runScriptQueued("select {*};label %a");
                }
                NBODialogView.this.nboService.runScriptQueued("color labels white;select remove {*}");
                if (NBODialogView.this.selToggle.isSelected()) {
                    if (NBODialogView.this.btnProf.isSelected()) {
                        NBODialogView.this.showSelected(NBODialogView.this.vLab.getText().split(", "));
                    } else {
                        NBODialogView.this.showSelected(NBODialogView.this.pLab.getText().split(", "));
                    }
                }
            }
        });
        JCheckBox jCheckBox = new JCheckBox("Use Jmol orientation");
        box2.add(jCheckBox);
        jPanel.add((Component)box2, "Last");
        jPanel.add(Box.createRigidArea(new Dimension(0, 200)));
        if (this.isJmolNBO) {
            this.basisSel();
        }
        return jPanel;
    }

    private String getContourParams() {
        String string = "";
        for (int i = 0; i < this.contourFields.length; ++i) {
            string = string + "GLOBAL CONTOUR_" + this.contourFieldIDs[i] + " " + this.contourFields[i].getText() + sep;
        }
        return string;
    }

    protected void showSelected(String[] stringArray) {
        if (!this.selToggle.isSelected()) {
            return;
        }
        this.nboService.runScriptQueued("select remove {*}");
        for (String string : stringArray) {
            this.nboService.runScriptQueued("select add {*}[" + string + "]");
        }
        this.nboService.runScriptQueued("select on;refresh");
    }

    private JPanel display() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel jLabel = new JLabel("Storage:");
        jLabel.setFont(this.nboFont);
        jPanel.add((Component)jLabel, "First");
        JScrollPane jScrollPane = new JScrollPane();
        if (this.dList == null) {
            this.model = new DefaultListModel();
            for (int i = 1; i < 10; ++i) {
                this.model.addElement("" + i + ")");
            }
            this.dList = new JList<String>(this.model);
            this.dList.setFont(this.nboFont);
            this.dList.setSelectionMode(2);
            this.dList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = NBODialogView.this.dList.getSelectedIndex();
                    System.out.println("-----------------------" + NBODialogView.this.iLastD + " " + n);
                    if (n == -1) {
                        return;
                    }
                    NBODialogView.this.showOrbJmol(NBODialogView.this.dList);
                }
            });
        }
        jScrollPane.getViewport().add(this.dList);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1));
        this.btnSign = new JButton("Sign");
        jPanel2.add(this.btnSign).setFont(this.nboFont);
        this.btnSign.setEnabled(this.isJmolNBO);
        this.btnSign.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NBODialogView.this.sLab.getText().trim().equals("+")) {
                    NBODialogView.this.sLab.setText(" -");
                } else {
                    NBODialogView.this.sLab.setText(" +");
                }
            }
        });
        this.btnVec = new JButton("1D Axis");
        jPanel2.add(this.btnVec).setFont(this.nboFont);
        this.btnVec.setEnabled(this.isJmolNBO);
        this.btnVec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.vector();
            }
        });
        this.btnPla = new JButton("2D Plane");
        jPanel2.add(this.btnPla).setFont(this.nboFont);
        this.btnPla.setEnabled(this.isJmolNBO);
        this.btnPla.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.plane();
            }
        });
        this.btnCam = new JButton("Camera");
        this.btnCam.setFont(this.nboFont);
        jPanel2.add(this.btnCam);
        this.btnCam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.cam1();
            }
        });
        this.btnCam.setEnabled(this.isJmolNBO);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel2 = new JPanel(new GridLayout(4, 1));
        this.sLab = new JLabel(" +");
        jPanel2.add(this.sLab).setFont(new Font("Monospaced", 1, 20));
        this.vLab = new JLabel("1, 2");
        jPanel2.add(this.vLab).setFont(this.nboFont);
        this.pLab = new JLabel("1, 2, 3");
        jPanel2.add(this.pLab).setFont(this.nboFont);
        this.btnStip = new JButton("Lines");
        this.btnStip.setFont(this.nboFont);
        jPanel2.add(this.btnStip);
        this.btnStip.setEnabled(this.isJmolNBO);
        this.btnStip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.stip();
            }
        });
        jPanel3.add((Component)jPanel2, "After");
        jPanel3.setBorder(BorderFactory.createTitledBorder("Settings:"));
        jPanel.add((Component)jPanel3, "Last");
        this.btnProf.doClick();
        return jPanel;
    }

    protected void plane() {
        this.viewPlanePt = 0;
        final JDialog jDialog = new JDialog(this, "Definition of Plane:", false);
        jDialog.setLayout(new BorderLayout());
        jDialog.setMinimumSize(new Dimension(300, 300));
        this.centerDialog(jDialog);
        JPanel jPanel = new JPanel(new GridLayout(7, 1, 5, 0));
        jPanel.add(new JLabel("Enter or select three atoms:"));
        jPanel.add(new JLabel("Enter fraction to locate origin:"));
        jPanel.add(new JLabel("Enter two rotation angles:"));
        jPanel.add(new JLabel("Enter shift of plane along normal:"));
        jPanel.add(new JLabel("Enter min and max X values:"));
        jPanel.add(new JLabel("Enter min and max Y values:"));
        jPanel.add(new JLabel("Enter number of steps NX:"));
        jDialog.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new GridLayout(7, 1, 5, 0));
        Box box = Box.createHorizontalBox();
        box.add(this.planeFields[0]);
        box.add(this.planeFields[1]);
        box.add(this.planeFields[2]);
        jPanel2.add(box);
        jPanel2.add(this.planeFields[3]);
        box = Box.createHorizontalBox();
        box.add(this.planeFields[4]);
        box.add(this.planeFields[5]);
        jPanel2.add(box);
        jPanel2.add(this.planeFields[6]);
        box = Box.createHorizontalBox();
        box.add(this.planeFields[7]);
        box.add(this.planeFields[8]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.planeFields[9]);
        box.add(this.planeFields[10]);
        jPanel2.add(box);
        jPanel2.add(this.planeFields[11]);
        jDialog.add((Component)jPanel2, "Center");
        JButton jButton = new JButton("OK");
        jDialog.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.pLab.setText(NBODialogView.this.planeFields[0].getText() + ", " + NBODialogView.this.planeFields[1].getText() + ", " + NBODialogView.this.planeFields[2].getText());
                jDialog.dispose();
                NBODialogView.this.viewState = 0;
            }
        });
        jDialog.setVisible(true);
    }

    protected void vector() {
        this.viewVectorPt = 0;
        final JDialog jDialog = new JDialog(this, "Definition of Vector:", false);
        jDialog.setLayout(new BorderLayout());
        jDialog.setMinimumSize(new Dimension(300, 250));
        this.centerDialog(jDialog);
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 5, 0));
        jPanel.add(new JLabel("Enter or select two atom numbers:"));
        jPanel.add(new JLabel("Enter fraction to locate origin:"));
        jPanel.add(new JLabel("Enter min and max X values:"));
        jPanel.add(new JLabel("Enter min and max function values:"));
        jPanel.add(new JLabel("Enter number of steps NX:"));
        jDialog.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new GridLayout(5, 1, 5, 0));
        Box box = Box.createHorizontalBox();
        box.add(this.vectorFields[0]);
        box.add(this.vectorFields[1]);
        jPanel2.add(box);
        jPanel2.add(this.vectorFields[2]);
        box = Box.createHorizontalBox();
        box.add(this.vectorFields[3]);
        box.add(this.vectorFields[4]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.vectorFields[5]);
        box.add(this.vectorFields[6]);
        jPanel2.add(box);
        jPanel2.add(this.vectorFields[7]);
        jDialog.add((Component)jPanel2, "Center");
        JButton jButton = new JButton("OK");
        jDialog.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.vLab.setText(NBODialogView.this.vectorFields[0].getText() + ", " + NBODialogView.this.vectorFields[1].getText());
                jDialog.dispose();
                NBODialogView.this.viewState = 0;
            }
        });
        jDialog.setVisible(true);
    }

    protected void cam1() {
        this.viewState = 3;
        final JDialog jDialog = new JDialog(this, "Camera and Light-Source:", false);
        jDialog.setLayout(new BorderLayout());
        jDialog.setMinimumSize(new Dimension(350, 200));
        jDialog.setVisible(true);
        this.centerDialog(jDialog);
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 5, 0));
        jPanel.add(new JLabel("Camera distance from screen center:"));
        jPanel.add(new JLabel("Two rotation angles (about X, Y):"));
        jPanel.add(new JLabel("Camera view angle:"));
        jPanel.add(new JLabel("Lighting (RL, UD, BF w.r.t. camera):"));
        jDialog.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1, 5, 0));
        Box box = Box.createHorizontalBox();
        jPanel2.add(this.camFields[0]);
        box.add(this.camFields[1]);
        box.add(this.camFields[2]);
        jPanel2.add(this.camFields[3]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.camFields[4]);
        box.add(this.camFields[5]);
        box.add(this.camFields[6]);
        jPanel2.add(box);
        jDialog.add((Component)jPanel2, "Center");
        JButton jButton = new JButton("OK");
        jDialog.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                NBODialogView.this.cam2();
            }
        });
    }

    protected void cam2() {
        final JDialog jDialog = new JDialog(this, "Surface Optical Parameters:", false);
        jDialog.setLayout(new BorderLayout());
        jDialog.setMinimumSize(new Dimension(350, 200));
        jDialog.setVisible(true);
        this.centerDialog(jDialog);
        jDialog.setResizable(false);
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 5, 0));
        jPanel.add(new JLabel("atoms:"));
        jPanel.add(new JLabel("bonds:"));
        jPanel.add(new JLabel("H-bonds:"));
        jPanel.add(new JLabel("orbitals:"));
        jDialog.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1, 5, 0));
        Box box = Box.createHorizontalBox();
        box.add(this.camFields[7]);
        box.add(this.camFields[8]);
        box.add(this.camFields[9]);
        box.add(this.camFields[10]);
        box.add(this.camFields[11]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.camFields[12]);
        box.add(this.camFields[13]);
        box.add(this.camFields[14]);
        box.add(this.camFields[15]);
        box.add(this.camFields[16]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.camFields[17]);
        box.add(this.camFields[18]);
        box.add(this.camFields[19]);
        box.add(this.camFields[20]);
        box.add(this.camFields[21]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.camFields[22]);
        box.add(this.camFields[23]);
        box.add(this.camFields[24]);
        box.add(this.camFields[25]);
        box.add(this.camFields[26]);
        jPanel2.add(box);
        jDialog.add((Component)jPanel2, "Center");
        jDialog.add((Component)new JLabel("                    amb              diff            spec          pow          transp"), "North");
        JButton jButton = new JButton("OK");
        jDialog.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                NBODialogView.this.cam3();
            }
        });
    }

    protected void cam3() {
        final JDialog jDialog = new JDialog(this, "Color (Blue/Green/Red) Parameters:", false);
        jDialog.setLayout(new BorderLayout());
        jDialog.setMinimumSize(new Dimension(350, 200));
        jDialog.setVisible(true);
        this.centerDialog(jDialog);
        jDialog.setResizable(false);
        JPanel jPanel = new JPanel(new GridLayout(6, 1, 5, 0));
        jPanel.add(new JLabel("light source color:"));
        jPanel.add(new JLabel("background color:"));
        jPanel.add(new JLabel("orbital (+ phase) color:"));
        jPanel.add(new JLabel("orbital (- phase) color:"));
        jPanel.add(new JLabel("bond color"));
        jPanel.add(new JLabel("H-Bond color"));
        jDialog.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new GridLayout(6, 1, 5, 0));
        Box box = Box.createHorizontalBox();
        box.add(this.camFields[27]);
        box.add(this.camFields[28]);
        box.add(this.camFields[29]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.camFields[30]);
        box.add(this.camFields[31]);
        box.add(this.camFields[32]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.camFields[33]);
        box.add(this.camFields[34]);
        box.add(this.camFields[35]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.camFields[36]);
        box.add(this.camFields[37]);
        box.add(this.camFields[38]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.camFields[39]);
        box.add(this.camFields[40]);
        box.add(this.camFields[41]);
        jPanel2.add(box);
        box = Box.createHorizontalBox();
        box.add(this.camFields[42]);
        box.add(this.camFields[43]);
        box.add(this.camFields[44]);
        jPanel2.add(box);
        jDialog.add((Component)jPanel2, "Center");
        jDialog.add((Component)new JLabel("                                                 Blue               Green             Red"), "North");
        JButton jButton = new JButton("OK");
        jDialog.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                NBODialogView.this.cam4();
            }
        });
    }

    protected void cam4() {
        final JDialog jDialog = new JDialog(this, "Atomic and Bond Radii:", false);
        jDialog.setLayout(new BorderLayout());
        jDialog.setMinimumSize(new Dimension(250, 200));
        jDialog.setVisible(true);
        this.centerDialog(jDialog);
        JPanel jPanel = new JPanel(new GridLayout(4, 1, 5, 0));
        jPanel.add(new JLabel("Atomic radius for H:"));
        jPanel.add(new JLabel("Atomic radius for C:"));
        jPanel.add(new JLabel("Bond radius:"));
        jPanel.add(new JLabel("H-bond radius:"));
        jDialog.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1, 5, 0));
        jPanel2.add(this.camFields[45]);
        jPanel2.add(this.camFields[46]);
        jPanel2.add(this.camFields[47]);
        jPanel2.add(this.camFields[48]);
        jDialog.add((Component)jPanel2, "Center");
        JButton jButton = new JButton("OK");
        jDialog.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                NBODialogView.this.cam5();
            }
        });
    }

    protected void cam5() {
        final JDialog jDialog = new JDialog(this, "Contour Parameters:", false);
        jDialog.setLayout(new BorderLayout());
        jDialog.setMinimumSize(new Dimension(250, 150));
        jDialog.setVisible(true);
        this.centerDialog(jDialog);
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 5, 0));
        jPanel.add(new JLabel("Contour value:"));
        jPanel.add(new JLabel("Contour tolerance:"));
        jPanel.add(new JLabel("Stepsize:"));
        jDialog.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 5, 0));
        jPanel2.add(this.camFields[49]);
        jPanel2.add(this.camFields[50]);
        jPanel2.add(this.camFields[51]);
        jDialog.add((Component)jPanel2, "Center");
        JButton jButton = new JButton("OK");
        jDialog.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                NBODialogView.this.cam6();
            }
        });
    }

    protected void cam6() {
        final JDialog jDialog = new JDialog(this, "Inner Lobes:", false);
        jDialog.setLayout(new BorderLayout());
        jDialog.setMinimumSize(new Dimension(320, 100));
        jDialog.setVisible(true);
        this.centerDialog(jDialog);
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("  Inner lobes of orbitals included? "));
        JButton jButton = new JButton("YES");
        box.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.inLobes = true;
                jDialog.dispose();
                NBODialogView.this.viewState = 0;
            }
        });
        jButton = new JButton("NO");
        box.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogView.this.inLobes = false;
                jDialog.dispose();
                NBODialogView.this.viewState = 0;
            }
        });
        jDialog.add((Component)box, "Center");
    }

    protected void stip() {
        final JDialog jDialog = new JDialog(this, "Specification of contour lines:", false);
        jDialog.setLayout(new BorderLayout());
        jDialog.setMinimumSize(new Dimension(300, 300));
        jDialog.setVisible(true);
        this.centerDialog(jDialog);
        JPanel jPanel = new JPanel(new GridLayout(8, 1, 0, 0));
        jPanel.add(new JLabel("Enter first contour line:"));
        jPanel.add(new JLabel("Enter contour step size:"));
        jPanel.add(new JLabel("Enter number of contours:"));
        jPanel.add(new JLabel("Enter length of dash (cm):"));
        jPanel.add(new JLabel("Enter length of space (cm):"));
        jPanel.add(new JLabel("  Specification of orbital diagram lines"));
        jPanel.add(new JLabel("Enter length of dash (cm):"));
        jPanel.add(new JLabel("Enter length of space (cm):"));
        jDialog.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel(new GridLayout(8, 1, 0, 0));
        jPanel2.add(this.contourFields[0]);
        jPanel2.add(this.contourFields[1]);
        jPanel2.add(this.contourFields[2]);
        jPanel2.add(this.contourFields[3]);
        jPanel2.add(this.contourFields[4]);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 0)));
        jPanel2.add(this.contourFields[5]);
        jPanel2.add(this.contourFields[6]);
        jDialog.add((Component)jPanel2, "Center");
        JButton jButton = new JButton("OK");
        jDialog.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
    }

    protected void showOrbJmol(JList<String> jList) {
        String string = jList.getSelectedValue();
        if (string.split(" ").length < 2) {
            return;
        }
        int n = string.indexOf("-");
        String string2 = string.split(" ")[1];
        this.nboService.runScriptQueued("MO delete; NBO delete; NBO TYPE " + string2 + "; NBO " + string.substring(n + 1, string.indexOf("]")));
    }

    protected void showOrbJmol(String string, int n) {
        this.nboService.runScriptQueued("MO delete; NBO delete; NBO TYPE " + string + "; NBO " + n);
    }

    protected synchronized void basisSel() {
        this.keywordNumber = this.basis.getSelectedIndex() + 1;
        String string = this.basis.getSelectedItem().toString();
        final SB sB = new SB();
        if (this.lists.get("o " + this.basis.getSelectedItem().toString()) != null) {
            this.setOrbitalList(this.lists.get("o " + string));
            return;
        }
        if (string.equals("MO")) {
            for (int i = 1; i <= this.list.getModel().getSize(); ++i) {
                sB.append((i + ".  MO " + i + "                 ").substring(0, 20));
            }
            this.nboService.queueJob("view", "getting orbital list", new Runnable(){

                @Override
                public void run() {
                    NBODialogView.this.processOrbitalList(sB.toString());
                }
            });
        } else {
            this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sB);
            this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sB);
            this.appendToFile("GLOBAL I_BAS_1 " + this.keywordNumber + sep, sB);
            this.appendToFile("CMD LABEL", sB);
            this.nboService.queueJob("view", "getting orbital list", new Runnable(){

                @Override
                public void run() {
                    NBODialogView.this.nboService.rawCmdNew("v", sB, true, 33);
                    NBODialogView.this.processOrbitalList(NBODialogView.this.reqInfo);
                }
            });
        }
    }

    @Override
    protected void showWorkpathDialogV(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileNameExtensionFilter("NBO", "nbo"));
        jFileChooser.setFileHidingEnabled(true);
        String string2 = string;
        jFileChooser.setSelectedFile(new File(string2));
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n == 0) {
            this.setInputFile(this.newNBOFile(jFileChooser.getSelectedFile(), "47"), "nbo", this.showWorkPathDone);
            if (this.basis == null) {
                this.basis = new JComboBox<String>(basSet);
            }
            this.isJmolNBO = true;
            this.saveHistory();
            this.basisSel();
            this.nboResetV();
            this.buildView(this.getContentPane());
            this.setComponents(this.getContentPane());
        }
    }

    @Override
    protected void nboResetV() {
        this.dList = null;
        for (int i = 1; i <= this.numStor; ++i) {
            String string = new File(this.workingPath).getParent();
            File file = new File(string + "/" + this.jobStem + i + ".bmp");
            File file2 = new File(string + "/" + this.jobStem + i + ".ps");
            System.out.println("----" + file2.toString());
            file.delete();
            file2.delete();
        }
        this.lists = new Hashtable();
        this.numStor = 0;
        this.iLastD = -1;
        this.iLast = -1;
    }

    protected void goViewClicked() {
        final SB sB = new SB();
        final int n = this.list.getSelectedIndex() + 1;
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sB);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sB);
        this.appendToFile("GLOBAL I_BAS_1 " + (this.basis.getSelectedIndex() + 1) + sep, sB);
        if (this.sLab.getText().equals(" +")) {
            this.appendToFile("GLOBAL SIGN +1 " + sep, sB);
        } else {
            this.appendToFile("GLOBAL SIGN -1 " + sep, sB);
        }
        if (this.oneD) {
            this.appendToFile(this.getVectorParams(), sB);
            this.appendToFile("CMD PROFILE " + (this.list.getSelectedIndex() + 1), sB);
        } else {
            this.appendToFile(this.getPlaneParams(), sB);
            this.appendToFile("CMD CONTOUR " + (this.list.getSelectedIndex() + 1), sB);
        }
        final boolean bl = this.oneD;
        String string = this.list.getSelectedItem().toString();
        final String string2 = string.substring(string.indexOf(".") + 1).replaceAll(" ", "");
        final String string3 = this.basis.getSelectedItem().toString().replaceAll(" ", "");
        this.nboService.queueJob("view", "getting " + (bl ? "profile" : "contour"), new Runnable(){

            @Override
            public void run() {
                NBODialogView.this.nboService.rawCmdNew("v", sB, false, 88);
                String string = NBODialogView.this.numStor % 9 + 1 + ")*[" + (bl ? "P-" : "C-") + n + "] " + string3 + " " + string2 + "  {" + NBODialogView.this.sLab.getText().trim() + ": " + (bl ? NBODialogView.this.vLab.getText() : NBODialogView.this.pLab.getText()) + "}";
                if (NBODialogView.this.numStor % 9 == 0) {
                    NBODialogView.this.model.add(8, NBODialogView.this.model.remove(8).replace("*", ""));
                } else {
                    NBODialogView.this.model.add(NBODialogView.this.numStor % 9 - 1, NBODialogView.this.model.remove(NBODialogView.this.numStor % 9 - 1).replace("*", ""));
                }
                NBODialogView.this.model.remove(NBODialogView.this.numStor % 9);
                NBODialogView.this.model.add(NBODialogView.this.numStor % 9, string);
                NBODialogView.this.dList.setSelectedIndex(NBODialogView.this.numStor % 9);
                ++NBODialogView.this.numStor;
                NBODialogView.this.btnView3D.setEnabled(true);
                NBODialogView.this.btnShow.setEnabled(true);
                NBODialogView.this.goBtn2.setEnabled(true);
            }
        });
    }

    protected void showView1D2D() {
        final SB sB = new SB();
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sB);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sB);
        this.appendToFile("CMD SHOW " + (this.dList.getSelectedIndex() + 1) + sep, sB);
        final String string = this.inputFile.getParent() + "\\" + this.jobStem + ".ps";
        this.nboService.queueJob("view", "creating PostScript file...", new Runnable(){

            @Override
            public void run() {
                File file = new File(string);
                if (file.exists()) {
                    file.delete();
                }
                NBODialogView.this.nboService.rawCmdNew("v", sB, false, 88);
                while (!file.exists() && !NBODialogView.this.nboService.jobCanceled) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                NBODialogView.this.vwr.alert("file " + string + " has been created");
            }
        });
    }

    protected void view3D() {
        final SB sB = new SB();
        int n = this.numStor % 9 <= this.dList.getSelectedIndex() ? (this.numStor / 9 - 1) * 9 + this.dList.getSelectedIndex() + 1 : this.numStor / 9 * 9 + this.dList.getSelectedIndex() + 1;
        this.appendToFile("GLOBAL C_PATH " + this.inputFile.getParent() + sep, sB);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sB);
        this.appendToFile(this.getCameraParams(), sB);
        this.appendToFile("GLOBAL C_FNAME " + this.jobStem + n + sep, sB);
        this.appendToFile("CMD VIEW ", sB);
        int[] nArray = this.dList.getSelectedIndices();
        final SB sB2 = new SB();
        for (int n2 : nArray) {
            this.appendToFile(Integer.toString(n2 + 1) + " ", sB);
            sB2.append(PT.split(this.dList.getModel().getElementAt(n2), "]")[1] + " ");
        }
        final String string = this.inputFile.getParent() + "\\" + this.jobStem + n + ".bmp";
        this.nboService.queueJob("view", "Raytracing, please be patient...", new Runnable(){

            @Override
            public void run() {
                String string4 = null;
                File file = new File(string);
                String string2 = "id " + PT.esc(sB2.toString().trim());
                if (file.exists()) {
                    NBODialogView.this.nboService.runScriptQueued("image " + string2 + " close;image " + string2 + " " + PT.esc(file.toString().replace('\\', '/')));
                    return;
                }
                file.delete();
                NBODialogView.this.nboService.rawCmdNew("v", sB, false, 88);
                while (!file.exists() && !NBODialogView.this.nboService.jobCanceled) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    String string3 = "image " + string2 + " close;image " + string2 + " " + PT.esc(file.toString().replace('\\', '/'));
                    NBODialogView.this.nboService.runScriptQueued(string3);
                    NBODialogView.this.statusLab.setText(string4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    protected void processOrbitalList(String string) {
        System.out.println("processing list " + string);
        try {
            String[] stringArray = new String[string.length() / 20];
            int n = 0;
            while ((n + 1) * 20 <= string.length()) {
                stringArray[n] = string.substring(n * 20, (n + 1) * 20);
                ++n;
            }
            this.lists.put("o " + this.basis.getSelectedItem().toString(), stringArray);
            this.setOrbitalList(stringArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void setOrbitalList(String[] stringArray) {
        int n = this.list.getSelectedIndex();
        this.listModel.removeAllElements();
        for (String string : stringArray) {
            this.listModel.addElement(string);
        }
        if (n != -1) {
            this.list.setSelectedIndex(n);
        } else {
            this.list.setSelectedIndex(0);
        }
    }

    protected void notifyCallbackV(String string) {
        switch (this.viewState) {
            case 2: {
                this.vectorFields[this.viewVectorPt++].setText(string);
                this.vLab.setText(this.vectorFields[0].getText() + ", " + this.vectorFields[1].getText());
                this.showSelected(this.vLab.getText().split(", "));
                this.viewVectorPt %= 2;
                break;
            }
            case 1: {
                this.planeFields[this.viewPlanePt++].setText(string);
                this.pLab.setText(this.planeFields[0].getText() + ", " + this.planeFields[1].getText() + ", " + this.planeFields[2].getText());
                this.showSelected(this.pLab.getText().split(", "));
                this.viewPlanePt %= 3;
            }
        }
    }

    protected void rawInputV(String string) {
        if (!this.checkJmolNBO()) {
            return;
        }
        if (string.startsWith("BAS")) {
            try {
                this.basis.setSelectedItem(string.split(" ")[1]);
                this.appendOutputWithCaret("Basis changed:\n  " + string.split(" ")[1]);
            }
            catch (Exception exception) {
                this.appendOutputWithCaret("NBO View can't do that");
            }
        } else if (string.startsWith("CON")) {
            try {
                int n = Integer.parseInt(string.split(" ")[1]);
                this.list.setSelectedIndex(n - 1);
                this.oneD = false;
                this.goViewClicked();
            }
            catch (Exception exception) {
                this.appendOutputWithCaret("NBO View can't do that");
            }
        } else if (string.startsWith("PR")) {
            try {
                int n = Integer.parseInt(string.split(" ")[1]);
                this.list.setSelectedIndex(n - 1);
                this.oneD = true;
                this.goViewClicked();
            }
            catch (Exception exception) {
                this.appendOutputWithCaret("NBO View can't do that");
            }
        } else if (string.startsWith("VIEW")) {
            try {
                int n = Integer.parseInt(string.split(" ")[1]);
                this.dList.setSelectedIndex(n - 1);
                this.view3D();
            }
            catch (Exception exception) {
                this.appendOutputWithCaret("NBO View can't do that");
            }
        }
    }
}

