/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;

public class JoinNodeWayAction
extends JosmAction {
    protected final boolean joinWayToNode;

    protected JoinNodeWayAction(boolean bl, String string, String string2, String string3, Shortcut shortcut, boolean bl2) {
        super(string, string2, string3, shortcut, bl2);
        this.joinWayToNode = bl;
    }

    public static JoinNodeWayAction createJoinNodeToWayAction() {
        JoinNodeWayAction joinNodeWayAction = new JoinNodeWayAction(false, I18n.tr("Join Node to Way", new Object[0]), "joinnodeway", I18n.tr("Include a node into the nearest way segments", new Object[0]), Shortcut.registerShortcut("tools:joinnodeway", I18n.tr("Tool: {0}", I18n.tr("Join Node to Way", new Object[0])), 74, 5003), true);
        joinNodeWayAction.putValue("help", HelpUtil.ht("/Action/JoinNodeWay"));
        return joinNodeWayAction;
    }

    public static JoinNodeWayAction createMoveNodeOntoWayAction() {
        JoinNodeWayAction joinNodeWayAction = new JoinNodeWayAction(true, I18n.tr("Move Node onto Way", new Object[0]), "movenodeontoway", I18n.tr("Move the node onto the nearest way segments and include it", new Object[0]), Shortcut.registerShortcut("tools:movenodeontoway", I18n.tr("Tool: {0}", I18n.tr("Move Node onto Way", new Object[0])), 78, 5003), true);
        joinNodeWayAction.putValue("help", HelpUtil.ht("/Action/MoveNodeWay"));
        return joinNodeWayAction;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        MultiMap multiMap;
        Object object5;
        if (!this.isEnabled()) {
            return;
        }
        Collection<Node> collection = JoinNodeWayAction.getCurrentDataSet().getSelectedNodes();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        boolean bl = !JoinNodeWayAction.getCurrentDataSet().getSelectedWays().isEmpty();
        for (Node object6 : collection) {
            object5 = Main.map.mapView.getNearestWaySegments(Main.map.mapView.getPoint(object6), OsmPrimitive.isSelectablePredicate);
            multiMap = new MultiMap();
            iterator = object5.iterator();
            while (iterator.hasNext()) {
                WaySegment waySegment = (WaySegment)iterator.next();
                if (bl && !waySegment.way.isSelected() || waySegment.getFirstNode().equals(object6) || waySegment.getSecondNode().equals(object6)) continue;
                multiMap.put(waySegment.way, waySegment.lowerIndex);
            }
            for (Map.Entry entry : multiMap.entrySet()) {
                object4 = (Way)entry.getKey();
                object3 = entry.getValue();
                object2 = JoinNodeWayAction.pruneSuccs(object3).iterator();
                while (object2.hasNext()) {
                    int n = (Integer)object2.next();
                    object = !hashMap.containsKey(object4) ? new MultiMap() : (MultiMap)hashMap.get(object4);
                    ((MultiMap)object).put(n, object6);
                    hashMap.put(object4, object);
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object5 = (Way)entry.getKey();
            multiMap = (MultiMap)entry.getValue();
            iterator = new LinkedList();
            iterator.addAll(multiMap.keySet());
            Collections.sort(iterator, Collections.reverseOrder());
            List<Node> list = ((Way)object5).getNodes();
            object4 = iterator.iterator();
            while (object4.hasNext()) {
                Object object6;
                object3 = (Integer)object4.next();
                object2 = multiMap.get(object3);
                if (this.joinWayToNode) {
                    object6 = object2.iterator();
                    while (object6.hasNext()) {
                        EastNorth eastNorth;
                        object = (Node)object6.next();
                        MoveCommand moveCommand = new MoveCommand((Node)object, Projections.inverseProject(eastNorth = Geometry.closestPointToSegment(((Way)object5).getNode((Integer)object3).getEastNorth(), ((Way)object5).getNode((Integer)object3 + 1).getEastNorth(), ((Node)object).getEastNorth())));
                        if (linkedList.contains(moveCommand)) continue;
                        linkedList.add(moveCommand);
                    }
                }
                object6 = new LinkedList();
                object6.addAll(object2);
                Collections.sort(object6, new NodeDistanceToRefNodeComparator(((Way)object5).getNode((Integer)object3), ((Way)object5).getNode((Integer)object3 + 1), !this.joinWayToNode));
                list.addAll((Integer)object3 + 1, (Collection<Node>)object6);
            }
            object4 = new Way((Way)object5);
            ((Way)object4).setNodes(list);
            linkedList.add(new ChangeCommand((OsmPrimitive)object5, (OsmPrimitive)object4));
        }
        if (linkedList.isEmpty()) {
            return;
        }
        Main.main.undoRedo.add(new SequenceCommand(this.getValue("Name").toString(), linkedList));
        Main.map.repaint();
    }

    private static SortedSet<Integer> pruneSuccs(Collection<Integer> collection) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int n : collection) {
            if (treeSet.contains(n - 1) || treeSet.contains(n + 1)) continue;
            treeSet.add(n);
        }
        return treeSet;
    }

    @Override
    protected void updateEnabledState() {
        if (JoinNodeWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(JoinNodeWayAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private static class NodeDistanceToRefNodeComparator
    implements Comparator<Node>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final EastNorth refPoint;
        private EastNorth refPoint2;
        private final boolean projectToSegment;

        NodeDistanceToRefNodeComparator(Node node, Node node2, boolean bl) {
            this.refPoint = node.getEastNorth();
            this.refPoint2 = node2.getEastNorth();
            this.projectToSegment = bl;
        }

        @Override
        public int compare(Node node, Node node2) {
            double d;
            double d2;
            double d3;
            EastNorth eastNorth = node.getEastNorth();
            EastNorth eastNorth2 = node2.getEastNorth();
            if (this.projectToSegment) {
                eastNorth = Geometry.closestPointToSegment(this.refPoint, this.refPoint2, eastNorth);
                eastNorth2 = Geometry.closestPointToSegment(this.refPoint, this.refPoint2, eastNorth2);
            }
            if ((d3 = (d2 = eastNorth.distance(this.refPoint)) - (d = eastNorth2.distance(this.refPoint))) > 0.0) {
                return 1;
            }
            if (d3 < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

