/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.thread.Queue;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"SizedQueue"}, parent="Queue")
public class SizedQueue
extends Queue {
    public SizedQueue(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public SizedQueue(Ruby runtime, RubyClass type2, int size2) {
        super(runtime, type2);
        this.queue = new ArrayBlockingQueue(size2, false);
    }

    public static void setup(Ruby runtime) {
        RubyClass cSizedQueue = runtime.defineClass("SizedQueue", runtime.getClass("Queue"), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new SizedQueue(runtime, klass);
            }
        });
        cSizedQueue.setReifiedClass(SizedQueue.class);
        cSizedQueue.defineAnnotatedMethods(SizedQueue.class);
    }

    @Override
    @JRubyMethod
    public IRubyObject clear(ThreadContext context) {
        super.clear(context);
        return this;
    }

    @JRubyMethod
    public RubyNumeric max(ThreadContext context) {
        return RubyNumeric.int2fix(context.runtime, this.queue.size() + this.queue.remainingCapacity());
    }

    @JRubyMethod(name={"max="})
    public synchronized IRubyObject max_set(ThreadContext context, IRubyObject arg2) {
        BlockingQueue oldQueue = this.queue;
        this.initialize(context, arg2);
        oldQueue.drainTo(this.queue);
        return arg2;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public synchronized IRubyObject initialize(ThreadContext context, IRubyObject arg2) {
        int new_capacity = RubyNumeric.fix2int(arg2);
        if (new_capacity <= 0) {
            throw context.runtime.newArgumentError("queue size must be positive");
        }
        this.queue = new ArrayBlockingQueue(new_capacity, false);
        return this;
    }
}

