/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public abstract class NodeFieldAccessor {
    private static final boolean USE_UNSAFE = Boolean.getBoolean("truffle.unsafe");
    private final NodeFieldKind kind;
    private final String name;
    protected final Class<?> type;
    protected final long offset;
    private static final Unsafe unsafe = NodeFieldAccessor.getUnsafe();
    private static final NodeUtil.FieldOffsetProvider unsafeFieldOffsetProvider = new NodeUtil.FieldOffsetProvider(){

        @Override
        public long objectFieldOffset(Field field) {
            return unsafe.objectFieldOffset(field);
        }

        @Override
        public int getTypeSize(Class<?> clazz) {
            if (!clazz.isPrimitive()) {
                return Unsafe.ARRAY_OBJECT_INDEX_SCALE;
            }
            if (clazz == Integer.TYPE) {
                return Unsafe.ARRAY_INT_INDEX_SCALE;
            }
            throw new UnsupportedOperationException("unsupported field type: " + clazz);
        }
    };

    protected NodeFieldAccessor(NodeFieldKind kind, Field field) {
        this.kind = kind;
        this.type = field.getType();
        this.name = field.getName();
        this.offset = unsafeFieldOffsetProvider.objectFieldOffset(field);
    }

    protected static NodeFieldAccessor create(NodeFieldKind kind, Field field) {
        if (USE_UNSAFE) {
            return new UnsafeNodeField(kind, field);
        }
        return new ReflectionNodeField(kind, field);
    }

    public NodeFieldKind getKind() {
        return this.kind;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public long getOffset() {
        return this.offset;
    }

    public abstract void putObject(Node var1, Object var2);

    public abstract Object getObject(Node var1);

    public abstract Object loadValue(Node var1);

    public int hashCode() {
        return this.kind.hashCode() | this.type.hashCode() | this.name.hashCode() | Long.valueOf(this.offset).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeFieldAccessor) {
            NodeFieldAccessor other = (NodeFieldAccessor)obj;
            return this.offset == other.offset && this.name.equals(other.name) && this.type.equals(other.type) && this.kind.equals((Object)other.kind);
        }
        return false;
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    public static enum NodeFieldKind {
        NODE_CLASS,
        PARENT,
        CHILD,
        CHILDREN,
        DATA;

    }

    private static final class ReflectionNodeField
    extends NodeFieldAccessor {
        private final Field field;

        protected ReflectionNodeField(NodeFieldKind kind, Field field) {
            super(kind, field);
            this.field = field;
            field.setAccessible(true);
        }

        @Override
        public void putObject(Node receiver, Object value) {
            assert (!this.type.isPrimitive() && value == null || this.type.isInstance(value));
            try {
                this.field.set(receiver, value);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Object getObject(Node receiver) {
            assert (!this.type.isPrimitive());
            try {
                return this.field.get(receiver);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public Object loadValue(Node node) {
            try {
                if (this.type == Boolean.TYPE) {
                    return this.field.getBoolean(node);
                }
                if (this.type == Byte.TYPE) {
                    return this.field.getByte(node);
                }
                if (this.type == Short.TYPE) {
                    return this.field.getShort(node);
                }
                if (this.type == Character.TYPE) {
                    return Character.valueOf(this.field.getChar(node));
                }
                if (this.type == Integer.TYPE) {
                    return this.field.getInt(node);
                }
                if (this.type == Long.TYPE) {
                    return this.field.getLong(node);
                }
                if (this.type == Float.TYPE) {
                    return Float.valueOf(this.field.getFloat(node));
                }
                if (this.type == Double.TYPE) {
                    return this.field.getDouble(node);
                }
                return this.field.get(node);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static final class UnsafeNodeField
    extends NodeFieldAccessor {
        protected UnsafeNodeField(NodeFieldKind kind, Field field) {
            super(kind, field);
        }

        @Override
        public void putObject(Node receiver, Object value) {
            if ((this.type.isPrimitive() || value != null) && !this.type.isInstance(value)) {
                throw new IllegalArgumentException();
            }
            unsafe.putObject(receiver, this.offset, value);
        }

        @Override
        public Object getObject(Node receiver) {
            if (!this.type.isPrimitive()) {
                return unsafe.getObject(receiver, this.offset);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object loadValue(Node node) {
            if (this.type == Boolean.TYPE) {
                return unsafe.getBoolean(node, this.offset);
            }
            if (this.type == Byte.TYPE) {
                return unsafe.getByte(node, this.offset);
            }
            if (this.type == Short.TYPE) {
                return unsafe.getShort(node, this.offset);
            }
            if (this.type == Character.TYPE) {
                return Character.valueOf(unsafe.getChar(node, this.offset));
            }
            if (this.type == Integer.TYPE) {
                return unsafe.getInt(node, this.offset);
            }
            if (this.type == Long.TYPE) {
                return unsafe.getLong(node, this.offset);
            }
            if (this.type == Float.TYPE) {
                return Float.valueOf(unsafe.getFloat(node, this.offset));
            }
            if (this.type == Double.TYPE) {
                return unsafe.getDouble(node, this.offset);
            }
            return unsafe.getObject(node, this.offset);
        }
    }
}

