/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class CachedBoxedReturnMissingDispatchNode
extends CachedDispatchNode {
    private final Shape expectedShape;
    private final Assumption unmodifiedAssumption;

    public CachedBoxedReturnMissingDispatchNode(RubyContext context, Object cachedName, DispatchNode next, Shape expectedShape, DynamicObject expectedClass, DispatchAction dispatchAction) {
        super(context, cachedName, next, dispatchAction);
        this.expectedShape = expectedShape;
        this.unmodifiedAssumption = Layouts.MODULE.getFields(expectedClass).getUnmodifiedAssumption();
        this.next = next;
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && receiver instanceof DynamicObject && ((DynamicObject)receiver).getShape() == this.expectedShape;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects) {
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects, "class modified");
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                return MISSING;
            }
            case RESPOND_TO_METHOD: {
                return false;
            }
        }
        throw new UnsupportedOperationException();
    }
}

