// Generated by IcedCoffeeScript 1.7.1-b
(function() {
  var Warnings, akatch, assert, assert_no_nulls, asyncify, bufeq_secure, buffer_to_ui8a, bufferify, dict_union, is_sorted, katch, obj_extract, ui32a_to_ui8a, ui8Ga_to_ui32a, xxd,
    __slice = [].slice;

  assert = require('assert');

  exports.Warnings = Warnings = (function() {
    function Warnings() {
      this._w = [];
    }

    Warnings.prototype.push = function() {
      var args, _ref;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return (_ref = this._w).push.apply(_ref, args);
    };

    Warnings.prototype.warnings = function() {
      return this._w;
    };

    return Warnings;

  })();

  exports.bufeq_fast = function(x, y) {
    var i, _i, _ref;
    if ((x == null) && (y == null)) {
      return true;
    }
    if ((x == null) || (y == null)) {
      return false;
    }
    if (x.length !== y.length) {
      return false;
    }
    for (i = _i = 0, _ref = x.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
      if (x.readUInt8(i) !== y.readUInt8(i)) {
        return false;
      }
    }
    return true;
  };

  exports.bufeq_secure = bufeq_secure = function(x, y) {
    var check, i, ret;
    ret = (function() {
      var _i, _ref;
      if ((x == null) && (y == null)) {
        return true;
      } else if ((x == null) || (y == null)) {
        return false;
      } else if (x.length !== y.length) {
        return false;
      } else {
        check = 0;
        for (i = _i = 0, _ref = x.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
          check += x.readUInt8(i) ^ y.readUInt8(i);
        }
        return check === 0;
      }
    })();
    return ret;
  };

  exports.streq_secure = function(x, y) {
    return bufeq_secure(bufferify(x), bufferify(y));
  };

  exports.bufferify = bufferify = function(s) {
    if (Buffer.isBuffer(s)) {
      return s;
    } else if (typeof s === 'string') {
      return new Buffer(s, 'utf8');
    } else {
      throw new Error("Cannot convert to buffer: " + s);
    }
  };

  exports.katch = katch = function(fn) {
    var e, err, ret;
    ret = err = null;
    try {
      ret = fn();
    } catch (_error) {
      e = _error;
      err = e;
    }
    return [err, ret];
  };

  exports.akatch = akatch = function(fn, cb) {
    return asyncify(katch(fn), cb);
  };

  exports.athrow = function(err, cb) {
    return cb(err);
  };

  exports.asyncify = asyncify = function(args, cb) {
    return cb.apply(null, args);
  };

  exports.a_json_parse = function(s, cb) {
    return akatch((function() {
      return JSON.parse(s);
    }), cb);
  };

  exports.buffer_to_ui8a = buffer_to_ui8a = function(b) {
    var i, l, ret, _i;
    l = b.length;
    ret = new Uint8Array(l);
    for (i = _i = 0; 0 <= l ? _i < l : _i > l; i = 0 <= l ? ++_i : --_i) {
      ret[i] = b.readUInt8(i);
    }
    return ret;
  };

  exports.ui32a_to_ui8a = ui32a_to_ui8a = function(v, out) {
    var k, w, _i, _len;
    if (out == null) {
      out = null;
    }
    out || (out = new Uint8Array(v.length * 4));
    k = 0;
    for (_i = 0, _len = v.length; _i < _len; _i++) {
      w = v[_i];
      out[k++] = (w >> 24) & 0xff;
      out[k++] = (w >> 16) & 0xff;
      out[k++] = (w >> 8) & 0xff;
      out[k++] = w & 0xff;
    }
    return out;
  };

  exports.ui8a_to_ui32a = ui8Ga_to_ui32a = function(v, out) {
    var b, i, k, tmp, _i, _len;
    if (out == null) {
      out = null;
    }
    out || (out = new Uint32Array(v.length >> 2));
    k = 0;
    for (i = _i = 0, _len = v.length; _i < _len; i = _i += 4) {
      b = v[i];
      tmp = (b << 24) + (v[i + 1] << 16) + (v[i + 2] << 8) + v[i + 3];
      out[k++] = tmp;
    }
    return out;
  };

  exports.unix_time = function() {
    return Math.floor(Date.now() / 1000);
  };

  exports.is_sorted = is_sorted = function(list, sort_fn) {
    var i, j, _i, _ref;
    if (sort_fn == null) {
      sort_fn = function(a, b) {
        return ("" + a).localeCompare("" + b);
      };
    }
    for (i = _i = 0, _ref = list.length - 1; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
      j = i + 1;
      if (sort_fn(list[i], list[j]) > 0) {
        return false;
      }
    }
    return true;
  };

  exports.json_stringify_sorted = function(o, opts) {
    var i, json_safe, lb, o2, sort_fn, space_it, spaces, str;
    opts = opts || {};
    sort_fn = opts.sort_fn || null;
    spaces = opts.spaces || null;
    lb = opts.spaces != null ? "\n" : "";
    if ((typeof spaces) === "number") {
      spaces = ((function() {
        var _i, _results;
        _results = [];
        for (i = _i = 0; 0 <= spaces ? _i < spaces : _i > spaces; i = 0 <= spaces ? ++_i : --_i) {
          _results.push(" ");
        }
        return _results;
      })()).join("");
    }
    space_it = function(depth) {
      if (spaces == null) {
        return "";
      }
      return "\n" + ((function() {
        var _i, _results;
        _results = [];
        for (i = _i = 0; 0 <= depth ? _i < depth : _i > depth; i = 0 <= depth ? ++_i : --_i) {
          _results.push(spaces);
        }
        return _results;
      })()).join("");
    };
    json_safe = function(os, depth) {
      var k, keys, s, sp, spp, v;
      if (Array.isArray(os)) {
        s = "[" + ((function() {
          var _i, _len, _results;
          _results = [];
          for (_i = 0, _len = os.length; _i < _len; _i++) {
            v = os[_i];
            _results.push(json_safe(v, depth + 1));
          }
          return _results;
        })()).join(',') + "]";
      } else if ((typeof os) === "object") {
        if (!os) {
          s = JSON.stringify(os);
        } else {
          sp = space_it(depth);
          spp = space_it(depth + 1);
          keys = (function() {
            var _results;
            _results = [];
            for (k in os) {
              _results.push(k);
            }
            return _results;
          })();
          if (sort_fn != null) {
            keys.sort(sort_fn);
          } else {
            keys.sort();
          }
          s = "{" + ((function() {
            var _i, _len, _results;
            _results = [];
            for (_i = 0, _len = keys.length; _i < _len; _i++) {
              k = keys[_i];
              _results.push(spp + JSON.stringify(k) + ":" + json_safe(os[k], depth + 1));
            }
            return _results;
          })()).join(',') + sp + "}";
        }
      } else {
        s = JSON.stringify(os);
      }
      return s;
    };
    str = JSON.stringify(o);
    if (str === void 0) {
      return str;
    } else {
      o2 = JSON.parse(str);
      return json_safe(o2, 0);
    }
  };

  exports.obj_extract = obj_extract = function(o, keys) {
    var k, ret, _i, _len;
    ret = {};
    for (_i = 0, _len = keys.length; _i < _len; _i++) {
      k = keys[_i];
      ret[k] = o[k];
    }
    return ret;
  };

  exports.base64u = {
    encode: function(b) {
      return b.toString('base64').replace(/\+/g, '-').replace(/\//g, '_').replace(/=+$/, '');
    },
    decode: function(b) {
      b = (b + Array(5 - b.length % 4).join('=')).replace(/\-/g, '+').replace(/\_/g, '/');
      return new Buffer(b, 'base64');
    },
    verify: function(b) {
      return /^[A-Za-z0-9\-_]+$/.test(b);
    }
  };

  exports.assert_no_nulls = assert_no_nulls = function(v) {
    var e, ok, _i, _len;
    ok = true;
    for (_i = 0, _len = v.length; _i < _len; _i++) {
      e = v[_i];
      if (e == null) {
        ok = false;
      }
    }
    if (!ok) {
      console.error("Found 1 or more nulls in vector: ");
      console.error(v);
      return assert(false);
    }
  };

  exports.chain = function(cb2, cb1) {
    return function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return cb1(function() {
        return cb2.apply(null, args);
      });
    };
  };

  exports.dict_union = dict_union = function() {
    var args, d, k, out, v, _i, _len;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    out = {};
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      d = args[_i];
      for (k in d) {
        v = d[k];
        out[k] = v;
      }
    }
    return out;
  };

  exports.dict_merge = function() {
    var args, clone, d, isdict, m, out, _i, _len;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    isdict = function(x) {
      return x && (typeof x === 'object') && !(Array.isArray(x)) && !(Buffer.isBuffer(x));
    };
    clone = function(x) {
      var k, out, v;
      if (typeof x !== 'object') {
        return x;
      } else if (Array.isArray(x)) {
        return x.slice(0);
      } else {
        out = {};
        for (k in x) {
          v = x[k];
          out[k] = clone(v);
        }
        return out;
      }
    };
    m = function(y, x) {
      var k, v1, v2, _results;
      _results = [];
      for (k in x) {
        v1 = x[k];
        v2 = y[k];
        if (!isdict(v1)) {
          _results.push(y[k] = v1);
        } else if (isdict(v2)) {
          _results.push(m(v2, v1));
        } else {
          _results.push(y[k] = clone(v1));
        }
      }
      return _results;
    };
    out = {};
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      d = args[_i];
      m(out, d);
    }
    return out;
  };

  exports.xxd = xxd = function(buf, opts) {
    var i, line, lines, p, pad, q, quartets, v;
    if (opts == null) {
      opts = {};
    }
    q = opts.q || 8;
    p = opts.p || 7;
    buf = buf.toString('hex');
    quartets = (function() {
      var _i, _ref, _results;
      _results = [];
      for (i = _i = 0, _ref = buf.length; _i < _ref; i = _i += 4) {
        _results.push(buf.slice(i, i + 4));
      }
      return _results;
    })();
    lines = (function() {
      var _i, _ref, _results;
      _results = [];
      for (i = _i = 0, _ref = quartets.length; q > 0 ? _i < _ref : _i > _ref; i = _i += q) {
        _results.push(quartets.slice(i, i + q).join(' '));
      }
      return _results;
    })();
    pad = function(s, n) {
      return ((function() {
        var _i, _ref, _results;
        _results = [];
        for (_i = 0, _ref = n - s.length; 0 <= _ref ? _i < _ref : _i > _ref; 0 <= _ref ? _i++ : _i--) {
          _results.push('0');
        }
        return _results;
      })()).join('') + s;
    };
    v = (function() {
      var _i, _len, _results;
      _results = [];
      for (i = _i = 0, _len = lines.length; _i < _len; i = ++_i) {
        line = lines[i];
        _results.push(pad((i * 2 * q).toString(16), p) + ": " + line);
      }
      return _results;
    })();
    return v.join("\n");
  };

}).call(this);
