// Generated by IcedCoffeeScript 1.8.0-d
(function() {
  var BaseScraper, GithubScraper, constants, iced, v_codes, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime');
  __iced_k = __iced_k_noop = function() {};

  BaseScraper = require('./base').BaseScraper;

  constants = require('../constants').constants;

  v_codes = constants.v_codes;

  exports.GithubScraper = GithubScraper = (function(_super) {
    __extends(GithubScraper, _super);

    function GithubScraper(opts) {
      this.auth = opts.auth;
      GithubScraper.__super__.constructor.call(this, opts);
    }

    GithubScraper.prototype._check_args = function(args) {
      if (!(args.username != null)) {
        return new Error("Bad args to Github proof: no username given");
      } else if (!(args.name != null) || (args.name !== 'github')) {
        return new Error("Bad args to Github proof: type is " + args.name);
      } else {
        return null;
      }
    };

    GithubScraper.prototype.hunt2 = function(_arg, cb) {
      var err, gist, json, name, out, proof_text_check, rc, url, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username, proof_text_check = _arg.proof_text_check, name = _arg.name;
      rc = v_codes.OK;
      out = {};
      if ((err = this._check_args({
        username: username,
        name: name
      })) != null) {
        return cb(err, out);
      }
      url = "https://api.github.com/users/" + username + "/gists";
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/scrapers/github.iced",
            funcname: "GithubScraper.hunt2"
          });
          _this._get_body(url, true, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                rc = arguments[1];
                return json = arguments[2];
              };
            })(),
            lineno: 33
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          _this.log("| search index " + url + " -> " + rc);
          (function(__iced_k) {
            if (rc === v_codes.OK) {
              rc = v_codes.NOT_FOUND;
              (function(__iced_k) {
                var _i, _len, _ref, _results, _while;
                _ref = json;
                _len = _ref.length;
                _i = 0;
                _results = [];
                _while = function(__iced_k) {
                  var _break, _continue, _next;
                  _break = function() {
                    return __iced_k(_results);
                  };
                  _continue = function() {
                    return iced.trampoline(function() {
                      ++_i;
                      return _while(__iced_k);
                    });
                  };
                  _next = function(__iced_next_arg) {
                    _results.push(__iced_next_arg);
                    return _continue();
                  };
                  if (!(_i < _len)) {
                    return _break();
                  } else {
                    gist = _ref[_i];
                    (function(__iced_k) {
                      __iced_deferrals = new iced.Deferrals(__iced_k, {
                        parent: ___iced_passed_deferral,
                        filename: "/Users/max/src/keybase/proofs/src/scrapers/github.iced",
                        funcname: "GithubScraper.hunt2"
                      });
                      _this._search_gist({
                        gist: gist,
                        proof_text_check: proof_text_check
                      }, __iced_deferrals.defer({
                        assign_fn: (function() {
                          return function() {
                            return out = arguments[0];
                          };
                        })(),
                        lineno: 38
                      }));
                      __iced_deferrals._fulfill();
                    })(function() {
                      (function(__iced_k) {
                        if (out.rc === v_codes.OK) {
                          (function(__iced_k) {
_break()
                          })(__iced_k);
                        } else {
                          return __iced_k();
                        }
                      })(_next);
                    });
                  }
                };
                _while(__iced_k);
              })(__iced_k);
            } else {
              return __iced_k();
            }
          })(function() {
            out.rc || (out.rc = rc);
            return cb(err, out);
          });
        };
      })(this));
    };

    GithubScraper.prototype._check_api_url = function(_arg) {
      var api_url, rxx, username;
      api_url = _arg.api_url, username = _arg.username;
      rxx = new RegExp("^https://gist.github(usercontent)?\\.com/" + username + "/", "i");
      return (api_url != null) && api_url.match(rxx);
    };

    GithubScraper.prototype._search_gist = function(_arg, cb) {
      var content, err, file, filename, gist, id, json, out, proof_text_check, rc, u, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      gist = _arg.gist, proof_text_check = _arg.proof_text_check;
      out = {};
      (function(_this) {
        return (function(__iced_k) {
          if ((u = gist.url) == null) {
            _this.log("| gist didn't have a URL");
            return __iced_k(rc = v_codes.FAILED_PARSE);
          } else {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/proofs/src/scrapers/github.iced",
                funcname: "GithubScraper._search_gist"
              });
              _this._get_body(u, true, __iced_deferrals.defer({
                assign_fn: (function() {
                  return function() {
                    err = arguments[0];
                    rc = arguments[1];
                    return json = arguments[2];
                  };
                })(),
                lineno: 57
              }));
              __iced_deferrals._fulfill();
            })(function() {
              var _ref;
              if (rc !== v_codes.OK) {

              } else if (json.files == null) {
                rc = v_codes.FAILED_PARSE;
              } else {
                rc = v_codes.NOT_FOUND;
                _ref = json.files;
                for (filename in _ref) {
                  file = _ref[filename];
                  if ((content = file.content) != null) {
                    if ((id = _this._stripr(content).indexOf(proof_text_check)) >= 0) {
                      _this.log("| search " + filename + " -> found");
                      rc = v_codes.OK;
                      out = {
                        api_url: file.raw_url,
                        remote_id: gist.id,
                        human_url: gist.html_url
                      };
                      break;
                    } else {
                      _this.log("| search " + filename + " -> miss");
                    }
                  }
                }
              }
              return __iced_k(_this.log("| search gist " + u + " -> " + rc));
            });
          }
        });
      })(this)((function(_this) {
        return function() {
          out.rc = rc;
          return cb(out);
        };
      })(this));
    };

    GithubScraper.prototype.check_status = function(_arg, cb) {
      var api_url, err, proof_text_check, raw, rc, remote_id, username, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      username = _arg.username, api_url = _arg.api_url, proof_text_check = _arg.proof_text_check, remote_id = _arg.remote_id;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/proofs/src/scrapers/github.iced",
            funcname: "GithubScraper.check_status"
          });
          _this._get_body(api_url, false, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                rc = arguments[1];
                return raw = arguments[2];
              };
            })(),
            lineno: 82
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          rc = rc !== v_codes.OK ? rc : (raw.indexOf(proof_text_check)) >= 0 ? v_codes.OK : v_codes.NOT_FOUND;
          return cb(err, rc);
        };
      })(this));
    };

    GithubScraper.prototype._get_body = function(url, json, cb) {
      var args;
      this.log("| HTTP request for URL '" + url + "'");
      args = {
        url: url,
        auth: this.auth
      };
      if (json) {
        args.json = 1;
      }
      return this._get_url_body(args, cb);
    };

    return GithubScraper;

  })(BaseScraper);

}).call(this);
