/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.segment.srx.legacy;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.segment.AbstractTextIterator;
import net.sourceforge.segment.srx.LanguageRule;
import net.sourceforge.segment.srx.Rule;
import net.sourceforge.segment.srx.RuleMatcher;
import net.sourceforge.segment.srx.SrxDocument;

public class AccurateSrxTextIterator
extends AbstractTextIterator {
    private List<LanguageRule> languageRuleList;
    private CharSequence text;
    private String segment;
    private List<RuleMatcher> ruleMatcherList;
    private int startPosition;
    private int endPosition;

    public AccurateSrxTextIterator(SrxDocument document, String languageCode, CharSequence text) {
        this.languageRuleList = document.getLanguageRuleList(languageCode);
        this.text = text;
        this.segment = null;
        this.startPosition = 0;
        this.endPosition = 0;
        this.ruleMatcherList = new LinkedList<RuleMatcher>();
        for (LanguageRule languageRule : this.languageRuleList) {
            for (Rule rule : languageRule.getRuleList()) {
                RuleMatcher matcher = new RuleMatcher(document, rule, text);
                this.ruleMatcherList.add(matcher);
            }
        }
    }

    public String next() {
        if (this.hasNext()) {
            if (this.segment == null) {
                this.initMatchers();
            }
            boolean found = false;
            while (this.ruleMatcherList.size() > 0 && !found) {
                RuleMatcher minMatcher = this.getMinMatcher();
                this.endPosition = minMatcher.getBreakPosition();
                if (minMatcher.getRule().isBreak() && this.endPosition > this.startPosition) {
                    found = true;
                    this.cutMatchers();
                }
                this.moveMatchers();
            }
            if (!found) {
                this.endPosition = this.text.length();
            }
            this.segment = this.text.subSequence(this.startPosition, this.endPosition).toString();
            this.startPosition = this.endPosition;
            return this.segment;
        }
        return null;
    }

    public boolean hasNext() {
        return this.startPosition < this.text.length();
    }

    private void initMatchers() {
        Iterator<RuleMatcher> i = this.ruleMatcherList.iterator();
        while (i.hasNext()) {
            RuleMatcher matcher = i.next();
            matcher.find();
            if (!matcher.hitEnd()) continue;
            i.remove();
        }
    }

    private void moveMatchers() {
        Iterator<RuleMatcher> i = this.ruleMatcherList.iterator();
        block0: while (i.hasNext()) {
            RuleMatcher matcher = i.next();
            while (matcher.getBreakPosition() <= this.endPosition) {
                matcher.find();
                if (!matcher.hitEnd()) continue;
                i.remove();
                continue block0;
            }
        }
    }

    private void cutMatchers() {
        Iterator<RuleMatcher> i = this.ruleMatcherList.iterator();
        while (i.hasNext()) {
            RuleMatcher matcher = i.next();
            if (matcher.getStartPosition() >= this.endPosition) continue;
            matcher.find(this.endPosition);
            if (!matcher.hitEnd()) continue;
            i.remove();
        }
    }

    private RuleMatcher getMinMatcher() {
        int minPosition = Integer.MAX_VALUE;
        RuleMatcher minMatcher = null;
        for (RuleMatcher matcher : this.ruleMatcherList) {
            if (matcher.getBreakPosition() >= minPosition) continue;
            minPosition = matcher.getBreakPosition();
            minMatcher = matcher;
        }
        return minMatcher;
    }
}

