/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import net.java.sen.filter.stream.CompositeTokenFilter;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.solr.analysis.BaseTokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JapaneseTokenizerFactory
extends BaseTokenizerFactory
implements ResourceLoaderAware {
    private CompositeTokenFilter compositeTokenFilter;
    private String dictionaryDir;

    public void init(Map<String, String> args) {
        super.init(args);
    }

    public void inform(ResourceLoader loader) {
        String dirVal;
        String compositePosFile = (String)this.args.get("compositePOS");
        if (compositePosFile != null) {
            this.compositeTokenFilter = new CompositeTokenFilter();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(loader.openResource(compositePosFile), "UTF-8"));
                this.compositeTokenFilter.readRules(reader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        if ((dirVal = (String)this.args.get("dictionaryDir")) != null) {
            SolrResourceLoader solrLoader = (SolrResourceLoader)SolrResourceLoader.class.cast(loader);
            File d0 = new File(dirVal);
            File d = d0;
            if (!d.isAbsolute()) {
                d = new File(solrLoader.getConfigDir() + dirVal);
            }
            this.dictionaryDir = d.isDirectory() && d.canRead() ? d.getAbsolutePath() : (d != d0 && d0.isDirectory() && d0.canRead() ? d0.getAbsolutePath() : dirVal);
        }
    }

    public Tokenizer create(Reader reader) {
        return new JapaneseTokenizer(reader, this.compositeTokenFilter, this.dictionaryDir);
    }
}

