/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import junit.framework.TestCase;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.UppercaseSentenceStartRule;

public class UppercaseSentenceStartRuleTest
extends TestCase {
    public void testRule() throws IOException {
        UppercaseSentenceStartRule rule = new UppercaseSentenceStartRule(TestTools.getEnglishMessages(), TestTools.getDemoLanguage());
        JLanguageTool langTool = new JLanguageTool(TestTools.getDemoLanguage());
        RuleMatch[] matches = rule.match(langTool.getAnalyzedSentence("a) This is a test sentence."));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("iv. This is a test sentence..."));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\"iv. This is a test sentence...\""));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u00bbiv. This is a test sentence..."));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This"));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This is"));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("This is a test sentence"));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("this is a sentence"));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence(""));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("http://www.languagetool.org"));
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("this is a test sentence."));
        UppercaseSentenceStartRuleTest.assertEquals((int)1, (int)matches.length);
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches[0].getFromPos());
        UppercaseSentenceStartRuleTest.assertEquals((int)4, (int)matches[0].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("this"));
        UppercaseSentenceStartRuleTest.assertEquals((int)1, (int)matches.length);
        UppercaseSentenceStartRuleTest.assertEquals((int)0, (int)matches[0].getFromPos());
        UppercaseSentenceStartRuleTest.assertEquals((int)4, (int)matches[0].getToPos());
        matches = rule.match(langTool.getAnalyzedSentence("'this is a sentence'."));
        UppercaseSentenceStartRuleTest.assertEquals((int)1, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\"this is a sentence.\""));
        UppercaseSentenceStartRuleTest.assertEquals((int)1, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u201ethis is a sentence."));
        UppercaseSentenceStartRuleTest.assertEquals((int)1, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u00abthis is a sentence."));
        UppercaseSentenceStartRuleTest.assertEquals((int)1, (int)matches.length);
        matches = rule.match(langTool.getAnalyzedSentence("\u2018this is a sentence."));
        UppercaseSentenceStartRuleTest.assertEquals((int)1, (int)matches.length);
    }
}

