/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.Utils;

public class LiteralStringObject
implements StringObject {
    private StringBuilder stringData;
    private static char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    Reference reference;

    public LiteralStringObject(byte[] bytes) {
        this(new StringBuilder(bytes.length).append(new String(bytes)));
    }

    public LiteralStringObject(String string) {
        this.stringData = new StringBuilder(string);
    }

    public LiteralStringObject(String string, Reference reference, SecurityManager securityManager) {
        this.reference = reference;
        this.stringData = new StringBuilder(this.encryption(string, false, securityManager));
    }

    public LiteralStringObject(StringBuilder stringBuffer) {
        stringBuffer.deleteCharAt(0);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        this.stringData = new StringBuilder(stringBuffer.length());
        this.stringData.append(stringBuffer.toString());
    }

    public int getUnsignedInt(int start, int offset) {
        if (start < 0 || this.stringData.length() < start + offset) {
            return this.stringData.charAt(0);
        }
        if (offset == 1) {
            return this.stringData.charAt(start);
        }
        if (offset == 2) {
            return (this.stringData.charAt(start) & 0xFF) << 8 | this.stringData.charAt(start + 1) & 0xFF;
        }
        if (offset == 4) {
            return (this.stringData.charAt(start) & 0xFF) << 24 | (this.stringData.charAt(start + 1) & 0xFF) << 16 | (this.stringData.charAt(start + 2) & 0xFF) << 8 | this.stringData.charAt(start + 3) & 0xFF;
        }
        return 0;
    }

    public String toString() {
        return this.stringData.toString();
    }

    public String getHexString() {
        return this.stringToHex(this.stringData).toString();
    }

    public StringBuilder getHexStringBuffer() {
        return this.stringToHex(this.stringData);
    }

    public StringBuilder getLiteralStringBuffer() {
        return this.stringData;
    }

    public String getLiteralString() {
        return this.stringData.toString();
    }

    public StringBuilder getLiteralStringBuffer(int fontFormat, FontFile font) {
        if (fontFormat == 1 || font.isOneByteEncoding()) {
            return this.stringData;
        }
        if (fontFormat == 2) {
            int charOffset = 2;
            int length = this.getLength();
            StringBuilder tmp = new StringBuilder(length);
            int lastIndex = 0;
            for (int i = 0; i < length; i += charOffset) {
                int charValue = this.getUnsignedInt(i - lastIndex, lastIndex + charOffset);
                if (charValue > 0 && font.canDisplayEchar((char)charValue)) {
                    tmp.append((char)charValue);
                    lastIndex = 0;
                    continue;
                }
                lastIndex += charOffset;
            }
            return tmp;
        }
        return null;
    }

    public int getLength() {
        return this.stringData.length();
    }

    private StringBuilder stringToHex(StringBuilder string) {
        StringBuilder hh = new StringBuilder(string.length() * 2);
        int max = string.length();
        for (int i = 0; i < max; ++i) {
            char charCode = string.charAt(i);
            hh.append(hexChar[(charCode & 0xF0) >>> 4]);
            hh.append(hexChar[charCode & 0xF]);
        }
        return hh;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    public String getDecryptedLiteralString(SecurityManager securityManager) {
        return this.encryption(this.stringData.toString(), true, securityManager);
    }

    public String encryption(String string, boolean decrypt, SecurityManager securityManager) {
        if (securityManager != null && this.reference != null) {
            byte[] key = securityManager.getDecryptionKey();
            byte[] textBytes = Utils.convertByteCharSequenceToByteArray(string);
            textBytes = decrypt ? securityManager.decrypt(this.reference, key, textBytes) : securityManager.encrypt(this.reference, key, textBytes);
            return Utils.convertByteArrayToByteString(textBytes);
        }
        return string;
    }
}

