/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.halftone;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.pattern.PatternDictionarySegment;
import org.jpedal.jbig2.segment.region.RegionFlags;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.halftone.HalftoneRegionFlags;
import org.jpedal.jbig2.util.BinaryOperation;

public class HalftoneRegionSegment
extends RegionSegment {
    private HalftoneRegionFlags halftoneRegionFlags = new HalftoneRegionFlags();
    private boolean inlineImage;

    public HalftoneRegionSegment(JBIG2StreamDecoder streamDecoder, boolean inlineImage) {
        super(streamDecoder);
        this.inlineImage = inlineImage;
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        Segment segment;
        int[] referedToSegments;
        super.readSegment();
        this.readHalftoneRegionFlags();
        short[] buf = new short[4];
        this.decoder.readByte(buf);
        int gridWidth = BinaryOperation.getInt32(buf);
        buf = new short[4];
        this.decoder.readByte(buf);
        int gridHeight = BinaryOperation.getInt32(buf);
        buf = new short[4];
        this.decoder.readByte(buf);
        int gridX = BinaryOperation.getInt32(buf);
        buf = new short[4];
        this.decoder.readByte(buf);
        int gridY = BinaryOperation.getInt32(buf);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("grid pos and size = " + gridX + ',' + gridY + ' ' + gridWidth + ',' + gridHeight);
        }
        buf = new short[2];
        this.decoder.readByte(buf);
        int stepX = BinaryOperation.getInt16(buf);
        buf = new short[2];
        this.decoder.readByte(buf);
        int stepY = BinaryOperation.getInt16(buf);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("step size = " + stepX + ',' + stepY);
        }
        if ((referedToSegments = this.segmentHeader.getReferredToSegments()).length != 1) {
            System.out.println("Error in halftone Segment. refSegs should == 1");
        }
        if ((segment = this.decoder.findSegment(referedToSegments[0])).getSegmentHeader().getSegmentType() != 16 && JBIG2StreamDecoder.debug) {
            System.out.println("Error in halftone Segment. bad symbol dictionary reference");
        }
        PatternDictionarySegment patternDictionarySegment = (PatternDictionarySegment)segment;
        int bitsPerValue = 0;
        int i = 1;
        while (i < patternDictionarySegment.getSize()) {
            ++bitsPerValue;
            i <<= 1;
        }
        JBIG2Bitmap bitmap = patternDictionarySegment.getBitmaps()[0];
        int patternWidth = bitmap.getWidth();
        int patternHeight = bitmap.getHeight();
        if (JBIG2StreamDecoder.debug) {
            System.out.println("pattern size = " + patternWidth + ',' + patternHeight);
        }
        boolean useMMR = this.halftoneRegionFlags.getFlagValue(HalftoneRegionFlags.H_MMR) != 0;
        int template = this.halftoneRegionFlags.getFlagValue(HalftoneRegionFlags.H_TEMPLATE);
        if (!useMMR) {
            this.arithmeticDecoder.resetGenericStats(template, null);
            this.arithmeticDecoder.start();
        }
        int halftoneDefaultPixel = this.halftoneRegionFlags.getFlagValue(HalftoneRegionFlags.H_DEF_PIXEL);
        bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
        bitmap.clear(halftoneDefaultPixel);
        boolean enableSkip = this.halftoneRegionFlags.getFlagValue(HalftoneRegionFlags.H_ENABLE_SKIP) != 0;
        JBIG2Bitmap skipBitmap = null;
        if (enableSkip) {
            skipBitmap = new JBIG2Bitmap(gridWidth, gridHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
            skipBitmap.clear(0);
            int y = 0;
            while (y < gridHeight) {
                int x = 0;
                while (x < gridWidth) {
                    int xx = gridX + y * stepY + x * stepX;
                    int yy = gridY + y * stepX - x * stepY;
                    if (xx + patternWidth >> 8 <= 0 || xx >> 8 >= this.regionBitmapWidth || yy + patternHeight >> 8 <= 0 || yy >> 8 >= this.regionBitmapHeight) {
                        skipBitmap.setPixel(y, x, 1);
                    }
                    ++x;
                }
                ++y;
            }
        }
        int[] grayScaleImage = new int[gridWidth * gridHeight];
        short[] genericBAdaptiveTemplateX = new short[4];
        short[] genericBAdaptiveTemplateY = new short[4];
        genericBAdaptiveTemplateX[0] = (short)(template <= 1 ? 3 : 2);
        genericBAdaptiveTemplateY[0] = -1;
        genericBAdaptiveTemplateX[1] = -3;
        genericBAdaptiveTemplateY[1] = -1;
        genericBAdaptiveTemplateX[2] = 2;
        genericBAdaptiveTemplateY[2] = -2;
        genericBAdaptiveTemplateX[3] = -2;
        genericBAdaptiveTemplateY[3] = -2;
        int j = bitsPerValue - 1;
        while (j >= 0) {
            JBIG2Bitmap grayBitmap = new JBIG2Bitmap(gridWidth, gridHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
            grayBitmap.readBitmap(useMMR, template, false, enableSkip, skipBitmap, genericBAdaptiveTemplateX, genericBAdaptiveTemplateY, -1);
            i = 0;
            int row = 0;
            while (row < gridHeight) {
                int col = 0;
                while (col < gridWidth) {
                    int bit = grayBitmap.getPixel(col, row) ^ grayScaleImage[i] & 1;
                    grayScaleImage[i] = grayScaleImage[i] << 1 | bit;
                    ++i;
                    ++col;
                }
                ++row;
            }
            --j;
        }
        int combinationOperator = this.halftoneRegionFlags.getFlagValue(HalftoneRegionFlags.H_COMB_OP);
        i = 0;
        int col = 0;
        while (col < gridHeight) {
            int xx = gridX + col * stepY;
            int yy = gridY + col * stepX;
            int row = 0;
            while (row < gridWidth) {
                if (!enableSkip || skipBitmap.getPixel(col, row) != 1) {
                    JBIG2Bitmap patternBitmap = patternDictionarySegment.getBitmaps()[grayScaleImage[i]];
                    bitmap.combine(patternBitmap, xx >> 8, yy >> 8, combinationOperator);
                }
                xx += stepX;
                yy -= stepY;
                ++i;
                ++row;
            }
            ++col;
        }
        if (this.inlineImage) {
            PageInformationSegment pageSegment = this.decoder.findPageSegement(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap pageBitmap = pageSegment.getPageBitmap();
            int externalCombinationOperator = this.regionFlags.getFlagValue(RegionFlags.EXTERNAL_COMBINATION_OPERATOR);
            pageBitmap.combine(bitmap, this.regionBitmapXLocation, this.regionBitmapYLocation, externalCombinationOperator);
        } else {
            bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(bitmap);
        }
    }

    private void readHalftoneRegionFlags() throws IOException {
        short halftoneRegionFlagsField = this.decoder.readByte();
        this.halftoneRegionFlags.setFlags(halftoneRegionFlagsField);
        if (JBIG2StreamDecoder.debug) {
            System.out.println("generic region Segment flags = " + halftoneRegionFlagsField);
        }
    }

    public HalftoneRegionFlags getHalftoneRegionFlags() {
        return this.halftoneRegionFlags;
    }
}

