/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.rendering;

import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.CSBasicDevice;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.pd.PDCSPattern;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontFactory;
import de.intarsys.pdf.platform.cwt.image.PlatformImageFactory;
import de.intarsys.pdf.platform.cwt.paint.ColorPaint;
import de.intarsys.pdf.platform.cwt.paint.PatternPaint;
import de.intarsys.pdf.platform.cwt.paint.ShadingPaint;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.geometry.ShapeTools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Map;

public class CSPlatformDevice
extends CSBasicDevice
implements ICSPlatformDevice {
    protected static final Attribute ATTR_DEVICECLIP = new Attribute("deviceClip");
    protected static final Attribute ATTR_DEVICETRANSFORM = new Attribute("deviceTransform");
    protected static final Attribute ATTR_NONSTROKEPAINT = new Attribute("nonStrokePaint");
    protected static final Attribute ATTR_STROKEPAINT = new Attribute("strokePaint");
    private boolean applyLineAttributes = true;
    private boolean applyPaint = true;
    private IGraphicsContext graphicsContext;
    private Shape textClip;
    private AffineTransform userSpace;

    public CSPlatformDevice(IGraphicsContext iGraphicsContext) {
        this.graphicsContext = iGraphicsContext;
    }

    @Override
    public void addTextClip(Shape shape) {
        Shape shape2 = this.graphicsContext.getTransform().createTransformedShape(shape);
        if (this.textClip == null) {
            this.textClip = shape2;
        } else {
            Area area = this.textClip instanceof Area ? (Area)this.textClip : new Area(this.textClip);
            area.add(new Area(shape2));
            this.textClip = area;
        }
    }

    protected void applyLineAttributes() {
        if (this.applyLineAttributes) {
            BasicStroke basicStroke = null;
            basicStroke = this.graphicsState.dashPattern.length == 0 ? new BasicStroke(this.graphicsState.lineWidth, this.getGSDeviceCapStyle(this.graphicsState), this.getGSDeviceJoinStyle(this.graphicsState), this.graphicsState.miterLimit) : new BasicStroke(this.graphicsState.lineWidth, this.getGSDeviceCapStyle(this.graphicsState), this.getGSDeviceJoinStyle(this.graphicsState), this.graphicsState.miterLimit, this.graphicsState.dashPattern, this.graphicsState.dashPhase);
            this.graphicsContext.setStroke((Stroke)basicStroke);
            this.applyLineAttributes = false;
        }
    }

    protected void applyPaint() {
        if (this.applyPaint) {
            this.graphicsContext.setBackgroundPaint(this.preparePaint(this.getGSNonStrokePaint(this.graphicsState)));
            this.graphicsContext.setForegroundPaint(this.preparePaint(this.getGSStrokePaint(this.graphicsState)));
            this.applyPaint = false;
        }
    }

    protected void basicClip(Shape shape) {
        this.graphicsContext.clip(shape);
    }

    protected void basicDraw(Shape shape) {
        this.applyLineAttributes();
        this.applyPaint();
        this.graphicsContext.draw(shape);
    }

    protected void basicFill(Shape shape) {
        this.applyPaint();
        IPaint iPaint = this.getGSNonStrokePaint(this.graphicsState);
        if (iPaint instanceof PatternPaint) {
            PDPattern pDPattern = ((PatternPaint)iPaint).getPdPattern();
            CDSMatrix cDSMatrix = pDPattern.getMatrix();
            if (cDSMatrix == null) {
                this.graphicsContext.fill(shape);
            } else {
                AffineTransform affineTransform = cDSMatrix.toTransform();
                try {
                    AffineTransform affineTransform2 = affineTransform.createInverse();
                    AffineTransform affineTransform3 = this.graphicsContext.getTransform();
                    this.graphicsContext.transform(affineTransform);
                    try {
                        Shape shape2 = affineTransform2.createTransformedShape(shape);
                        this.graphicsContext.fill(shape2);
                    }
                    finally {
                        this.graphicsContext.setTransform(affineTransform3);
                    }
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    this.graphicsContext.fill(shape);
                }
            }
        } else {
            Area area = ShapeTools.createArea((Shape)this.graphicsContext.getClip(), (boolean)false);
            if (area == null || area.isRectangular()) {
                this.graphicsContext.fill(shape);
            } else {
                this.graphicsContext.setClip(null);
                try {
                    Area area2 = ShapeTools.createArea((Shape)shape, (boolean)false);
                    area2.intersect(area);
                    this.graphicsContext.fill((Shape)area2);
                }
                finally {
                    this.graphicsContext.setClip((Shape)area);
                }
            }
        }
    }

    protected void basicFillDegenerated(Shape shape) {
        this.graphicsContext.setStroke((Stroke)new BasicStroke(0.0f));
        this.applyLineAttributes = true;
        this.graphicsContext.setForegroundColor(this.graphicsContext.getBackgroundColor());
        this.applyPaint = true;
        this.graphicsContext.draw(shape);
    }

    protected void basicSetNonStrokeColorSpace(PDColorSpace pDColorSpace) {
        super.basicSetNonStrokeColorSpace(pDColorSpace);
        this.applyPaint = true;
        if (pDColorSpace instanceof PDCSPattern) {
            this.setGSNonStrokePaint(this.graphicsState, new PatternPaint());
        } else {
            this.setGSNonStrokePaint(this.graphicsState, new ColorPaint(pDColorSpace));
        }
    }

    protected void basicSetNonStrokeColorValues(float[] fArray) {
        super.basicSetNonStrokeColorValues(fArray);
        this.applyPaint = true;
        ((ColorPaint)this.getGSNonStrokePaint(this.graphicsState)).setColorValues(fArray);
    }

    protected void basicSetStrokeColorSpace(PDColorSpace pDColorSpace) {
        super.basicSetStrokeColorSpace(pDColorSpace);
        this.applyPaint = true;
        if (pDColorSpace instanceof PDCSPattern) {
            this.setGSStrokePaint(this.graphicsState, new PatternPaint());
        } else {
            this.setGSStrokePaint(this.graphicsState, new ColorPaint(pDColorSpace));
        }
    }

    protected void basicSetStrokeColorValues(float[] fArray) {
        super.basicSetStrokeColorValues(fArray);
        this.applyPaint = true;
        ((ColorPaint)this.getGSStrokePaint(this.graphicsState)).setColorValues(fArray);
    }

    protected void basicTextShowGlyphs(PDGlyphs pDGlyphs, float f) throws CSException {
        if (this.textState.fontSize != 0.0f) {
            try {
                IPlatformFont iPlatformFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
                IPlatformGlyphs iPlatformGlyphs = iPlatformFont.createPlatformGlyphs(pDGlyphs);
                iPlatformGlyphs.render(this);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.basicTextShowGlyphs(pDGlyphs, f);
    }

    protected void doImage(COSName cOSName, PDImage pDImage) throws CSException {
        Object object;
        double d = pDImage.getWidth();
        double d2 = pDImage.getHeight();
        AffineTransform affineTransform = this.graphicsContext.getTransform();
        double[] dArray = new double[]{d, d2};
        affineTransform.deltaTransform(dArray, 0, dArray, 0, 1);
        dArray[0] = Math.abs(dArray[0]);
        dArray[1] = Math.abs(dArray[1]);
        if (dArray[0] < 1.0) {
            d = dArray[0];
        }
        if (dArray[1] < 1.0) {
            d2 = dArray[1];
        }
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(0.0, 1.0);
        affineTransform2.scale(1.0 / d, -1.0 / d2);
        this.graphicsContext.transform(affineTransform2);
        Object object2 = null;
        if (!pDImage.isInterpolate() && this.graphicsContext.getTransform().getDeterminant() >= 1.0) {
            object = this.graphicsContext.getRenderingHints();
            object2 = ((RenderingHints)object).remove(RenderingHints.KEY_INTERPOLATION);
            this.graphicsContext.setRenderingHints((Map)object);
        }
        try {
            try {
                this.applyPaint();
                object = PlatformImageFactory.get().createPlatformImage(pDImage);
                object.doImage(this);
            }
            catch (Exception exception) {
                this.graphicsContext.setForegroundColor(Color.DARK_GRAY);
                this.graphicsContext.draw((Shape)new Line2D.Double(0.0, 0.0, pDImage.getWidth(), pDImage.getHeight()));
                this.graphicsContext.draw((Shape)new Line2D.Double(pDImage.getWidth(), 0.0, 0.0, pDImage.getHeight()));
                throw new CSError("Image can't be rendered (" + exception.getLocalizedMessage() + ")", (Throwable)exception);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.graphicsContext.setForegroundColor(Color.DARK_GRAY);
                this.graphicsContext.draw((Shape)new Line2D.Double(0.0, 0.0, pDImage.getWidth(), pDImage.getHeight()));
                this.graphicsContext.draw((Shape)new Line2D.Double(pDImage.getWidth(), 0.0, 0.0, pDImage.getHeight()));
                throw new CSError("Image too large", (Throwable)outOfMemoryError);
            }
        }
        catch (Throwable throwable) {
            this.graphicsContext.setTransform(affineTransform);
            if (object2 != null) {
                this.graphicsContext.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
            }
            throw throwable;
        }
        this.graphicsContext.setTransform(affineTransform);
        if (object2 != null) {
            this.graphicsContext.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
        }
    }

    public void doShading(COSName cOSName, PDShading pDShading) {
        if (pDShading == null) {
            return;
        }
        ShadingPaint shadingPaint = new ShadingPaint(pDShading);
        this.graphicsContext.setBackgroundPaint((IPaint)shadingPaint);
        if (pDShading.getBoundingBox() == null) {
            Shape shape = this.graphicsContext.getClip();
            if (shape != null) {
                this.graphicsContext.fill(shape);
            }
        } else {
            this.graphicsContext.fill((Shape)pDShading.getBoundingBox().toNormalizedRectangle());
        }
        this.applyPaint = true;
    }

    @Override
    public IGraphicsContext getGraphicsContext() {
        return this.graphicsContext;
    }

    private final BlendMode getGSDeviceBlendMode(GraphicsState graphicsState) {
        if (graphicsState.extState == null) {
            return (BlendMode)BlendMode.META.getDefault();
        }
        if (graphicsState.extState.isBlendModeNormal()) {
            return BlendMode.NORMAL;
        }
        if (graphicsState.extState.isBlendModeMultiply()) {
            return BlendMode.MULTIPLY;
        }
        return (BlendMode)BlendMode.META.getDefault();
    }

    private final int getGSDeviceCapStyle(GraphicsState graphicsState) {
        switch (graphicsState.capStyle) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private final Shape getGSDeviceClip(GraphicsState graphicsState) {
        return (Shape)graphicsState.getAttribute((Object)ATTR_DEVICECLIP);
    }

    private final int getGSDeviceJoinStyle(GraphicsState graphicsState) {
        switch (graphicsState.joinStyle) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    private final AffineTransform getGSDeviceTransform(GraphicsState graphicsState) {
        return (AffineTransform)graphicsState.getAttribute((Object)ATTR_DEVICETRANSFORM);
    }

    private final IPaint getGSNonStrokePaint(GraphicsState graphicsState) {
        return (IPaint)graphicsState.getAttribute((Object)ATTR_NONSTROKEPAINT);
    }

    private final IPaint getGSStrokePaint(GraphicsState graphicsState) {
        return (IPaint)graphicsState.getAttribute((Object)ATTR_STROKEPAINT);
    }

    protected GraphicsState graphicsStateCopy(GraphicsState graphicsState) {
        GraphicsState graphicsState2 = super.graphicsStateCopy(graphicsState);
        this.setGSStrokePaint(graphicsState2, this.getGSStrokePaint(graphicsState).copy());
        this.setGSNonStrokePaint(graphicsState2, this.getGSNonStrokePaint(graphicsState).copy());
        if (this.textState.font != null) {
            try {
                IPlatformFont iPlatformFont = PlatformFontFactory.get().createPlatformFont(graphicsState.textState.font);
                iPlatformFont.saveState(this, graphicsState, graphicsState2);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        return graphicsState2;
    }

    public void inlineImage(PDImage pDImage) {
        this.doImage(null, pDImage);
    }

    protected IPaint preparePaint(IPaint iPaint) {
        BlendMode blendMode = this.getGSDeviceBlendMode(this.graphicsState);
        if (blendMode == BlendMode.MULTIPLY) {
            ColorPaint colorPaint;
            float[] fArray;
            float f = 0.5f;
            if (iPaint instanceof ColorPaint && (fArray = (colorPaint = (ColorPaint)iPaint).getColorValues()) != null) {
                float f2 = 0.0f;
                int n = 0;
                while (n < fArray.length) {
                    f2 += fArray[n];
                    ++n;
                }
                f = 1.0f - (f2 /= (float)fArray.length);
            }
            iPaint = iPaint.copy();
            iPaint.setAlphaValue(iPaint.getAlphaValue() * f);
        }
        return iPaint;
    }

    public void restoreState() {
        super.restoreState();
        this.graphicsContext.setTransform(this.getGSDeviceTransform(this.graphicsState));
        this.graphicsContext.setClip(this.getGSDeviceClip(this.graphicsState));
        this.applyLineAttributes = true;
        this.applyPaint = true;
    }

    public void saveState() {
        this.setGSDeviceTransform(this.graphicsState, this.graphicsContext.getTransform());
        this.setGSDeviceClip(this.graphicsState, this.graphicsContext.getClip());
        super.saveState();
    }

    public void setExtendedState(COSName cOSName, PDExtGState pDExtGState) {
        float f = this.graphicsState.strokeAlphaValue;
        float f2 = this.graphicsState.nonStrokeAlphaValue;
        super.setExtendedState(cOSName, pDExtGState);
        this.applyLineAttributes = true;
        if (f != this.graphicsState.strokeAlphaValue || f2 != this.graphicsState.nonStrokeAlphaValue) {
            this.getGSNonStrokePaint(this.graphicsState).setAlphaValue(this.graphicsState.nonStrokeAlphaValue);
            this.getGSStrokePaint(this.graphicsState).setAlphaValue(this.graphicsState.strokeAlphaValue);
            this.applyPaint = true;
        }
    }

    private final void setGSDeviceClip(GraphicsState graphicsState, Shape shape) {
        graphicsState.setAttribute((Object)ATTR_DEVICECLIP, (Object)shape);
    }

    private final void setGSDeviceTransform(GraphicsState graphicsState, AffineTransform affineTransform) {
        graphicsState.setAttribute((Object)ATTR_DEVICETRANSFORM, (Object)affineTransform);
    }

    private final void setGSNonStrokePaint(GraphicsState graphicsState, IPaint iPaint) {
        iPaint.setAlphaValue(graphicsState.nonStrokeAlphaValue);
        graphicsState.setAttribute((Object)ATTR_NONSTROKEPAINT, (Object)iPaint);
    }

    private final void setGSStrokePaint(GraphicsState graphicsState, IPaint iPaint) {
        iPaint.setAlphaValue(graphicsState.strokeAlphaValue);
        graphicsState.setAttribute((Object)ATTR_STROKEPAINT, (Object)iPaint);
    }

    public void setLineCap(int n) {
        super.setLineCap(n);
        this.applyLineAttributes = true;
    }

    public void setLineDash(float[] fArray, float f) {
        super.setLineDash(fArray, f);
        this.applyLineAttributes = true;
    }

    public void setLineJoin(int n) {
        super.setLineJoin(n);
        this.applyLineAttributes = true;
    }

    public void setLineWidth(float f) {
        super.setLineWidth(f);
        this.applyLineAttributes = true;
    }

    public void setMiterLimit(float f) {
        super.setMiterLimit(f);
        this.applyLineAttributes = true;
    }

    public void setNonStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
        this.applyPaint = true;
        ((PatternPaint)this.getGSNonStrokePaint(this.graphicsState)).setPatternValues(fArray, pDPattern);
    }

    public void setStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
        this.applyPaint = true;
        ((PatternPaint)this.getGSStrokePaint(this.graphicsState)).setPatternValues(fArray, pDPattern);
    }

    public void textBegin() {
        this.userSpace = this.graphicsContext.getTransform();
        super.textBegin();
        if (this.textState.font != null) {
            try {
                IPlatformFont iPlatformFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
                iPlatformFont.textStateChanged(this);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
    }

    public void textEnd() {
        super.textEnd();
        if (this.textState.font != null) {
            try {
                IPlatformFont iPlatformFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
                iPlatformFont.textStateChanged(this);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        if (this.textClip != null) {
            this.graphicsContext.setTransform(new AffineTransform());
            this.basicClip(this.textClip);
            this.textClip = null;
        }
        this.graphicsContext.setTransform(this.userSpace);
    }

    public void textLineMove(float f, float f2) {
        super.textLineMove(f, f2);
        this.graphicsContext.setTransform(this.userSpace);
        this.graphicsContext.transform(this.textState.transform);
    }

    public void textLineNew() {
        super.textLineNew();
        this.graphicsContext.setTransform(this.userSpace);
        this.graphicsContext.transform(this.textState.transform);
    }

    public void textMove(float f, float f2) {
        super.textMove(f, f2);
        this.graphicsContext.translate(f, f2);
    }

    public void textSetFont(COSName cOSName, PDFont pDFont, float f) {
        IPlatformFont iPlatformFont = null;
        if (this.textState.font != null) {
            try {
                iPlatformFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetFont(cOSName, pDFont, f);
        if (iPlatformFont != null) {
            iPlatformFont.textStateChanged(this);
        }
        try {
            iPlatformFont = PlatformFontFactory.get().createPlatformFont(pDFont);
            iPlatformFont.textStateChanged(this);
        }
        catch (PlatformFontException platformFontException) {
            // empty catch block
        }
    }

    public void textSetHorizontalScaling(float f) {
        IPlatformFont iPlatformFont = null;
        if (this.textState.font != null) {
            try {
                iPlatformFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetHorizontalScaling(f);
        if (iPlatformFont != null) {
            iPlatformFont.textStateChanged(this);
        }
    }

    public void textSetRenderingMode(int n) {
        IPlatformFont iPlatformFont = null;
        if (this.textState.font != null) {
            try {
                iPlatformFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetRenderingMode(n);
        if (iPlatformFont != null) {
            iPlatformFont.textStateChanged(this);
        }
    }

    public void textSetRise(float f) {
        IPlatformFont iPlatformFont = null;
        if (this.textState.font != null) {
            try {
                iPlatformFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetRise(f);
        if (iPlatformFont != null) {
            iPlatformFont.textStateChanged(this);
        }
    }

    public void textSetTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        IPlatformFont iPlatformFont = null;
        if (this.textState.font != null) {
            try {
                iPlatformFont = PlatformFontFactory.get().createPlatformFont(this.textState.font);
            }
            catch (PlatformFontException platformFontException) {
                // empty catch block
            }
        }
        super.textSetTransform(f, f2, f3, f4, f5, f6);
        this.graphicsContext.setTransform(this.userSpace);
        this.graphicsContext.transform(this.textState.transform);
        if (iPlatformFont != null) {
            iPlatformFont.textStateChanged(this);
        }
    }

    public void textShow(byte[] byArray, int n, int n2) {
        this.applyLineAttributes();
        this.applyPaint();
        super.textShow(byArray, n, n2);
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6) {
        super.transform(f, f2, f3, f4, f5, f6);
        this.graphicsContext.transform(new AffineTransform(f, f2, f3, f4, f5, f6));
    }
}

