/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.dnd.handlers;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.commons.business.loaders.PdfThumbnailsLoader;
import org.pdfsam.guiclient.commons.components.JVisualSelectionList;
import org.pdfsam.guiclient.commons.dnd.DnDSupportUtility;
import org.pdfsam.guiclient.commons.dnd.handlers.VisualListExportTransferHandler;
import org.pdfsam.guiclient.commons.dnd.transferables.VisualPageListTransferable;
import org.pdfsam.guiclient.commons.models.VisualListModel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.i18n.GettextResource;

public class VisualListTransferHandler
extends VisualListExportTransferHandler {
    private static final long serialVersionUID = -6893213515673375373L;
    private static final Logger log = Logger.getLogger(VisualListTransferHandler.class.getPackage().getName());
    private int addIndex = 0;

    public VisualListTransferHandler() {
    }

    public VisualListTransferHandler(PdfThumbnailsLoader loader) {
        super(loader);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (action == 2) {
            try {
                JVisualSelectionList listComponent = (JVisualSelectionList)source;
                VisualPageListTransferable.TransferableData transferredData = (VisualPageListTransferable.TransferableData)data.getTransferData(DnDSupportUtility.VISUAL_LIST_FLAVOR);
                if (transferredData != null && transferredData.getIndexesList() != null) {
                    int[] dataList = transferredData.getIndexesList();
                    int delta = dataList[0] > this.addIndex ? dataList.length : 0;
                    ((VisualListModel)listComponent.getModel()).removeElements(dataList[0] + delta, dataList[dataList.length - 1] + delta, true);
                }
                this.addIndex = 0;
            }
            catch (Exception e) {
                log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error during drag and drop."), e);
            }
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        boolean retVal = false;
        if (info.isDrop()) {
            try {
                Transferable t = info.getTransferable();
                if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || t.isDataFlavorSupported(DnDSupportUtility.URI_LIST_FLAVOR)) {
                    retVal = super.importData(info);
                } else if (t.isDataFlavorSupported(DnDSupportUtility.VISUAL_LIST_FLAVOR)) {
                    retVal = this.importVisualListItems(info);
                }
            }
            catch (Exception e) {
                log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error during drag and drop."), e);
            }
        }
        return retVal;
    }

    private boolean importVisualListItems(TransferHandler.TransferSupport info) {
        boolean retVal = false;
        Transferable transferable = info.getTransferable();
        try {
            JList.DropLocation dropLocation = (JList.DropLocation)info.getDropLocation();
            int index = dropLocation.getIndex();
            VisualListModel destModel = (VisualListModel)((JVisualSelectionList)info.getComponent()).getModel();
            VisualPageListTransferable.TransferableData transferredData = (VisualPageListTransferable.TransferableData)transferable.getTransferData(DnDSupportUtility.VISUAL_LIST_FLAVOR);
            if (transferredData != null) {
                VisualPageListItem[] dataList = transferredData.getDataList();
                if (dataList != null && dataList.length > 0) {
                    int listSize;
                    this.addIndex = index == -1 ? destModel.getSize() : (index > (listSize = destModel.getSize()) || index < 0 ? listSize : index);
                    retVal = true;
                }
                if (retVal) {
                    List<VisualPageListItem> items = Arrays.asList(dataList);
                    if (info.getSourceDropActions() == 1) {
                        Vector<VisualPageListItem> newList = new Vector<VisualPageListItem>(items.size());
                        for (VisualPageListItem currItem : items) {
                            newList.add((VisualPageListItem)currItem.clone());
                        }
                        items = newList;
                    }
                    destModel.addAllElements(this.addIndex, items);
                }
            }
        }
        catch (Exception e) {
            retVal = false;
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error during drag and drop."), e);
        }
        return retVal;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        boolean retVal = false;
        if (super.canImport(info)) {
            retVal = true;
        } else if (info.getComponent() instanceof JVisualSelectionList) {
            if (info.isDataFlavorSupported(DnDSupportUtility.VISUAL_LIST_FLAVOR)) {
                if (info.getSourceDropActions() == 2) {
                    try {
                        VisualPageListTransferable.TransferableData transferredData = (VisualPageListTransferable.TransferableData)info.getTransferable().getTransferData(DnDSupportUtility.VISUAL_LIST_FLAVOR);
                        JList.DropLocation dropLocation = (JList.DropLocation)info.getDropLocation();
                        int index = dropLocation.getIndex();
                        if (transferredData != null) {
                            int[] indices = transferredData.getIndexesList();
                            retVal = indices == null || index < indices[0] || index > indices[indices.length - 1] + 1;
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                        retVal = false;
                    }
                    catch (IOException e) {
                        retVal = false;
                    }
                } else {
                    retVal = true;
                }
            } else {
                retVal = false;
            }
        }
        return retVal;
    }
}

