/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RunLengthOutputStream
extends FilterOutputStream {
    private byte[] buffer = new byte[128];
    private int pos = 0;
    private int count = 0;
    private int last = -1;

    public RunLengthOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    @Override
    public void close() throws IOException {
        if (this.last != -1) {
            this.push(-1);
        }
        this.flushBuffer();
        this.flushCopies();
        this.out.write(-128);
        super.close();
    }

    protected void flushBuffer() throws IOException {
        if (this.pos > 0) {
            this.out.write((byte)(257 - this.pos));
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }
    }

    protected void flushCopies() throws IOException {
        if (this.count > 1) {
            this.out.write((byte)this.count - 1);
            this.out.write((byte)this.last);
            this.count = 0;
            this.last = -1;
        }
    }

    protected void push(int n) throws IOException {
        if (n == this.last) {
            this.flushBuffer();
            ++this.count;
            if (this.count == 128) {
                this.flushCopies();
            }
        } else {
            this.flushCopies();
            this.buffer[this.pos++] = (byte)this.last;
            if (this.pos == 128) {
                this.flushBuffer();
            }
            this.count = 1;
            this.last = n;
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.last != -1) {
            this.push(n);
        } else {
            this.count = 1;
            this.last = n;
        }
    }
}

