/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

public class PDFontStyle {
    public static final int COUNT = 4;
    public static final PDFontStyle UNDEFINED = new PDFontStyle("?", -1);
    public static final PDFontStyle REGULAR = new PDFontStyle("Regular", 0);
    public static final PDFontStyle ITALIC = new PDFontStyle("Italic", 1);
    public static final PDFontStyle BOLD = new PDFontStyle("Bold", 2);
    public static final PDFontStyle BOLD_ITALIC = new PDFontStyle("BoldItalic", 3);
    private final String label;
    private final int index;

    public static PDFontStyle getFontStyle(String string) {
        if (string == null) {
            return REGULAR;
        }
        string = string.trim().toLowerCase();
        boolean bl = false;
        boolean bl2 = false;
        if (string.indexOf("bold") >= 0) {
            bl = true;
        }
        if (string.indexOf("italic") >= 0) {
            bl2 = true;
        }
        if (string.indexOf("oblique") >= 0) {
            bl2 = true;
        }
        if (bl) {
            if (bl2) {
                return BOLD_ITALIC;
            }
            return BOLD;
        }
        if (bl2) {
            return ITALIC;
        }
        return REGULAR;
    }

    private PDFontStyle(String string, int n) {
        this.label = string;
        this.index = n;
    }

    public PDFontStyle getBoldFlavor() {
        if (this == ITALIC) {
            return BOLD_ITALIC;
        }
        return BOLD;
    }

    protected int getIndex() {
        return this.index;
    }

    public PDFontStyle getItalicFlavor() {
        if (this == BOLD) {
            return BOLD_ITALIC;
        }
        return ITALIC;
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getLabel();
    }
}

