/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDFunction;

public class PDStitchingFunction
extends PDFunction {
    private static final COSName DK_Bounds = COSName.constant("Bounds");
    private static final COSName DK_Encode = COSName.constant("Encode");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private static final COSName DK_Functions = COSName.constant("Functions");
    private float[] bounds;
    private float[] encode;
    private PDFunction[] functions;

    protected PDStitchingFunction(COSObject cOSObject) {
        super(cOSObject);
        COSArray cOSArray = cOSObject.asDictionary().get(DK_Bounds).asArray();
        this.bounds = new float[cOSArray.size()];
        int n = 0;
        while (n < cOSArray.size()) {
            this.bounds[n] = ((COSNumber)cOSArray.get(n)).floatValue();
            ++n;
        }
        COSArray cOSArray2 = cOSObject.asDictionary().get(DK_Encode).asArray();
        this.encode = new float[cOSArray2.size()];
        n = 0;
        while (n < cOSArray2.size()) {
            this.encode[n] = ((COSNumber)cOSArray2.get(n)).floatValue();
            ++n;
        }
    }

    @Override
    public float[] evaluate(float[] fArray) {
        int n = 0;
        while (n < this.bounds.length) {
            if (fArray[0] < this.bounds[n]) {
                return this.getFunctions()[n].evaluate(fArray);
            }
            ++n;
        }
        return this.getFunctions()[n].evaluate(fArray);
    }

    public float[] getBounds() {
        return this.bounds;
    }

    public float[] getEncode() {
        return this.encode;
    }

    public PDFunction[] getFunctions() {
        if (this.functions == null) {
            COSArray cOSArray = this.cosGetObject().asDictionary().get(DK_Functions).asArray();
            this.functions = new PDFunction[cOSArray.size()];
            int n = 0;
            while (n < cOSArray.size()) {
                this.functions[n] = (PDFunction)PDFunction.META.createFromCos(cOSArray.get(n));
                ++n;
            }
        }
        return this.functions;
    }

    @Override
    public int getOutputSize() {
        return this.getRange().size() / 2;
    }

    public static class MetaClass
    extends PDFunction.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDStitchingFunction(cOSObject);
        }
    }
}

