/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.ICryptdec;
import de.intarsys.tools.exception.ExceptionTools;
import java.io.IOException;
import java.util.Arrays;
import javax.crypto.Cipher;

public abstract class Cryptdec
implements ICryptdec {
    private final String id;
    private byte[] initializationVector;
    private Cipher ecipher;
    private Cipher dcipher;

    public Cryptdec(String string, byte[] byArray) {
        this.id = string;
        this.initializationVector = Arrays.copyOf(byArray, byArray.length);
    }

    @Override
    public byte[] decrypt(byte[] byArray) throws IOException {
        try {
            return this.dcipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw ExceptionTools.createIOException(exception.getMessage(), exception);
        }
    }

    @Override
    public byte[] encrypt(byte[] byArray) throws IOException {
        try {
            return this.ecipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw ExceptionTools.createIOException(exception.getMessage(), exception);
        }
    }

    protected Cipher getDcipher() {
        return this.dcipher;
    }

    protected Cipher getEcipher() {
        return this.ecipher;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public byte[] getInitializationVector() {
        return this.initializationVector;
    }

    protected void setDcipher(Cipher cipher) {
        this.dcipher = cipher;
    }

    protected void setEcipher(Cipher cipher) {
        this.ecipher = cipher;
    }

    protected void setInitializationVector(byte[] byArray) {
        this.initializationVector = byArray;
    }
}

