/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Font;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import org.freehep.graphicsio.font.encoding.CharTable;
import org.freehep.graphicsio.font.encoding.Lookup;

public abstract class FontTable {
    private Hashtable table = new Hashtable();

    public abstract CharTable getEncodingTable();

    protected abstract void firstRequest(Entry var1, boolean var2, String var3) throws IOException;

    protected abstract String createFontReference(Font var1);

    protected abstract Font substituteFont(Font var1);

    public String fontReference(Font font, boolean embed, String embedAs) {
        String key = (font = this.substituteFont(font)).getName() + (font.isBold() ? "[bold]" : "") + (font.isItalic() ? "[italic]" : "");
        Entry e = (Entry)this.table.get(key);
        if (e != null) {
            return e.ref;
        }
        e = new Entry(font, this.getEncodingTable(font));
        try {
            this.firstRequest(e, embed, embedAs);
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        this.table.put(key, e);
        return e.ref;
    }

    public Collection getEntries() {
        return this.table.values();
    }

    private CharTable getEncodingTable(Font font) {
        String fontname = font.getName().toLowerCase();
        if (fontname.indexOf("symbol") >= 0) {
            return Lookup.getInstance().getTable("Symbol");
        }
        if (fontname.indexOf("zapfdingbats") >= 0) {
            return Lookup.getInstance().getTable("Zapfdingbats");
        }
        return this.getEncodingTable();
    }

    protected class Entry {
        private Font font;
        private String ref;
        private CharTable encoding;
        private boolean written;

        private Entry(Font f, CharTable encoding) {
            this.font = f.deriveFont(1000.0f);
            this.ref = FontTable.this.createFontReference(f);
            this.encoding = encoding;
            this.written = false;
        }

        public Font getFont() {
            return this.font;
        }

        public String getReference() {
            return this.ref;
        }

        protected void setReference(String ref) {
            this.ref = ref;
        }

        public CharTable getEncoding() {
            return this.encoding;
        }

        public void setWritten(boolean written) {
            this.written = written;
        }

        public boolean isWritten() {
            return this.written;
        }

        public String toString() {
            return this.ref + "=" + this.font;
        }
    }
}

