/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.control.basics.geom.DimensionDouble;
import com.baselet.control.enums.ElementStyle;
import com.baselet.element.NewGridElement;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PropertiesParser {
    public static void parsePropertiesAndHandleFacets(NewGridElement newGridElement, PropertiesParserState propertiesParserState) {
        List<String> list = newGridElement.getPanelAttributesAsList();
        PropertiesParser.doPreparsing(newGridElement, propertiesParserState, list);
        PropertiesParser.parseFacets(newGridElement, propertiesParserState, list, true);
    }

    private static void doPreparsing(NewGridElement newGridElement, PropertiesParserState propertiesParserState, List<String> list) {
        double d;
        propertiesParserState.resetValues(newGridElement.getRealSize(), propertiesParserState.getTotalTextBlockHeight(), false);
        PropertiesParser.parseFacets(newGridElement, propertiesParserState, list, false);
        if (propertiesParserState.getElementStyle() == ElementStyle.AUTORESIZE) {
            d = propertiesParserState.getCalculatedElementWidth();
            double d2 = propertiesParserState.getTextPrintPosition() - propertiesParserState.getDrawer().textHeightMax();
            newGridElement.handleAutoresize(new DimensionDouble(d, d2), propertiesParserState.getAlignment().getHorizontal());
        }
        d = propertiesParserState.getTextPrintPosition() - propertiesParserState.getBuffer().getTop();
        propertiesParserState.resetValues(newGridElement.getRealSize(), d, true);
    }

    private static void parseFacets(NewGridElement newGridElement, PropertiesParserState propertiesParserState, List<String> list, boolean bl) {
        List<String> list2 = PropertiesParser.parseFacets(propertiesParserState.getSettings().getFacetsForFirstRun(), list, propertiesParserState);
        newGridElement.resetMetaDrawerAndDrawCommonContent(propertiesParserState, bl);
        PropertiesParser.parseFacets(propertiesParserState.getSettings().getFacetsForSecondRun(), list2, propertiesParserState);
    }

    private static List<String> parseFacets(List<? extends Facet> list, List<String> list2, PropertiesParserState propertiesParserState) {
        HashMap hashMap = new HashMap();
        for (Facet iterator2 : list) {
            hashMap.put(iterator2, new ArrayList());
        }
        ArrayList<String> arrayList = new ArrayList<String>(list2);
        Iterator iterator = arrayList.iterator();
        block1: while (iterator.hasNext()) {
            String string = (String)iterator.next();
            for (Facet facet : list) {
                if (!facet.checkStart(string, propertiesParserState)) continue;
                facet.handleLine(string, propertiesParserState);
                ((List)hashMap.get(facet)).add(string);
                iterator.remove();
                continue block1;
            }
        }
        for (Facet facet : list) {
            facet.parsingFinished(propertiesParserState, (List)hashMap.get(facet));
        }
        return arrayList;
    }
}

