/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.parser;

import com.baselet.element.elementnew.plot.parser.DataSet;
import com.baselet.element.elementnew.plot.parser.KeyValue;
import com.baselet.element.elementnew.plot.parser.ParserException;
import com.baselet.element.elementnew.plot.parser.ParserResult;
import com.baselet.element.elementnew.plot.parser.PlotState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class Parser {
    private static final Logger log = Logger.getLogger(Parser.class);
    private final ParserResult parserResult = new ParserResult();
    private final HashMap<String, KeyValue> tempPlotValuesCache;
    private int datasetNr = 1;
    private final ArrayList<DataSet> datasetList = new ArrayList();

    public Parser() {
        this.tempPlotValuesCache = new HashMap();
    }

    public ParserResult parse(String string) {
        List<String> list = Arrays.asList(string.split("\n", -1));
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string2 = listIterator.next();
            if (string2.isEmpty() || string2.matches("(//.*)")) continue;
            if (string2.matches("((plot ?)|(plot ((([(\\w)\\.]+)=([-(\\w)#\\.,]*)) )*(([(\\w)\\.]+)=([-(\\w)#\\.,]*))))")) {
                this.parserResult.addPlotState(this.createPlotStateObject(string2.split(" "), listIterator));
                continue;
            }
            if (string2.matches("(\\+((plot ?)|(plot ((([(\\w)\\.]+)=([-(\\w)#\\.,]*)) )*(([(\\w)\\.]+)=([-(\\w)#\\.,]*)))))")) {
                ArrayList<PlotState> arrayList = this.parserResult.getPlotStateList();
                if (arrayList.isEmpty()) {
                    this.parserResult.addPlotState(this.createPlotStateObject(string2.split(" "), listIterator));
                    continue;
                }
                PlotState plotState = (PlotState)arrayList.get(arrayList.size() - 1);
                plotState.addSubPlot(this.createPlotStateObject(string2.split(" "), listIterator));
                continue;
            }
            if (string2.matches("((data ?)|(data (\\w)+))")) {
                this.createDatasetObject(string2.split(" "), listIterator);
                continue;
            }
            if (string2.matches("((?!((//.*)))(([^=]+)|(.*([\t ]+).*)))")) {
                listIterator.previous();
                this.createDatasetObject(new String[]{"data"}, listIterator);
                continue;
            }
            if (string2.matches("(([(\\w)\\.]+)=([-(\\w)#\\.,]*))")) {
                this.createKeyValueAssignment(string2, listIterator.nextIndex());
                continue;
            }
            throw new ParserException("Invalid line: " + string2 + "(line: " + listIterator.nextIndex() + ")");
        }
        this.analyseDatasets();
        this.addDatasetsToPlotStates();
        return this.parserResult;
    }

    private void analyseDatasets() {
        for (DataSet dataSet : this.datasetList) {
            dataSet.analyseMatrix();
        }
    }

    private void addDatasetsToPlotStates() {
        if (this.datasetList.isEmpty()) {
            throw new ParserException("You must specify at least one dataset.");
        }
        int n = 0;
        for (PlotState plotState : this.parserResult.getPlotStateList()) {
            n = this.addDataset(plotState, n);
            for (PlotState plotState2 : plotState.getSubplots()) {
                log.info((Object)"Add dataset for subplot");
                n = this.addDataset(plotState2, n);
            }
        }
    }

    private int addDataset(PlotState plotState, int n) {
        String string = plotState.getValue("data", null);
        if (string == null) {
            if (n >= this.datasetList.size()) {
                n = 0;
            }
            plotState.setDataSet(this.datasetList.get(n++));
        } else {
            DataSet dataSet = null;
            if (string.startsWith("#")) {
                String string2 = string.substring(1);
                for (DataSet dataSet2 : this.datasetList) {
                    if (!string2.equals(String.valueOf(dataSet2.getNr()))) continue;
                    dataSet = dataSet2;
                }
            } else {
                for (DataSet dataSet3 : this.datasetList) {
                    if (!string.equals(dataSet3.getId())) continue;
                    dataSet = dataSet3;
                }
            }
            if (dataSet != null) {
                plotState.setDataSet(dataSet);
            } else {
                throw new ParserException("data", string, plotState.getLine("data"));
            }
        }
        return n;
    }

    private void createDatasetObject(String[] stringArray, ListIterator<String> listIterator) {
        int n = listIterator.nextIndex();
        String string = null;
        if (stringArray != null && stringArray.length > 1) {
            string = stringArray[1];
        }
        DataSet dataSet = new DataSet(string, this.datasetNr++, n);
        while (listIterator.hasNext()) {
            String string2 = listIterator.next();
            if (string2.matches("(//.*)")) continue;
            if (string2.trim().isEmpty()) break;
            dataSet.addLine(string2.split("([\t ]+)"));
        }
        if (string != null) {
            for (DataSet dataSet2 : this.datasetList) {
                if (!string.equals(dataSet2.getId())) continue;
                throw new ParserException("The dataset name \"" + string + "\" (line: " + n + ") already exists");
            }
        }
        this.datasetList.add(dataSet);
    }

    private PlotState createPlotStateObject(String[] stringArray, ListIterator<String> listIterator) {
        int n = listIterator.nextIndex();
        HashMap<String, KeyValue> hashMap = this.copyHashMap(this.tempPlotValuesCache);
        if (stringArray != null) {
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split("=");
                if (stringArray2.length == 1) {
                    stringArray2 = new String[]{stringArray2[0], ""};
                }
                hashMap.put(stringArray2[0], new KeyValue(stringArray2[0], stringArray2[1], n));
            }
        }
        if (hashMap.get("data") == null) {
            hashMap.put("data", new KeyValue("data", "auto", n));
        }
        PlotState plotState = new PlotState(n, hashMap);
        return plotState;
    }

    private void createKeyValueAssignment(String string, int n) {
        String[] stringArray = string.split("=");
        if (stringArray.length == 1) {
            stringArray = new String[]{stringArray[0], ""};
        }
        if (stringArray[0].matches("grid.width")) {
            this.parserResult.addPlotGridValue(stringArray[0], new KeyValue(stringArray[0], stringArray[1], n));
        } else {
            this.tempPlotValuesCache.put(stringArray[0], new KeyValue(stringArray[0], stringArray[1], n));
        }
    }

    private HashMap<String, KeyValue> copyHashMap(HashMap<String, KeyValue> hashMap) {
        HashMap<String, KeyValue> hashMap2 = new HashMap<String, KeyValue>();
        for (Map.Entry<String, KeyValue> entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), entry.getValue());
        }
        return hashMap2;
    }
}

