/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

@RunWith(value=MockitoJUnitRunner.class)
public class AddOnCollectionUnitTest {
    private static final Path DIRECTORY = Paths.get("test/resources/org/zaproxy/zap/control/", new String[0]);
    private ZapXmlConfiguration configA;
    private ZapXmlConfiguration configB;
    private static final String CONF_A = "<ZAP>\n\t<core>\n\t\t<version>2.0.0</version>\n\t\t<daily-version>D-2012-12-31</daily-version>\n\t\t<daily>\n\t\t\t<url>http://zaproxy.googlecode.com/files/ZAP_WEEKLY_D-2012-12-31.zip</url>\n\t\t\t<file>ZAP_WEEKLY_D-2012-12-31.zip</file>\n\t\t\t<size>58342498</size>\n\t\t</daily>\n\t\t<windows>\n\t\t\t<url>http://zaproxy.googlecode.com/files/ZAP_fake_windows_2.0.0.exe</url>\n\t\t\t<file>ZAP_fake_windows_2.0.0.exe</file>\n\t\t\t<size>56777000</size>\n\t\t</windows>\n\t\t<linux>\n\t\t\t<url>http://zaproxy.googlecode.com/files/ZAP_fake_linux_2.0.0.tar.gzip</url>\n\t\t\t<file>ZAP_fake_linux_2.0.0.tar.gzip</file>\n\t\t\t<size>56776000</size>\n\t\t</linux>\n\t\t<mac>\n\t\t\t<url>http://zaproxy.googlecode.com/files/ZAP_fake_mac_2.0.0.zip</url>\n\t\t\t<file>ZAP_fake_mac_2.0.0.zip</file>\n\t\t\t<size>56775000</size>\n\t\t</mac>\n\t\t<relnotes>\n\t\t\tThis release includes blah, blah, blah\n\t\t\t&lt;p>Including a list:\n\t\t\t\t&lt;ul>\n\t\t\t&lt;li> Item 1\n\t\t\t&lt;li> Item 2\n\t\t\t&lt;li> Item 3&lt;/ul>\n\t\t</relnotes>\n\t\t<relnotes-url>http://zaproxy.googlecode.com/files/fake_release_notes.html</relnotes-url>\n\t</core>\n\t<addon>aaa</addon>\n\t<addon_aaa>\n\t\t<name>This could be a long name</name>\n\t\t<version>1</version>\n\t\t<file>aaa-alpha-1.zap</file>\n\t\t<status>alpha</status>\n\t\t<description>This could be a longer description for aaa</description>\n\t\t<changes>A list of changes for aaa</changes>\n\t\t<url>https://zap-extensions.googlecode.com/files/aaa-alpha-1.zap</url>\n\t\t<size>12345</size>\n\t</addon_aaa>\n\t<addon>bbb</addon>\n\t<addon_bbb>\n\t\t<name>Blah blah blah</name>\n\t\t<version>2</version>\n\t\t<file>bbb-beta-2.zap</file>\n\t\t<status>beta</status>\n\t\t<description>This could be a longer description for bbb</description>\n\t\t<changes>A list of changes for bbb</changes>\n\t\t<url>https://zap-extensions.googlecode.com/files/bbb-beta-2.zap</url>\n\t\t<size>23456</size>\n\t\t<not-before-version>2.4.0</not-before-version>\n\t</addon_bbb>\n\t<addon>ddd</addon>\n\t\t<addon_ddd>\n\t\t<name>Yet another addon</name>\n\t\t<version>3</version>\n\t\t<file>ddd-release-3.zap</file>\n\t\t<status>release</status>\n\t\t<description>This could be a longer description for ddd</description>\n\t\t<changes>A list of changes for ddd</changes>\n\t\t<url>https://zap-extensions.googlecode.com/files/ddd-release-3.zap</url>\n\t\t<size>3456</size>\n\t\t<not-before-version>2.4.0</not-before-version>\n\t</addon_ddd>\n</ZAP>";
    private static final String CONF_B = "<ZAP>\n\t<addon>aaa</addon>\n\t<addon_aaa>\n\t\t<name>This could be a long name</name>\n\t\t<version>1</version>\n\t\t<file>aaa-alpha-1.zap</file>\n\t\t<status>alpha</status>\n\t\t<description>This could be a longer description for aaa</description>\n\t\t<changes>A list of changes for aaa</changes>\n\t\t<url>https://zap-extensions.googlecode.com/files/aaa-alpha-1.zap</url>\n\t\t<size>12345</size>\n\t\t<not-before-version>2.4.0</not-before-version>\n\t</addon_aaa>\n\t<addon>bbb</addon>\n\t<addon_bbb>\n\t\t<name>Blah blah blah</name>\n\t\t<version>1</version>\n\t\t<file>bbb-beta-1.zap</file>\n\t\t<status>beta</status>\n\t\t<description>This could be a longer description for bbb</description>\n\t\t<changes>A list of changes for bbb</changes>\n\t\t<url>https://zap-extensions.googlecode.com/files/bbb-beta-1.zap</url>\n\t\t<size>23456</size>\n\t\t<not-before-version>2.4.0</not-before-version>\n\t</addon_bbb>\n</ZAP>";

    @Before
    public void setUp() throws Exception {
        this.configA = new ZapXmlConfiguration();
        this.configA.setDelimiterParsingDisabled(true);
        this.configA.load(new StringReader(CONF_A));
        this.configB = new ZapXmlConfiguration();
        this.configB.setDelimiterParsingDisabled(true);
        this.configB.load(new StringReader(CONF_B));
    }

    @Test
    public void testMainVersion() throws Exception {
        AddOnCollection addOnCollection = new AddOnCollection(this.configA, AddOnCollection.Platform.windows);
        Assert.assertThat((Object)addOnCollection.getZapRelease().getVersion(), (Matcher)Matchers.is((Object)"2.0.0"));
    }

    @Test
    public void testDailyUrl() throws Exception {
        AddOnCollection addOnCollection = new AddOnCollection(this.configA, AddOnCollection.Platform.daily);
        Assert.assertThat((Object)addOnCollection.getZapRelease().getUrl().toString(), (Matcher)Matchers.is((Object)"http://zaproxy.googlecode.com/files/ZAP_WEEKLY_D-2012-12-31.zip"));
    }

    @Test
    public void testWinUrl() throws Exception {
        AddOnCollection addOnCollection = new AddOnCollection(this.configA, AddOnCollection.Platform.windows);
        Assert.assertThat((Object)addOnCollection.getZapRelease().getUrl().toString(), (Matcher)Matchers.is((Object)"http://zaproxy.googlecode.com/files/ZAP_fake_windows_2.0.0.exe"));
    }

    @Test
    public void testLinuxUrl() throws Exception {
        AddOnCollection addOnCollection = new AddOnCollection(this.configA, AddOnCollection.Platform.linux);
        Assert.assertThat((Object)addOnCollection.getZapRelease().getUrl().toString(), (Matcher)Matchers.is((Object)"http://zaproxy.googlecode.com/files/ZAP_fake_linux_2.0.0.tar.gzip"));
    }

    @Test
    public void testMacUrl() throws Exception {
        AddOnCollection addOnCollection = new AddOnCollection(this.configA, AddOnCollection.Platform.mac);
        Assert.assertThat((Object)addOnCollection.getZapRelease().getUrl().toString(), (Matcher)Matchers.is((Object)"http://zaproxy.googlecode.com/files/ZAP_fake_mac_2.0.0.zip"));
    }

    @Test
    public void testDailyVersion() throws Exception {
        AddOnCollection addOnCollection = new AddOnCollection(this.configA, AddOnCollection.Platform.daily);
        Assert.assertThat((Object)addOnCollection.getZapRelease().getVersion(), (Matcher)Matchers.is((Object)"D-2012-12-31"));
    }

    @Test
    public void testUpdatedAddons() throws Exception {
        AddOnCollection addOnCollection = new AddOnCollection(this.configA, AddOnCollection.Platform.daily);
        AddOnCollection addOnCollection2 = new AddOnCollection(this.configB, AddOnCollection.Platform.daily);
        List<AddOn> list = addOnCollection2.getUpdatedAddOns(addOnCollection);
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)list.get(0).getId(), (Matcher)Matchers.is((Object)"bbb"));
    }

    @Test
    public void testNewAddons() throws Exception {
        AddOnCollection addOnCollection = new AddOnCollection(this.configA, AddOnCollection.Platform.daily);
        AddOnCollection addOnCollection2 = new AddOnCollection(this.configB, AddOnCollection.Platform.daily);
        List<AddOn> list = addOnCollection2.getNewAddOns(addOnCollection);
        Assert.assertThat((Object)list.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)list.get(0).getId(), (Matcher)Matchers.is((Object)"ddd"));
    }

    @Test
    public void shouldAcceptAddOnsWithoutDependencyIssues() throws Exception {
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration(DIRECTORY.resolve("ZapVersions-deps.xml").toFile());
        AddOnCollection addOnCollection = new AddOnCollection(zapXmlConfiguration, AddOnCollection.Platform.daily, false);
        Assert.assertThat((Object)addOnCollection.getAddOns().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)9)));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn1"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn2"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn3"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn4"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn5"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn6"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn7"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn8"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn9"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void shouldRejectAddOnsWithCircularDependencies() throws Exception {
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration(DIRECTORY.resolve("ZapVersions-cyclic-deps.xml").toFile());
        AddOnCollection addOnCollection = new AddOnCollection(zapXmlConfiguration, AddOnCollection.Platform.daily, false);
        Assert.assertThat((Object)addOnCollection.getAddOns().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)4)));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn2"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn3"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn8"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn9"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void shouldRejectAddOnsWithMissingDependencies() throws Exception {
        ZapXmlConfiguration zapXmlConfiguration = new ZapXmlConfiguration(DIRECTORY.resolve("ZapVersions-missing-deps.xml").toFile());
        AddOnCollection addOnCollection = new AddOnCollection(zapXmlConfiguration, AddOnCollection.Platform.daily, false);
        Assert.assertThat((Object)addOnCollection.getAddOns().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)3)));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn3"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn8"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)addOnCollection.getAddOn("AddOn9"), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }
}

