/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.zaproxy.zap.control.AddOn;

public class AddOnUnitTest {
    @Test
    public void testIsAddon() throws Exception {
        Assert.assertTrue((boolean)AddOn.isAddOn("test-alpha-1.zap"));
    }

    @Test
    public void testNotAddonNoState() throws Exception {
        Assert.assertFalse((boolean)AddOn.isAddOn("test-1.zap"));
    }

    @Test
    public void testNotAddonBadExt() throws Exception {
        Assert.assertFalse((boolean)AddOn.isAddOn("test-beta-1.zip"));
    }

    @Test
    public void testNotAddonBadStatus() throws Exception {
        Assert.assertFalse((boolean)AddOn.isAddOn("test-xxx-1.zap"));
    }

    @Test
    public void testNotAddonBadVersion() throws Exception {
        Assert.assertFalse((boolean)AddOn.isAddOn("test-beta-A.zap"));
    }

    @Test
    public void testId() throws Exception {
        AddOn addOn = new AddOn("test-alpha-1.zap");
        Assert.assertThat((Object)addOn.getId(), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    public void testStatus() throws Exception {
        AddOn addOn = new AddOn("test-alpha-1.zap");
        Assert.assertThat((Object)addOn.getStatus().name(), (Matcher)Matchers.is((Object)"alpha"));
    }

    @Test
    public void testVersion() throws Exception {
        AddOn addOn = new AddOn("test-alpha-1.zap");
        Assert.assertThat((Object)addOn.getFileVersion(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testAlpha2UpdatesAlpha1() throws Exception {
        AddOn addOn = new AddOn("test-alpha-1.zap");
        AddOn addOn2 = new AddOn("test-alpha-2.zap");
        Assert.assertTrue((boolean)addOn2.isUpdateTo(addOn));
    }

    @Test
    public void testAlpha1DoesNotUpdateAlpha2() throws Exception {
        AddOn addOn = new AddOn("test-alpha-1.zap");
        AddOn addOn2 = new AddOn("test-alpha-2.zap");
        Assert.assertFalse((boolean)addOn.isUpdateTo(addOn2));
    }

    @Test
    public void testAlpha2UpdatesBeta1() throws Exception {
        AddOn addOn = new AddOn("test-beta-1.zap");
        AddOn addOn2 = new AddOn("test-alpha-2.zap");
        Assert.assertTrue((boolean)addOn2.isUpdateTo(addOn));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAlpha2DoesNotUpdateTestyAlpha1() throws Exception {
        AddOn addOn = new AddOn("test-alpha-1.zap");
        AddOn addOn2 = new AddOn("testy-alpha-2.zap");
        addOn2.isUpdateTo(addOn);
    }

    @Test
    public void testCanLoadAddOnNotBefore() throws Exception {
        AddOn addOn = new AddOn("test-alpha-1.zap");
        addOn.setNotBeforeVersion("2.4.0");
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.4.0"));
        addOn.setNotBeforeVersion("2.4.0");
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.4.0"));
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.5.0"));
        Assert.assertFalse((boolean)addOn.canLoadInVersion("1.4.0"));
        Assert.assertFalse((boolean)addOn.canLoadInVersion("2.0.alpha"));
    }

    @Test
    public void testCanLoadAddOnNotFrom() throws Exception {
        AddOn addOn = new AddOn("test-alpha-1.zap");
        addOn.setNotBeforeVersion("2.4.0");
        addOn.setNotFromVersion("2.8.0");
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.4.0"));
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.5.0"));
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.7.0"));
        Assert.assertFalse((boolean)addOn.canLoadInVersion("2.8.0"));
        Assert.assertFalse((boolean)addOn.canLoadInVersion("2.8.0.1"));
        Assert.assertFalse((boolean)addOn.canLoadInVersion("2.9.0"));
    }

    @Test
    public void testCanLoadAddOnNotBeforeNotFrom() throws Exception {
        AddOn addOn = new AddOn("test-alpha-1.zap");
        addOn.setNotBeforeVersion("2.4.0");
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.4.0"));
        addOn.setNotFromVersion("2.7.0");
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.4.0"));
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.5.0"));
        Assert.assertTrue((boolean)addOn.canLoadInVersion("2.6.0"));
        Assert.assertFalse((boolean)addOn.canLoadInVersion("2.7.0"));
        Assert.assertFalse((boolean)addOn.canLoadInVersion("2.7.0.1"));
        Assert.assertFalse((boolean)addOn.canLoadInVersion("2.8.0"));
    }
}

