/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authentication;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.utils.ApiUtils;

public class AuthenticationAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(AuthenticationAPI.class);
    private static final String PREFIX = "authentication";
    private static final String VIEW_GET_AUTHENTICATION = "getAuthenticationMethod";
    private static final String VIEW_GET_LOGGED_IN_INDICATOR = "getLoggedInIndicator";
    private static final String VIEW_GET_LOGGED_OUT_INDICATOR = "getLoggedOutIndicator";
    private static final String VIEW_GET_METHOD_CONFIG_PARAMETERS = "getAuthenticationMethodConfigParams";
    private static final String VIEW_GET_SUPPORTED_METHODS = "getSupportedAuthenticationMethods";
    private static final String ACTION_SET_LOGGED_IN_INDICATOR = "setLoggedInIndicator";
    private static final String ACTION_SET_LOGGED_OUT_INDICATOR = "setLoggedOutIndicator";
    private static final String ACTION_SET_METHOD = "setAuthenticationMethod";
    public static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_LOGGED_IN_INDICATOR = "loggedInIndicatorRegex";
    private static final String PARAM_LOGGED_OUT_INDICATOR = "loggedOutIndicatorRegex";
    private static final String PARAM_METHOD_NAME = "authMethodName";
    private static final String PARAM_METHOD_CONFIG_PARAMS = "authMethodConfigParams";
    private Map<String, ApiDynamicActionImplementor> loadedAuthenticationMethodActions;

    public AuthenticationAPI(ExtensionAuthentication extensionAuthentication) {
        this.addApiView(new ApiView(VIEW_GET_SUPPORTED_METHODS));
        this.addApiView(new ApiView(VIEW_GET_METHOD_CONFIG_PARAMETERS, new String[]{PARAM_METHOD_NAME}));
        this.addApiView(new ApiView(VIEW_GET_AUTHENTICATION, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_LOGGED_IN_INDICATOR, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_LOGGED_OUT_INDICATOR, new String[]{PARAM_CONTEXT_ID}));
        this.loadedAuthenticationMethodActions = new HashMap<String, ApiDynamicActionImplementor>();
        if (extensionAuthentication != null) {
            for (AuthenticationMethodType authenticationMethodType : extensionAuthentication.getAuthenticationMethodTypes()) {
                ApiDynamicActionImplementor apiDynamicActionImplementor = authenticationMethodType.getSetMethodForContextApiAction();
                if (apiDynamicActionImplementor == null) continue;
                this.loadedAuthenticationMethodActions.put(apiDynamicActionImplementor.getName(), apiDynamicActionImplementor);
            }
        }
        this.addApiAction(new ApiAction(ACTION_SET_METHOD, new String[]{PARAM_CONTEXT_ID, PARAM_METHOD_NAME}, new String[]{PARAM_METHOD_CONFIG_PARAMS}));
        this.addApiAction(new ApiAction(ACTION_SET_LOGGED_IN_INDICATOR, new String[]{PARAM_CONTEXT_ID, PARAM_LOGGED_IN_INDICATOR}));
        this.addApiAction(new ApiAction(ACTION_SET_LOGGED_OUT_INDICATOR, new String[]{PARAM_CONTEXT_ID, PARAM_LOGGED_OUT_INDICATOR}));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiView " + string + " " + jSONObject.toString()));
        switch (string) {
            case "getAuthenticationMethod": {
                return this.getContext(jSONObject).getAuthenticationMethod().getApiResponseRepresentation();
            }
            case "getLoggedInIndicator": {
                Pattern pattern = this.getContext(jSONObject).getAuthenticationMethod().getLoggedInIndicatorPattern();
                if (pattern != null) {
                    return new ApiResponseElement("logged_in_regex", pattern.toString());
                }
                return new ApiResponseElement("logged_in_regex", "");
            }
            case "getLoggedOutIndicator": {
                Pattern pattern = this.getContext(jSONObject).getAuthenticationMethod().getLoggedOutIndicatorPattern();
                if (pattern != null) {
                    return new ApiResponseElement("logged_out_regex", pattern.toString());
                }
                return new ApiResponseElement("logged_out_regex", "");
            }
            case "getSupportedAuthenticationMethods": {
                ApiResponseList apiResponseList = new ApiResponseList("supportedMethods");
                for (ApiDynamicActionImplementor apiDynamicActionImplementor : this.loadedAuthenticationMethodActions.values()) {
                    apiResponseList.addItem(new ApiResponseElement("methodName", apiDynamicActionImplementor.getName()));
                }
                return apiResponseList;
            }
            case "getAuthenticationMethodConfigParams": {
                ApiDynamicActionImplementor apiDynamicActionImplementor = this.getSetMethodActionImplementor(jSONObject);
                return apiDynamicActionImplementor.buildParamsDescription();
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiAction " + string + " " + jSONObject.toString()));
        switch (string) {
            case "setLoggedInIndicator": {
                String string2 = jSONObject.getString(PARAM_LOGGED_IN_INDICATOR);
                if (string2 == null || string2.isEmpty()) {
                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_LOGGED_IN_INDICATOR);
                }
                this.getContext(jSONObject).getAuthenticationMethod().setLoggedInIndicatorPattern(string2);
                return ApiResponseElement.OK;
            }
            case "setLoggedOutIndicator": {
                String string3 = jSONObject.getString(PARAM_LOGGED_OUT_INDICATOR);
                if (string3 == null || string3.isEmpty()) {
                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_LOGGED_OUT_INDICATOR);
                }
                this.getContext(jSONObject).getAuthenticationMethod().setLoggedOutIndicatorPattern(string3);
                return ApiResponseElement.OK;
            }
            case "setAuthenticationMethod": {
                JSONObject jSONObject2 = jSONObject.has(PARAM_METHOD_CONFIG_PARAMS) ? API.getParams(jSONObject.getString(PARAM_METHOD_CONFIG_PARAMS)) : new JSONObject();
                jSONObject2.put((Object)PARAM_CONTEXT_ID, (Object)this.getContextId(jSONObject));
                this.getSetMethodActionImplementor(jSONObject).handleAction(jSONObject2);
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    private ApiDynamicActionImplementor getSetMethodActionImplementor(JSONObject jSONObject) throws ApiException {
        ApiDynamicActionImplementor apiDynamicActionImplementor = this.loadedAuthenticationMethodActions.get(ApiUtils.getNonEmptyStringParam(jSONObject, PARAM_METHOD_NAME));
        if (apiDynamicActionImplementor == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, "No authentication method type matches the provided value.");
        }
        return apiDynamicActionImplementor;
    }

    private Context getContext(JSONObject jSONObject) throws ApiException {
        int n = this.getContextId(jSONObject);
        Context context = Model.getSingleton().getSession().getContext(n);
        if (context == null) {
            throw new ApiException(ApiException.Type.CONTEXT_NOT_FOUND, PARAM_CONTEXT_ID);
        }
        return context;
    }

    private int getContextId(JSONObject jSONObject) throws ApiException {
        try {
            return jSONObject.getInt(PARAM_CONTEXT_ID);
        }
        catch (JSONException jSONException) {
            throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_CONTEXT_ID);
        }
    }

    private boolean hasContextId(JSONObject jSONObject) {
        try {
            jSONObject.getInt(PARAM_CONTEXT_ID);
        }
        catch (JSONException jSONException) {
            return false;
        }
        return true;
    }
}

