/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import org.apache.log4j.Logger;
import org.zaproxy.zap.utils.HashUtils;

public class Downloader
extends Thread {
    private URL url;
    private Proxy proxy;
    private File targetFile;
    private Exception exception = null;
    private long size = 0L;
    private boolean complete = false;
    private Date started = null;
    private Date finished = null;
    private boolean cancelDownload = false;
    private String hash = null;
    private boolean validated = false;
    private static final Logger logger = Logger.getLogger(Downloader.class);

    public Downloader(URL uRL, Proxy proxy, File file, String string) {
        this(uRL, proxy, file, 0L, string);
    }

    public Downloader(URL uRL, Proxy proxy, File file, long l, String string) {
        this.url = uRL;
        this.proxy = proxy;
        this.targetFile = file;
        this.size = l;
        this.hash = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block21: {
            Object object;
            this.started = new Date();
            BufferedInputStream bufferedInputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(this.url.openConnection(this.proxy).getInputStream());
                fileOutputStream = new FileOutputStream(this.targetFile);
                object = new byte[1024];
                while (!this.cancelDownload && (n = bufferedInputStream.read((byte[])object, 0, 1024)) != -1) {
                    fileOutputStream.write((byte[])object, 0, n);
                }
            }
            catch (Exception exception) {
                this.exception = exception;
            }
            finally {
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (this.hash != null && this.hash.indexOf(":") > 0) {
                object = this.hash.substring(0, this.hash.indexOf(":"));
                String string = this.hash.substring(this.hash.indexOf(":") + 1);
                try {
                    String string2 = HashUtils.getHash(this.targetFile, (String)object);
                    if (string2.equalsIgnoreCase(string)) {
                        this.validated = true;
                        break block21;
                    }
                    logger.debug((Object)("Wrong hash - expected " + string + " got " + string2));
                }
                catch (Exception exception) {
                    logger.debug((Object)"Error checking hash", (Throwable)exception);
                }
            } else {
                logger.debug((Object)"No hash, passing for now");
                this.validated = true;
            }
        }
        this.complete = true;
        this.finished = new Date();
        if (this.cancelDownload) {
            this.targetFile.delete();
        }
    }

    public void cancelDownload() {
        this.cancelDownload = true;
        if (this.complete && this.targetFile.exists()) {
            this.targetFile.delete();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public URL getUrl() {
        return this.url;
    }

    public File getTargetFile() {
        return this.targetFile;
    }

    public int getProgressPercent() {
        if (this.complete) {
            return 100;
        }
        if (this.size == 0L) {
            return 0;
        }
        return (int)(this.targetFile.length() * 100L / this.size);
    }

    public Date getStarted() {
        return this.started;
    }

    public Date getFinished() {
        return this.finished;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isValidated() {
        return this.validated;
    }
}

